/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.deviceconfig.sshscripting.impl;

import com.google.common.base.Strings;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.security.PublicKey;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.io.output.TeeOutputStream;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.SshClient;
import org.apache.sshd.client.channel.ClientChannel;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.kex.BuiltinDHFactories;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.BuiltinSignatures;
import org.apache.sshd.common.util.security.SecurityUtils;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.features.deviceconfig.sshscripting.SshScriptingService;
import org.opennms.features.deviceconfig.sshscripting.impl.SshInteraction;
import org.opennms.features.deviceconfig.sshscripting.impl.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshScriptingServiceImpl
implements SshScriptingService {
    private static Logger LOG = LoggerFactory.getLogger(SshScriptingServiceImpl.class);
    public static final String SCRIPT_VAR_TFTP_SERVER_IP = "tftpServerIp";
    private InetAddress tftpServerIPv4Address;
    private InetAddress tftpServerIPv6Address;
    boolean disableIOCollection;
    private String scriptDebugOutput;

    public void setTftpServerIPv4Address(String tftpServerIPv4Address) throws UnknownHostException {
        this.tftpServerIPv4Address = !Strings.isNullOrEmpty((String)tftpServerIPv4Address) ? InetAddress.getByName(tftpServerIPv4Address) : null;
    }

    public void setTftpServerIPv6Address(String tftpServerIPv6Address) throws UnknownHostException {
        this.tftpServerIPv6Address = !Strings.isNullOrEmpty((String)tftpServerIPv6Address) ? InetAddress.getByName(tftpServerIPv6Address) : null;
    }

    public void setDisableIOCollection(String value) {
        this.disableIOCollection = Boolean.parseBoolean(value);
    }

    @Override
    public SshScriptingService.Result execute(String script, String user, String password, String authKey, SocketAddress target, String hostKeyFingerprint, String shell, Map<String, String> vars, Duration timeout) {
        return (SshScriptingService.Result)Statement.parseScript(script).fold(errorLines -> SshScriptingService.Result.failure(errorLines.stream().collect(Collectors.joining("\n", "unrecognized statements:\n", ""))), statements -> {
            try {
                SshInteractionImpl sshInteraction = new SshInteractionImpl(user, password, authKey, target, hostKeyFingerprint, shell, vars, timeout, this.tftpServerIPv4Address, this.tftpServerIPv6Address, this.disableIOCollection);
                try {
                    LOG.debug("ssh connection successful, executing script: {}", (Object)script);
                    Statement prevStatement = null;
                    for (Statement statement : statements) {
                        try {
                            LOG.debug("ssh scripting service executing - {}", (Object)sshInteraction.replaceVars(statement.toString()));
                            statement.execute(sshInteraction);
                        }
                        catch (Exception e) {
                            String errorDescription = this.getErrorDescription(e, sshInteraction, prevStatement, statement);
                            String stdout = sshInteraction.stdout.toString(StandardCharsets.UTF_8);
                            String stderr = sshInteraction.stderr.toString(StandardCharsets.UTF_8);
                            String debugOutput = sshInteraction.getDebugOutput();
                            LOG.error("ssh scripting exception - {} \n### script ###\n {} \n### stdout ###\n {} \n### stderr ###\n {}", new Object[]{errorDescription, script, stdout, stderr, e});
                            SshScriptingService.Result result = SshScriptingService.Result.failure("ssh scripting exception - " + errorDescription, stdout, stderr, debugOutput);
                            sshInteraction.close();
                            return result;
                        }
                        this.scriptDebugOutput = sshInteraction.getDebugOutput();
                        prevStatement = statement;
                    }
                    SshScriptingService.Result result = SshScriptingService.Result.success("Script execution succeeded", sshInteraction.stdout.toString(StandardCharsets.UTF_8), sshInteraction.stderr.toString(StandardCharsets.UTF_8), sshInteraction.getDebugOutput());
                    return result;
                }
                finally {
                    try {
                        sshInteraction.close();
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        throwable2.addSuppressed(throwable);
                    }
                }
            }
            catch (Exception e) {
                LOG.error("error with ssh interactions", (Throwable)e);
                return SshScriptingService.Result.failure(e.getMessage());
            }
        });
    }

    private String getErrorDescription(Throwable t, SshInteraction sshInteraction, Statement prevStatement, Statement currentStatement) {
        if (currentStatement == null) {
            return t.getMessage();
        }
        String statementWithVars = sshInteraction.replaceVars(currentStatement.toString());
        if (prevStatement == null) {
            return t.getMessage() + " - encountered during initial " + statementWithVars + "\"";
        }
        String prevStatementWithVars = sshInteraction.replaceVars(prevStatement.toString());
        if (currentStatement.statementType == Statement.StatementType.await) {
            return t.getMessage() + " - encountered while waiting for \"" + statementWithVars + "\" following execution of \"" + prevStatementWithVars + "\"";
        }
        return t.getMessage() + " - encountered when sending input \"" + statementWithVars + "\" following successful \"" + prevStatementWithVars + "\"";
    }

    @Override
    public String getScriptOutput() {
        return this.scriptDebugOutput;
    }

    static boolean matchAndConsume(ByteArrayOutputStream awaitStdout, byte[] search) {
        byte[] bytes = awaitStdout.toByteArray();
        block0: for (int i = 0; i < bytes.length - search.length + 1; ++i) {
            for (int j = 0; j < search.length; ++j) {
                if (bytes[i + j] != search[j]) continue block0;
            }
            awaitStdout.reset();
            awaitStdout.write(bytes, i + search.length, bytes.length - i - search.length);
            return true;
        }
        return false;
    }

    private static class SshInteractionImpl
    implements SshInteraction,
    AutoCloseable {
        private final SshClient sshClient;
        private final ClientSession session;
        private final ClientChannel channel;
        private final ByteArrayOutputStream stdout;
        private final ByteArrayOutputStream stderr;
        private final ByteArrayOutputStream debugStdout;
        private final ByteArrayOutputStream debugStderr;
        private final ByteArrayOutputStream awaitStdout;
        private final PipedOutputStream pipeToStdin;
        private final ByteArrayOutputStream debugOutput;
        private final Map<String, String> vars = new HashMap<String, String>();
        private final Duration timeout;
        private final Instant timeoutInstant;
        private final boolean disableIOCollection;

        private SshInteractionImpl(String user, String password, String authKey, SocketAddress target, String hostKeyFingerprint, String shell, Map<String, String> vars, Duration timeout, InetAddress tftpServerIPv4Address, InetAddress tftpServerIPv6Address, boolean disableIOCollection) throws Exception {
            this.disableIOCollection = disableIOCollection;
            this.timeoutInstant = Instant.now().plus(timeout);
            this.sshClient = SshClient.setUpDefaultClient();
            this.sshClient.setServerKeyVerifier((clientSession, socketAddress, publicKey) -> {
                if (Strings.isNullOrEmpty((String)hostKeyFingerprint)) {
                    return true;
                }
                if (!socketAddress.equals(target)) {
                    return false;
                }
                return (Boolean)KeyUtils.checkFingerPrint((String)hostKeyFingerprint, (PublicKey)publicKey).getKey();
            });
            this.sshClient.setKeyExchangeFactories(NamedFactory.setUpTransformedFactories((boolean)false, (Collection)BuiltinDHFactories.VALUES, (Function)ClientBuilder.DH2KEX));
            this.sshClient.setSignatureFactories(new ArrayList(BuiltinSignatures.VALUES));
            this.sshClient.start();
            try {
                this.session = (ClientSession)((ConnectFuture)this.sshClient.connect(user, target).verify(Duration.between(Instant.now(), this.timeoutInstant))).getSession();
                InetAddress remoteAddress = ((InetSocketAddress)this.session.getRemoteAddress()).getAddress();
                InetAddress localAddress = remoteAddress instanceof Inet4Address ? (tftpServerIPv4Address != null ? tftpServerIPv4Address : ((InetSocketAddress)this.session.getLocalAddress()).getAddress()) : (tftpServerIPv6Address != null ? tftpServerIPv6Address : ((InetSocketAddress)this.session.getLocalAddress()).getAddress());
                try {
                    if (password != null) {
                        this.session.addPasswordIdentity(password);
                    }
                    if (!Strings.isNullOrEmpty((String)authKey)) {
                        try {
                            SecurityUtils.getKeyPairResourceParser().loadKeyPairs((SessionContext)this.session, NamedResource.ofName((String)"auth-key"), null, authKey).forEach(arg_0 -> ((ClientSession)this.session).addPublicKeyIdentity(arg_0));
                        }
                        catch (Exception e) {
                            LOG.error("Invalid ssh private key", (Throwable)e);
                        }
                    }
                    this.session.auth().verify(Duration.between(Instant.now(), this.timeoutInstant));
                    this.channel = Strings.isNullOrEmpty((String)shell) ? this.session.createShellChannel() : this.session.createExecChannel(shell);
                    try {
                        this.stdout = new ByteArrayOutputStream();
                        this.stderr = new ByteArrayOutputStream();
                        this.debugStdout = new ByteArrayOutputStream();
                        this.debugStderr = new ByteArrayOutputStream();
                        this.awaitStdout = new ByteArrayOutputStream();
                        this.debugOutput = new ByteArrayOutputStream();
                        TeeOutputStream debugTee = new TeeOutputStream((OutputStream)this.stdout, (OutputStream)this.debugStdout);
                        TeeOutputStream teeStdout = new TeeOutputStream((OutputStream)debugTee, (OutputStream)this.awaitStdout);
                        TeeOutputStream teeStderr = new TeeOutputStream((OutputStream)this.stderr, (OutputStream)this.debugStderr);
                        PipedInputStream stdin = new PipedInputStream();
                        this.pipeToStdin = new PipedOutputStream(stdin);
                        this.channel.setIn((InputStream)stdin);
                        this.channel.setOut((OutputStream)teeStdout);
                        this.channel.setErr((OutputStream)teeStderr);
                        this.channel.open().verify(Duration.between(Instant.now(), this.timeoutInstant));
                        this.vars.putAll(vars);
                        this.vars.put(SshScriptingServiceImpl.SCRIPT_VAR_TFTP_SERVER_IP, InetAddressUtils.str((InetAddress)localAddress));
                        this.vars.put("user", user);
                        this.vars.put("password", password);
                    }
                    catch (Exception e) {
                        this.channel.close();
                        throw e;
                    }
                }
                catch (Exception e) {
                    this.session.close();
                    throw e;
                }
            }
            catch (Exception e) {
                this.sshClient.stop();
                throw e;
            }
            this.timeout = timeout;
        }

        @Override
        public void close() throws Exception {
            try {
                try {
                    this.channel.close();
                }
                finally {
                    this.session.close();
                }
            }
            finally {
                this.sshClient.stop();
            }
        }

        @Override
        public void sendLine(String string) throws IOException {
            this.pipeToStdin.write((string + "\n").getBytes(StandardCharsets.UTF_8));
            this.pipeToStdin.flush();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void await(String string) throws Exception {
            byte[] search = string.getBytes(StandardCharsets.UTF_8);
            while (Instant.now().isBefore(this.timeoutInstant)) {
                ByteArrayOutputStream byteArrayOutputStream = this.awaitStdout;
                synchronized (byteArrayOutputStream) {
                    if (SshScriptingServiceImpl.matchAndConsume(this.awaitStdout, search)) {
                        if (!this.disableIOCollection) {
                            this.debugOutput.write(this.debugStderr.toString().getBytes(StandardCharsets.UTF_8));
                            this.debugOutput.write(this.debugStdout.toString().getBytes(StandardCharsets.UTF_8));
                        }
                        this.debugStdout.reset();
                        this.debugStderr.reset();
                        return;
                    }
                }
                Thread.sleep(1000L);
            }
            if (!this.disableIOCollection) {
                this.debugOutput.write(this.debugStderr.toString().getBytes(StandardCharsets.UTF_8));
                this.debugOutput.write(this.debugStdout.toString().getBytes(StandardCharsets.UTF_8));
            }
            throw new Exception("awaited output missing - expected: " + string);
        }

        @Override
        public String replaceVars(String string) {
            return StrSubstitutor.replace((Object)string, this.vars);
        }

        String getDebugOutput() {
            if (this.disableIOCollection) {
                return "Script IO collection is disabled";
            }
            return this.debugOutput.toString(StandardCharsets.UTF_8);
        }
    }
}

