/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.xml.eventconf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.core.xml.ValidateUsing;
import org.opennms.netmgt.config.utils.ConfigUtils;
import org.opennms.netmgt.xml.eventconf.EventMatcher;
import org.opennms.netmgt.xml.eventconf.EventMatchers;

@XmlRootElement(name="varbind")
@XmlAccessorType(value=XmlAccessType.NONE)
@ValidateUsing(value="eventconf.xsd")
@XmlType(propOrder={"m_vbnumber", "m_vboid", "m_values"})
public class Varbind
implements Serializable {
    private static final long serialVersionUID = 2L;
    private static final List<String> TEXTUAL_CONVENTIONS = Arrays.asList("PhysAddress", "MacAddress", "TruthValue", "TestAndIncr", "AutonomousType", "InstancePointer", "VariablePointer", "RowPointer", "RowStatus", "TimeStamp", "TimeInterval", "DateAndTime", "StorageType", "TDomain", "TAddress");
    @XmlAttribute(name="textual-convention", required=false)
    private String m_textualConvention;
    @XmlElement(name="vbnumber", required=false)
    private Integer m_vbnumber;
    @XmlElement(name="vboid", required=false)
    private String m_vboid;
    @XmlElement(name="vbvalue", required=true)
    private List<String> m_values = new ArrayList<String>();

    public String getTextualConvention() {
        return this.m_textualConvention;
    }

    public void setTextualConvention(String textualConvention) {
        this.m_textualConvention = ConfigUtils.assertOnlyContains(textualConvention, TEXTUAL_CONVENTIONS, "textual-convention");
        if (this.m_textualConvention != null) {
            this.m_textualConvention = this.m_textualConvention.intern();
        }
    }

    public Integer getVbnumber() {
        return this.m_vbnumber;
    }

    public void setVbnumber(Integer vbnumber) {
        this.m_vbnumber = vbnumber;
    }

    public List<String> getVbvalues() {
        return this.m_values;
    }

    public void setVbvalues(List<String> values) {
        if (values == this.m_values) {
            return;
        }
        this.m_values.clear();
        if (values != null) {
            this.m_values.addAll(values);
        }
    }

    public void addVbvalue(String value) throws IndexOutOfBoundsException {
        this.m_values.add(value == null ? null : value.intern());
    }

    public boolean removeVbvalue(String value) {
        return this.m_values.remove(value);
    }

    public String getVboid() {
        return this.m_vboid;
    }

    public void setVboid(String vboid) {
        this.m_vboid = vboid;
    }

    public int hashCode() {
        return Objects.hash(this.m_textualConvention, this.m_vbnumber, this.m_vboid, this.m_values);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Varbind) {
            Varbind that = (Varbind)obj;
            return Objects.equals(this.m_textualConvention, that.m_textualConvention) && Objects.equals(this.m_vbnumber, that.m_vbnumber) && Objects.equals(this.m_vboid, that.m_vboid) && Objects.equals(this.m_values, that.m_values);
        }
        return false;
    }

    public EventMatcher constructMatcher() {
        if (this.m_vbnumber == null && this.m_vboid == null) {
            return EventMatchers.trueMatcher();
        }
        if (this.m_vbnumber != null) {
            ArrayList<EventMatcher> valueMatchers = new ArrayList<EventMatcher>(this.m_values.size());
            for (String value : this.m_values) {
                if (value == null) continue;
                if (value.startsWith("~")) {
                    valueMatchers.add(EventMatchers.valueMatchesRegexMatcher(EventMatchers.varbind(this.m_vbnumber), value));
                    continue;
                }
                if (value.endsWith("%")) {
                    valueMatchers.add(EventMatchers.valueStartsWithMatcher(EventMatchers.varbind(this.m_vbnumber), value));
                    continue;
                }
                valueMatchers.add(EventMatchers.valueEqualsMatcher(EventMatchers.varbind(this.m_vbnumber), value));
            }
            if (valueMatchers.size() == 1) {
                return (EventMatcher)valueMatchers.get(0);
            }
            EventMatcher[] matchers = valueMatchers.toArray(new EventMatcher[valueMatchers.size()]);
            return EventMatchers.or(matchers);
        }
        ArrayList<EventMatcher> valueMatchers = new ArrayList<EventMatcher>(this.m_values.size());
        for (String value : this.m_values) {
            if (value == null) continue;
            valueMatchers.add(EventMatchers.valueEqualsMatcher(EventMatchers.varbind(this.m_vboid), value));
        }
        if (valueMatchers.size() == 1) {
            return (EventMatcher)valueMatchers.get(0);
        }
        EventMatcher[] matchers = valueMatchers.toArray(new EventMatcher[valueMatchers.size()]);
        return EventMatchers.or(matchers);
    }
}

