/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.syslog;

import org.graylog2.syslog4j.Syslog;
import org.graylog2.syslog4j.SyslogConfigIF;
import org.graylog2.syslog4j.SyslogRuntimeException;
import org.graylog2.syslog4j.impl.net.tcp.TCPNetSyslogConfig;
import org.graylog2.syslog4j.impl.net.udp.UDPNetSyslogConfig;
import org.opennms.netmgt.alarmd.northbounder.syslog.SyslogDestination;
import org.opennms.netmgt.model.OnmsSeverity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SyslogUtils {
    private static final Logger LOG = LoggerFactory.getLogger(SyslogUtils.class);

    public static void createNorthboundInstance(SyslogDestination destination) throws SyslogRuntimeException {
        LOG.info("Creating Syslog Northbound Instance {}", (Object)destination.getName());
        int facility = SyslogUtils.convertFacility(destination.getFacility());
        SyslogDestination.SyslogProtocol protocol = destination.getProtocol();
        SyslogConfigIF instanceConfiguration = SyslogUtils.createConfig(destination, protocol, facility);
        instanceConfiguration.setIdent("OpenNMS");
        instanceConfiguration.setCharSet(destination.getCharSet());
        instanceConfiguration.setMaxMessageLength(destination.getMaxMessageLength().intValue());
        instanceConfiguration.setSendLocalName(destination.isSendLocalName().booleanValue());
        instanceConfiguration.setSendLocalTimestamp(destination.isSendLocalTime().booleanValue());
        instanceConfiguration.setTruncateMessage(destination.isTruncateMessage().booleanValue());
        try {
            Syslog.createInstance((String)destination.getName(), (SyslogConfigIF)instanceConfiguration);
        }
        catch (SyslogRuntimeException e) {
            LOG.error("Could not create northbound instance, '{}': {}", (Object)destination.getName(), (Object)e);
            throw e;
        }
    }

    public static SyslogConfigIF createConfig(SyslogDestination dest, SyslogDestination.SyslogProtocol protocol, int fac) {
        return switch (protocol) {
            case SyslogDestination.SyslogProtocol.UDP -> new UDPNetSyslogConfig(fac, dest.getHost(), dest.getPort().intValue());
            case SyslogDestination.SyslogProtocol.TCP -> new TCPNetSyslogConfig(fac, dest.getHost(), dest.getPort().intValue());
            default -> new UDPNetSyslogConfig(fac, "localhost", 514);
        };
    }

    public static int convertFacility(SyslogDestination.SyslogFacility facility) {
        return switch (facility) {
            case SyslogDestination.SyslogFacility.KERN -> 0;
            case SyslogDestination.SyslogFacility.USER -> 8;
            case SyslogDestination.SyslogFacility.MAIL -> 16;
            case SyslogDestination.SyslogFacility.DAEMON -> 24;
            case SyslogDestination.SyslogFacility.AUTH -> 32;
            case SyslogDestination.SyslogFacility.SYSLOG -> 40;
            case SyslogDestination.SyslogFacility.LPR -> 48;
            case SyslogDestination.SyslogFacility.NEWS -> 56;
            case SyslogDestination.SyslogFacility.UUCP -> 64;
            case SyslogDestination.SyslogFacility.CRON -> 72;
            case SyslogDestination.SyslogFacility.AUTHPRIV -> 80;
            case SyslogDestination.SyslogFacility.FTP -> 88;
            case SyslogDestination.SyslogFacility.LOCAL0 -> 128;
            case SyslogDestination.SyslogFacility.LOCAL1 -> 136;
            case SyslogDestination.SyslogFacility.LOCAL2 -> 144;
            case SyslogDestination.SyslogFacility.LOCAL3 -> 152;
            case SyslogDestination.SyslogFacility.LOCAL4 -> 160;
            case SyslogDestination.SyslogFacility.LOCAL5 -> 168;
            case SyslogDestination.SyslogFacility.LOCAL6 -> 176;
            case SyslogDestination.SyslogFacility.LOCAL7 -> 184;
            default -> 8;
        };
    }

    public static int determineLogLevel(OnmsSeverity severity) {
        return switch (severity) {
            case OnmsSeverity.CRITICAL -> 2;
            case OnmsSeverity.MAJOR -> 3;
            case OnmsSeverity.MINOR -> 3;
            case OnmsSeverity.WARNING -> 4;
            case OnmsSeverity.NORMAL -> 5;
            case OnmsSeverity.CLEARED -> 6;
            case OnmsSeverity.INDETERMINATE -> 7;
            default -> 4;
        };
    }
}

