/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.measurements.impl;

import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.measurements.api.FetchResults;
import org.opennms.netmgt.measurements.api.MeasurementFetchStrategy;
import org.opennms.netmgt.measurements.model.QueryMetadata;
import org.opennms.netmgt.measurements.model.QueryNode;
import org.opennms.netmgt.measurements.model.QueryResource;
import org.opennms.netmgt.measurements.model.Source;
import org.opennms.netmgt.measurements.utils.Utils;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.ResourceTypeUtils;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.rrd.RrdException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.orm.ObjectRetrievalFailureException;

public abstract class AbstractRrdBasedFetchStrategy
implements MeasurementFetchStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractRrdBasedFetchStrategy.class);
    @Autowired
    private ResourceDao m_resourceDao;

    public FetchResults fetch(long start, long end, long step, int maxrows, Long interval, Long heartbeat, List<Source> sources, boolean relaxed) throws Exception {
        HashMap constants = Maps.newHashMap();
        ArrayList<Object> resources = new ArrayList<Object>();
        ArrayList<QueryResource> additionalResources = new ArrayList<QueryResource>();
        HashMap rrdsBySource = Maps.newHashMap();
        HashMap<ResourceId, OnmsResource> resourceCache = new HashMap<ResourceId, OnmsResource>();
        for (Source source : sources) {
            ResourceId resourceId;
            try {
                resourceId = ResourceId.fromString((String)source.getResourceId());
            }
            catch (IllegalArgumentException ex) {
                if (relaxed) continue;
                LOG.error("Ill-formed resource id: {}", (Object)source.getResourceId(), (Object)ex);
                resources.add(null);
                return null;
            }
            OnmsResource resource = resourceCache.computeIfAbsent(resourceId, r -> this.m_resourceDao.getResourceById(r));
            if (resource == null) {
                if (relaxed) {
                    OnmsResource parentResource = resourceCache.computeIfAbsent(resourceId, r -> this.m_resourceDao.getResourceById(r.getParent()));
                    if (parentResource == null) continue;
                    QueryResource parentResourceInfo = AbstractRrdBasedFetchStrategy.getResourceInfo(parentResource, source);
                    additionalResources.add(parentResourceInfo);
                    continue;
                }
                LOG.error("No resource with id: {}", (Object)source.getResourceId());
                resources.add(null);
                return null;
            }
            QueryResource resourceInfo = AbstractRrdBasedFetchStrategy.getResourceInfo(resource, source);
            resources.add(resourceInfo);
            RrdGraphAttribute rrdGraphAttribute = (RrdGraphAttribute)resource.getRrdGraphAttributes().get(source.getAttribute());
            if (rrdGraphAttribute == null && !Strings.isNullOrEmpty((String)source.getFallbackAttribute())) {
                LOG.error("No attribute with name '{}', using fallback-attribute with name '{}'", (Object)source.getAttribute(), (Object)source.getFallbackAttribute());
                source.setAttribute(source.getFallbackAttribute());
                source.setFallbackAttribute(null);
                rrdGraphAttribute = (RrdGraphAttribute)resource.getRrdGraphAttributes().get(source.getAttribute());
            }
            if (rrdGraphAttribute == null) {
                if (relaxed) continue;
                LOG.error("No attribute with name: {}", (Object)source.getAttribute());
                return null;
            }
            Utils.convertStringAttributesToConstants((String)source.getLabel(), (Map)resource.getStringPropertyAttributes(), (Map)constants);
            String rrdFile = System.getProperty("rrd.base.dir") + File.separator + rrdGraphAttribute.getRrdRelativePath();
            rrdsBySource.put(source, rrdFile);
        }
        if (!additionalResources.isEmpty()) {
            resources.addAll(additionalResources);
        }
        return this.fetchMeasurements(start, end, step, maxrows, rrdsBySource, constants, sources, new QueryMetadata(resources), relaxed);
    }

    private FetchResults fetchMeasurements(long start, long end, long step, int maxrows, Map<Source, String> rrdsBySource, Map<String, Object> constants, List<Source> sources, QueryMetadata metadata, boolean relaxed) throws RrdException {
        if (relaxed && rrdsBySource.isEmpty()) {
            return Utils.createEmtpyFetchResults((long)step, constants);
        }
        FetchResults fetchResults = this.fetchMeasurements(start, end, step, maxrows, rrdsBySource, constants, metadata);
        if (relaxed) {
            Utils.fillMissingValues((FetchResults)fetchResults, sources);
        }
        return fetchResults;
    }

    protected abstract FetchResults fetchMeasurements(long var1, long var3, long var5, int var7, Map<Source, String> var8, Map<String, Object> var9, QueryMetadata var10) throws RrdException;

    private static QueryResource getResourceInfo(OnmsResource resource, Source source) {
        if (resource == null) {
            return null;
        }
        OnmsNode node = null;
        try {
            node = ResourceTypeUtils.getNodeFromResourceRoot((OnmsResource)resource);
        }
        catch (ObjectRetrievalFailureException e) {
            LOG.warn("Failed to get node info from resource: {}", (Object)resource, (Object)e);
        }
        return new QueryResource(resource.getId().toString(), resource.getParent() == null ? null : resource.getParent().getId().toString(), resource.getLabel(), resource.getName(), node == null ? null : new QueryNode(node.getId(), node.getForeignSource(), node.getForeignId(), node.getLabel()));
    }
}

