/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.profile.assembly;

import java.net.MalformedURLException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.karaf.features.BundleInfo;
import org.apache.karaf.features.internal.download.Downloader;
import org.apache.karaf.features.internal.download.StreamProvider;
import org.apache.karaf.features.internal.download.impl.DownloadManagerHelper;
import org.apache.karaf.features.internal.service.Blacklist;
import org.apache.karaf.util.maven.Parser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactInstaller {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactInstaller.class);
    private Path systemDirectory;
    private Downloader downloader;
    private Blacklist blacklist;

    public ArtifactInstaller(Path systemDirectory, Downloader downloader, Blacklist blacklist) {
        this.systemDirectory = systemDirectory;
        this.downloader = downloader;
        this.blacklist = blacklist;
    }

    public void installArtifact(BundleInfo bundle) throws Exception {
        if (bundle.isBlacklisted()) {
            LOGGER.info("      skipping blacklisted maven artifact: " + bundle.getLocation());
            return;
        }
        if (bundle.isOverriden() != BundleInfo.BundleOverrideMode.NONE) {
            LOGGER.info("      adding overriden maven artifact: " + bundle.getLocation() + " (original location: " + bundle.getOriginalLocation() + ")");
        } else {
            LOGGER.info("      adding maven artifact: " + bundle.getLocation());
        }
        String location = bundle.getLocation().trim();
        location = this.removeTrailingSlash(DownloadManagerHelper.stripUrl((String)location));
        if (!location.startsWith("mvn:")) {
            LOGGER.warn("Ignoring non maven artifact " + location);
            return;
        }
        String finalLocation = location;
        this.downloader.download(location, provider -> {
            String uri = provider.getUrl();
            Path path = ArtifactInstaller.pathFromProviderUrl(this.systemDirectory, finalLocation);
            StreamProvider streamProvider = provider;
            synchronized (streamProvider) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(provider.getFile().toPath(), path, StandardCopyOption.REPLACE_EXISTING);
            }
        });
    }

    public void installArtifact(String location) throws Exception {
        LOGGER.info("      adding maven artifact: " + location);
        location = this.removeTrailingSlash(DownloadManagerHelper.stripUrl((String)location));
        if (!location.startsWith("mvn:")) {
            LOGGER.warn("Ignoring non maven artifact " + location);
            return;
        }
        String finalLocation = location;
        this.downloader.download(location, provider -> {
            String uri = provider.getUrl();
            if (this.blacklist.isBundleBlacklisted(finalLocation)) {
                throw new RuntimeException("Bundle " + finalLocation + " is blacklisted");
            }
            Path path = ArtifactInstaller.pathFromProviderUrl(this.systemDirectory, finalLocation);
            StreamProvider streamProvider = provider;
            synchronized (streamProvider) {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.copy(provider.getFile().toPath(), path, StandardCopyOption.REPLACE_EXISTING);
            }
        });
    }

    private String removeTrailingSlash(String location) {
        return location.endsWith("/") ? location.substring(0, location.length() - 1) : location;
    }

    public static Path pathFromProviderUrl(Path systemDirectory, String url) throws MalformedURLException {
        if (url.startsWith("file:")) {
            return Paths.get(URI.create(url));
        }
        String pathString = url.startsWith("mvn:") ? Parser.pathFromMaven(url) : url;
        return systemDirectory.resolve(pathString);
    }
}

