/*
 * Decompiled with CFR 0.152.
 */
package org.ops4j.pax.exam.raw.extender.intern;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.ops4j.pax.exam.ProbeInvoker;
import org.ops4j.pax.exam.TestContainerException;
import org.ops4j.pax.exam.raw.extender.intern.NoOpInjector;
import org.ops4j.pax.exam.util.Injector;
import org.ops4j.pax.swissbox.tracker.ServiceLookup;
import org.osgi.framework.BundleContext;

public class ProbeInvokerImpl
implements ProbeInvoker {
    private BundleContext ctx;
    private String clazz;
    private String method;
    private Injector injector;

    public ProbeInvokerImpl(String encodedInstruction, BundleContext bundleContext) {
        String[] parts = encodedInstruction.split(";");
        this.clazz = parts[0];
        this.method = parts[1];
        this.ctx = bundleContext;
        boolean inject = true;
        this.injector = inject ? (Injector)ServiceLookup.getService((BundleContext)this.ctx, Injector.class) : new NoOpInjector();
    }

    public void call(Object ... args) {
        Class testClass;
        try {
            testClass = this.ctx.getBundle().loadClass(this.clazz);
        }
        catch (ClassNotFoundException e) {
            throw new TestContainerException((Throwable)e);
        }
        if (!this.findAndInvoke(testClass, args)) {
            throw new TestContainerException(" Test " + this.method + " not found in test class " + testClass.getName());
        }
    }

    private boolean findAndInvoke(Class<?> testClass, Object ... params) {
        try {
            for (Method m : testClass.getMethods()) {
                if (!m.getName().equals(this.method)) continue;
                this.injectContextAndInvoke(testClass.newInstance(), m, params);
                return true;
            }
        }
        catch (NoClassDefFoundError e) {
            throw new TestContainerException((Throwable)e);
        }
        catch (InstantiationException e) {
            throw new TestContainerException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestContainerException((Throwable)e);
        }
        return false;
    }

    private void injectContextAndInvoke(Object testInstance, Method testMethod, Object[] params) {
        Class<?>[] paramTypes = testMethod.getParameterTypes();
        this.injector.injectFields(testInstance);
        try {
            if (paramTypes.length == 0) {
                testMethod.invoke(testInstance, new Object[0]);
            } else {
                Object[] parameters = this.injectHook(testMethod, params);
                testMethod.invoke(testInstance, parameters);
            }
        }
        catch (InvocationTargetException e) {
            throw new TestContainerException((Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new TestContainerException((Throwable)e);
        }
    }

    private Object[] injectHook(Method testMethod, Object[] params) {
        Class<?>[] paramTypes = testMethod.getParameterTypes();
        Object[] ret = new Object[paramTypes.length];
        Annotation[][] paramAnnotations = testMethod.getParameterAnnotations();
        int paramCursor = 0;
        for (int i = 0; i < ret.length; ++i) {
            if (i == 0) {
                ret[0] = this.ctx;
                continue;
            }
            if (paramAnnotations[i].length > 0) {
                throw new RuntimeException("Parameter " + i + " on " + testMethod.getName() + " has Annotation. Not supported until Pax Exam 2.1");
            }
            ret[i] = params.length > paramCursor ? params[paramCursor++] : null;
        }
        return ret;
    }
}

