/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.enrichment;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.NodeRef;
import org.opennms.netmgt.graph.api.NodeService;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentGraphBuilder;
import org.opennms.netmgt.graph.api.enrichment.EnrichmentProcessor;
import org.opennms.netmgt.graph.api.generic.GenericGraph;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.info.StatusInfo;
import org.opennms.netmgt.graph.enrichment.EnrichmentUtils;

public class StatusEnrichmentProcessor
implements EnrichmentProcessor {
    private final NodeService nodeService;

    public StatusEnrichmentProcessor(NodeService nodeService) {
        this.nodeService = Objects.requireNonNull(nodeService);
    }

    public boolean canEnrich(GenericGraph graph) {
        return EnrichmentUtils.parseBoolean(graph.getProperties(), "enrichment.defaultStatus");
    }

    public void enrich(EnrichmentGraphBuilder graphBuilder) {
        List nodeRefs = graphBuilder.getVertices().stream().map(GenericVertex::getNodeRef).filter(Objects::nonNull).collect(Collectors.toList());
        Map statusInfos = this.nodeService.resolveStatus(nodeRefs);
        for (Map.Entry eachEntry : statusInfos.entrySet()) {
            graphBuilder.resolveVertices((NodeRef)eachEntry.getKey()).forEach(vertex -> graphBuilder.property(vertex, "status", (Object)((StatusInfo)eachEntry.getValue())));
        }
    }
}

