/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.elastic.client.model;

import java.util.ArrayList;
import java.util.List;

public class BulkResponse {
    private final boolean hasErrors;
    private final List<BulkItemResponse> items;
    private final long tookInMillis;

    public BulkResponse(boolean hasErrors, List<BulkItemResponse> items, long tookInMillis) {
        this.hasErrors = hasErrors;
        this.items = items != null ? new ArrayList<BulkItemResponse>(items) : new ArrayList();
        this.tookInMillis = tookInMillis;
    }

    public boolean hasErrors() {
        return this.hasErrors;
    }

    public List<BulkItemResponse> getItems() {
        return this.items;
    }

    public long getTookInMillis() {
        return this.tookInMillis;
    }

    public List<BulkItemResponse> getFailedItems() {
        return this.items.stream().filter(BulkItemResponse::isFailed).toList();
    }

    public String getErrors() {
        StringBuilder errorBuilder = new StringBuilder();
        List<BulkItemResponse> failedItems = this.getFailedItems();
        if (!failedItems.isEmpty()) {
            errorBuilder.append("Bulk request failed with ").append(failedItems.size()).append(" errors:\n");
            for (int i = 0; i < Math.min(5, failedItems.size()); ++i) {
                BulkItemResponse item = failedItems.get(i);
                errorBuilder.append("  [").append(item.getIndex()).append("/").append(item.getId() != null ? item.getId() : "<auto-generated>").append("] ").append(item.getError()).append("\n");
            }
            if (failedItems.size() > 5) {
                errorBuilder.append("  ... and ").append(failedItems.size() - 5).append(" more errors\n");
            }
        }
        return errorBuilder.toString();
    }

    public static class BulkItemResponse {
        private final String index;
        private final String id;
        private final int status;
        private final String error;
        private final boolean failed;

        public BulkItemResponse(String index, String id, int status, String error) {
            this.index = index;
            this.id = id;
            this.status = status;
            this.error = error;
            this.failed = status >= 400 || error != null;
        }

        public String getIndex() {
            return this.index;
        }

        public String getId() {
            return this.id;
        }

        public int getStatus() {
            return this.status;
        }

        public String getError() {
            return this.error;
        }

        public boolean isFailed() {
            return this.failed;
        }
    }
}

