/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.core.db.install;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.opennms.core.db.install.Trigger;

public class TriggerDao {
    private Map<String, Trigger> m_nameMap;
    private Map<String, List<Trigger>> m_tableMap;

    public TriggerDao() {
        this.reset();
    }

    public void reset() {
        this.m_nameMap = new LinkedHashMap<String, Trigger>();
        this.m_tableMap = new HashMap<String, List<Trigger>>();
    }

    public void add(Trigger t) {
        String lowerName = t.getName().toLowerCase();
        if (this.m_nameMap.containsKey(lowerName)) {
            throw new IllegalArgumentException("Trigger with name of '" + lowerName + "' already exists.");
        }
        this.m_nameMap.put(lowerName, t);
        this.getTriggersForTableCreateIfEmpty(t.getTable().toLowerCase()).add(t);
    }

    private List<Trigger> getTriggersForTableCreateIfEmpty(String table) {
        if (!this.m_tableMap.containsKey(table)) {
            this.m_tableMap.put(table, new LinkedList());
        }
        return this.m_tableMap.get(table);
    }

    public List<Trigger> getTriggersForTable(String table) {
        String lowerName = table.toLowerCase();
        if (!this.m_tableMap.containsKey(lowerName)) {
            return new LinkedList<Trigger>();
        }
        return this.m_tableMap.get(lowerName);
    }
}

