/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.apilayer.config;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.opennms.features.apilayer.config.ConfigExtensionManager;
import org.opennms.integration.api.v1.config.poller.AddressRange;
import org.opennms.integration.api.v1.config.poller.Downtime;
import org.opennms.integration.api.v1.config.poller.Monitor;
import org.opennms.integration.api.v1.config.poller.PollerConfigurationExtension;
import org.opennms.integration.api.v1.config.poller.Rrd;
import org.opennms.integration.api.v1.config.poller.Service;
import org.opennms.netmgt.config.PollerConfig;
import org.opennms.netmgt.config.poller.ExcludeRange;
import org.opennms.netmgt.config.poller.IncludeRange;
import org.opennms.netmgt.config.poller.Package;
import org.opennms.netmgt.config.poller.Parameter;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.model.events.EventBuilder;

public class PollerConfExtensionManager
extends ConfigExtensionManager<PollerConfigurationExtension, PollerConfigurationPart> {
    private final PollerConfig pollerConfig;
    private final EventForwarder eventForwarder;

    public PollerConfExtensionManager(PollerConfig pollerConfig, EventForwarder eventForwarder) {
        super(PollerConfigurationPart.class, new PollerConfigurationPart());
        this.pollerConfig = Objects.requireNonNull(pollerConfig);
        this.eventForwarder = Objects.requireNonNull(eventForwarder);
    }

    @Override
    protected PollerConfigurationPart getConfigForExtensions(Set<PollerConfigurationExtension> extensions) {
        PollerConfigurationPart pollerConfigurationPart = new PollerConfigurationPart();
        pollerConfigurationPart.packages = extensions.stream().flatMap(pce -> pce.getPackages().stream()).map(PollerConfExtensionManager::map).collect(Collectors.toUnmodifiableList());
        pollerConfigurationPart.monitors = extensions.stream().flatMap(pce -> pce.getMonitors().stream()).map(PollerConfExtensionManager::map).collect(Collectors.toUnmodifiableList());
        return pollerConfigurationPart;
    }

    @Override
    protected void triggerReload() {
        PollerConfigurationPart object = (PollerConfigurationPart)this.getObject();
        this.pollerConfig.setExternalData(object.packages, object.monitors);
        this.eventForwarder.sendNow(new EventBuilder("uei.opennms.org/internal/reloadDaemonConfig", "oia-plugins").addParam("daemonName", "pollerd").getEvent());
    }

    public static org.opennms.netmgt.config.poller.Monitor map(Monitor apiMonitor) {
        org.opennms.netmgt.config.poller.Monitor result = new org.opennms.netmgt.config.poller.Monitor();
        result.setClassName(apiMonitor.getClassName());
        result.setParameters(apiMonitor.getParameters().stream().map(PollerConfExtensionManager::map).collect(Collectors.toList()));
        result.setService(apiMonitor.getService());
        return result;
    }

    public static Parameter map(org.opennms.integration.api.v1.config.poller.Parameter apiParameter) {
        Parameter result = new Parameter();
        result.setKey(apiParameter.getKey());
        result.setValue(apiParameter.getValue());
        return result;
    }

    public static Package map(org.opennms.integration.api.v1.config.poller.Package apiPackage) {
        Package result = new Package();
        result.setDowntimes(apiPackage.getDowntimes().stream().map(PollerConfExtensionManager::map).collect(Collectors.toList()));
        result.setName(apiPackage.getName());
        result.setFilter(apiPackage.getFilter());
        result.setSpecifics(apiPackage.getSpecifics());
        result.setIncludeRanges(apiPackage.getIncludeRanges().stream().map(PollerConfExtensionManager::mapIncludeRanges).collect(Collectors.toList()));
        result.setExcludeRanges(apiPackage.getExcludeRanges().stream().map(PollerConfExtensionManager::mapExcludeRanges).collect(Collectors.toList()));
        result.setRrd(PollerConfExtensionManager.map(apiPackage.getRrd()));
        result.setServices(apiPackage.getServices().stream().map(PollerConfExtensionManager::map).collect(Collectors.toList()));
        result.setOutageCalendars(apiPackage.getOutageCalendars());
        return result;
    }

    private static org.opennms.netmgt.config.poller.Service map(Service apiService) {
        org.opennms.netmgt.config.poller.Service result = new org.opennms.netmgt.config.poller.Service();
        result.setName(apiService.getName());
        result.setUserDefined(apiService.isUserDefined() ? "true" : "false");
        result.setStatus(apiService.isEnabled() ? "on" : "off");
        result.setPattern((String)apiService.getPattern().orElse(null));
        result.setParameters(apiService.getParameters().stream().map(PollerConfExtensionManager::map).collect(Collectors.toList()));
        result.setInterval(Long.valueOf(apiService.getInterval()));
        return result;
    }

    private static IncludeRange mapIncludeRanges(AddressRange addressRange) {
        IncludeRange result = new IncludeRange();
        result.setBegin(addressRange.getBegin());
        result.setEnd(addressRange.getEnd());
        return result;
    }

    private static ExcludeRange mapExcludeRanges(AddressRange addressRange) {
        ExcludeRange result = new ExcludeRange();
        result.setBegin(addressRange.getBegin());
        result.setEnd(addressRange.getEnd());
        return result;
    }

    public static org.opennms.netmgt.config.poller.Downtime map(Downtime apiDowntime) {
        org.opennms.netmgt.config.poller.Downtime result = new org.opennms.netmgt.config.poller.Downtime();
        result.setBegin(Long.valueOf(apiDowntime.getBegin().getSeconds()));
        result.setInterval((Long)apiDowntime.getInterval().orElse(null));
        result.setEnd((Long)apiDowntime.getEnd().map(Duration::getSeconds).orElse(null));
        if (apiDowntime.getDelete().isPresent()) {
            Downtime.DeletingMode deletingMode = (Downtime.DeletingMode)apiDowntime.getDelete().get();
            switch (deletingMode) {
                case ALWAYS: {
                    result.setDelete("always");
                    break;
                }
                case MANAGED: {
                    result.setDelete("managed");
                    break;
                }
                case NEVER: {
                    result.setDelete("never");
                }
            }
        } else {
            result.setDelete(null);
        }
        return result;
    }

    public static org.opennms.netmgt.config.poller.Rrd map(Rrd apiRrd) {
        org.opennms.netmgt.config.poller.Rrd result = new org.opennms.netmgt.config.poller.Rrd();
        result.setStep(Integer.valueOf(apiRrd.getStep()));
        result.setRras(apiRrd.getRras());
        return result;
    }

    public static class PollerConfigurationPart {
        private List<Package> packages = new ArrayList<Package>();
        private List<org.opennms.netmgt.config.poller.Monitor> monitors = new ArrayList<org.opennms.netmgt.config.poller.Monitor>();

        public List<Package> getPackages() {
            return this.packages;
        }

        public List<org.opennms.netmgt.config.poller.Monitor> getMonitors() {
            return this.monitors;
        }
    }
}

