/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.api.generic;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.netmgt.graph.api.Edge;
import org.opennms.netmgt.graph.api.ImmutableGraph;
import org.opennms.netmgt.graph.api.NodeRef;
import org.opennms.netmgt.graph.api.VertexRef;
import org.opennms.netmgt.graph.api.focus.Focus;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.generic.GenericElement;
import org.opennms.netmgt.graph.api.generic.GenericVertex;
import org.opennms.netmgt.graph.api.info.GraphInfo;
import org.opennms.netmgt.graph.api.transformer.SemanticZoomLevelTransformer;

public final class GenericGraph
extends GenericElement
implements ImmutableGraph<GenericVertex, GenericEdge> {
    private final DirectedSparseGraph<VertexRef, GenericEdge> jungGraph;
    private final Map<String, GenericVertex> vertexToIdMap;
    private final Map<String, GenericEdge> edgeToIdMap;
    private final Map<NodeRef, List<GenericVertex>> nodeRefToVertexMap;
    private final Focus defaultFocus;
    private final GraphInfo graphInfo;

    private GenericGraph(GenericGraphBuilder builder) {
        super(builder.properties);
        this.jungGraph = builder.jungGraph;
        this.vertexToIdMap = builder.vertexToIdMap;
        this.edgeToIdMap = builder.edgeToIdMap;
        this.nodeRefToVertexMap = builder.nodeRefToVertexMap;
        this.defaultFocus = builder.defaultFocus;
        this.graphInfo = new GenericGraphInfo();
    }

    @Override
    public GenericGraph asGenericGraph() {
        return this;
    }

    @Override
    public List<GenericVertex> getVertices() {
        return new ArrayList<GenericVertex>(this.vertexToIdMap.values());
    }

    @Override
    public List<GenericEdge> getEdges() {
        return new ArrayList<GenericEdge>(this.edgeToIdMap.values());
    }

    public GraphInfo getGraphInfo() {
        return this.graphInfo;
    }

    @Override
    public String getDescription() {
        return this.graphInfo.getDescription();
    }

    @Override
    public String getLabel() {
        return this.graphInfo.getLabel();
    }

    @Override
    public Focus getDefaultFocus() {
        return this.defaultFocus;
    }

    @Override
    public List<GenericVertex> resolveVertices(NodeRef nodeRef) {
        Objects.requireNonNull(nodeRef);
        ArrayList resolvedVertices = Lists.newArrayList();
        for (NodeRef eachVariant : nodeRef.getVariants()) {
            if (!this.nodeRefToVertexMap.containsKey(eachVariant)) continue;
            resolvedVertices.addAll((Collection)this.nodeRefToVertexMap.get(eachVariant));
        }
        return resolvedVertices;
    }

    @Override
    public GenericVertex getVertex(String id) {
        return this.vertexToIdMap.get(id);
    }

    @Override
    public GenericEdge getEdge(String id) {
        return this.edgeToIdMap.get(id);
    }

    @Override
    public List<String> getVertexIds() {
        return this.vertexToIdMap.keySet().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public List<String> getEdgeIds() {
        return this.edgeToIdMap.keySet().stream().sorted().collect(Collectors.toList());
    }

    @Override
    public List<GenericVertex> resolveVertices(Collection<String> vertexIds) {
        List<GenericVertex> collect = vertexIds.stream().map(vid -> this.vertexToIdMap.get(vid)).filter(v -> v != null).collect(Collectors.toList());
        return collect;
    }

    @Override
    public GenericVertex resolveVertex(VertexRef vertexRef) {
        Objects.requireNonNull(vertexRef);
        if (this.getNamespace().equals(vertexRef.getNamespace())) {
            GenericVertex resolvedVertex = this.resolveVertices(Lists.newArrayList((Object[])new String[]{vertexRef.getId()})).stream().findAny().orElse(null);
            return resolvedVertex;
        }
        return null;
    }

    public List<GenericVertex> resolveVertexRefs(Collection<VertexRef> vertexRefs) {
        List<String> vertexIds = vertexRefs.stream().filter(ref -> this.getNamespace().equals(ref.getNamespace())).map(ref -> ref.getId()).collect(Collectors.toList());
        return this.resolveVertices(vertexIds);
    }

    @Override
    public List<GenericEdge> resolveEdges(Collection<String> vertexIds) {
        List<GenericEdge> collect = vertexIds.stream().map(eid -> this.edgeToIdMap.get(eid)).collect(Collectors.toList());
        return collect;
    }

    @Override
    public Collection<GenericVertex> getNeighbors(GenericVertex eachVertex) {
        return this.resolveVertexRefs(this.jungGraph.getNeighbors((Object)eachVertex.getVertexRef()));
    }

    @Override
    public Collection<GenericEdge> getConnectingEdges(GenericVertex eachVertex) {
        HashSet<GenericEdge> edges = new HashSet<GenericEdge>();
        if (eachVertex != null) {
            VertexRef genericVertexRef = eachVertex.getVertexRef();
            edges.addAll(this.jungGraph.getInEdges((Object)genericVertexRef));
            edges.addAll(this.jungGraph.getOutEdges((Object)genericVertexRef));
        }
        return edges;
    }

    @Override
    public ImmutableGraph<GenericVertex, GenericEdge> getView(Collection<GenericVertex> verticesInFocus, int szl) {
        return new SemanticZoomLevelTransformer(verticesInFocus, szl).transform(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GenericGraph that = (GenericGraph)o;
        return Objects.equals(this.vertexToIdMap, that.vertexToIdMap) && Objects.equals(this.edgeToIdMap, that.edgeToIdMap) && Objects.equals(this.defaultFocus, that.defaultFocus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.vertexToIdMap, this.edgeToIdMap, this.getDefaultFocus());
    }

    public static GenericGraphBuilder builder() {
        return new GenericGraphBuilder();
    }

    public static GenericGraphBuilder from(GenericGraph graph) {
        Objects.requireNonNull(graph);
        return new GenericGraphBuilder().graph(graph);
    }

    public static final class GenericGraphBuilder
    extends GenericElement.GenericElementBuilder<GenericGraphBuilder> {
        private final DirectedSparseGraph<VertexRef, GenericEdge> jungGraph = new DirectedSparseGraph();
        private final Map<String, GenericVertex> vertexToIdMap = new HashMap<String, GenericVertex>();
        private final Map<String, GenericEdge> edgeToIdMap = new HashMap<String, GenericEdge>();
        private final Map<NodeRef, List<GenericVertex>> nodeRefToVertexMap = new HashMap<NodeRef, List<GenericVertex>>();
        private Focus defaultFocus = new Focus("EMPTY");

        private GenericGraphBuilder() {
        }

        public GenericGraphBuilder graph(GenericGraph graph) {
            this.properties((Map)graph.getProperties());
            this.addVertices(graph.getVertices());
            this.addEdges(graph.getEdges());
            this.defaultFocus = graph.defaultFocus;
            return this;
        }

        public GenericGraphBuilder description(String description) {
            this.property("description", description);
            return this;
        }

        public GenericGraphBuilder graphInfo(GraphInfo graphInfo) {
            this.namespace(graphInfo.getNamespace());
            this.description(graphInfo.getDescription());
            this.label(graphInfo.getLabel());
            return this;
        }

        public GenericGraphBuilder focus(Focus defaultFocus) {
            Objects.requireNonNull(defaultFocus);
            this.defaultFocus = defaultFocus;
            return this;
        }

        public FocusBuilder focus() {
            return new FocusBuilder();
        }

        public GenericGraphBuilder addEdges(Collection<GenericEdge> edges) {
            for (GenericEdge eachEdge : edges) {
                this.addEdge(eachEdge);
            }
            return this;
        }

        public GenericGraphBuilder addVertices(Collection<GenericVertex> vertices) {
            for (GenericVertex eachVertex : vertices) {
                this.addVertex(eachVertex);
            }
            return this;
        }

        public GenericGraphBuilder addVertex(GenericVertex vertex) {
            Objects.requireNonNull(this.getNamespace(), "Please set a namespace before adding elements to this graph.");
            Objects.requireNonNull(vertex, "GenericVertex can not be null");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)vertex.getId()) ? 1 : 0) != 0, (String)"GenericVertex.getId() can not be empty or null. Vertex= %s", (Object)vertex);
            if (!this.getNamespace().equals(vertex.getNamespace())) {
                throw new IllegalArgumentException(String.format("The namespace of the vertex (%s) doesn't match the namespace of this graph (%s). Vertex: %s ", vertex.getNamespace(), this.getNamespace(), vertex.toString()));
            }
            if (this.vertexToIdMap.containsKey(vertex.getId())) {
                return this;
            }
            this.jungGraph.addVertex((Object)vertex.getVertexRef());
            this.vertexToIdMap.put(vertex.getId(), vertex);
            if (vertex.getNodeRef() != null) {
                this.nodeRefToVertexMap.putIfAbsent(vertex.getNodeRef(), new ArrayList());
                this.nodeRefToVertexMap.get(vertex.getNodeRef()).add(vertex);
            }
            return this;
        }

        public GenericGraphBuilder addEdge(GenericEdge edge) {
            Objects.requireNonNull(this.getNamespace(), "Please set a namespace before adding elements to this graph.");
            Objects.requireNonNull(edge, "GenericEdge cannot be null");
            Preconditions.checkArgument((!Strings.isNullOrEmpty((String)edge.getId()) ? 1 : 0) != 0, (String)"GenericEdge.getId() can not be empty or null. Vertex= %s", (Object)edge);
            if (!this.getNamespace().equals(edge.getNamespace())) {
                throw new IllegalArgumentException(String.format("The namespace of the edge (%s) doesn't match the namespace of this graph (%s). Edge: %s ", edge.getNamespace(), this.getNamespace(), edge.toString()));
            }
            this.assertEdgeContainsAtLeastOneKnownVertex(edge);
            if (this.edgeToIdMap.containsKey(edge.getId())) {
                return this;
            }
            this.jungGraph.addEdge((Object)edge, (Object)edge.getSource(), (Object)edge.getTarget());
            this.edgeToIdMap.put(edge.getId(), edge);
            return this;
        }

        private void assertEdgeContainsAtLeastOneKnownVertex(Edge edge) {
            Objects.requireNonNull(edge.getSource(), "Source vertex must be provided");
            Objects.requireNonNull(edge.getTarget(), "Target vertex must be provided");
            VertexRef sourceRef = edge.getSource();
            VertexRef targetRef = edge.getTarget();
            if (!sourceRef.getNamespace().equals(this.getNamespace()) && !targetRef.getNamespace().equals(this.getNamespace())) {
                throw new IllegalArgumentException(String.format("Adding an Edge with two vertices of unknown namespace. Either the source or target vertex must match the graph's namespace (%s). But got: (%s, %s)", this.getNamespace(), sourceRef.getNamespace(), targetRef.getNamespace()));
            }
            if (sourceRef.getNamespace().equals(this.getNamespace())) {
                this.assertVertexFromSameNamespaceIsKnown(sourceRef);
            }
            if (targetRef.getNamespace().equals(this.getNamespace())) {
                this.assertVertexFromSameNamespaceIsKnown(targetRef);
            }
        }

        private void assertVertexFromSameNamespaceIsKnown(VertexRef vertex) {
            if (vertex.getNamespace().equals(this.getNamespace()) && this.getVertex(vertex.getId()) == null) {
                throw new IllegalArgumentException(String.format("Adding a VertexRef to an unknown Vertex with id=%s in our namespace (%s). Please add the Vertex first to the graph", vertex.getId(), this.getNamespace()));
            }
        }

        public void removeEdge(GenericEdge edge) {
            Objects.requireNonNull(edge);
            this.jungGraph.removeEdge((Object)edge);
            this.edgeToIdMap.remove(edge.getId());
        }

        public void removeVertex(GenericVertex vertex) {
            Objects.requireNonNull(vertex);
            this.jungGraph.removeVertex((Object)vertex.getVertexRef());
            this.vertexToIdMap.remove(vertex.getId());
        }

        @Override
        public String getNamespace() {
            return Objects.requireNonNull((String)this.properties.get("namespace"), "Namespace is not set yet. Please call namespace(...) first.");
        }

        public GenericVertex getVertex(String id) {
            return this.vertexToIdMap.get(id);
        }

        public List<GenericVertex> resolveVertices(NodeRef nodeRef) {
            Objects.requireNonNull(nodeRef);
            ArrayList resolvedVertices = Lists.newArrayList();
            for (NodeRef eachVariant : nodeRef.getVariants()) {
                if (!this.nodeRefToVertexMap.containsKey(eachVariant)) continue;
                resolvedVertices.addAll((Collection)this.nodeRefToVertexMap.get(eachVariant));
            }
            return resolvedVertices;
        }

        @Override
        public GenericGraphBuilder namespace(String namespace) {
            this.checkIfNamespaceChangeIsAllowed(namespace);
            return (GenericGraphBuilder)super.namespace(namespace);
        }

        @Override
        public GenericGraphBuilder property(String name, Object value) {
            if ("namespace".equals(name)) {
                this.checkIfNamespaceChangeIsAllowed((String)value);
            }
            return (GenericGraphBuilder)super.property(name, value);
        }

        @Override
        public GenericGraphBuilder properties(Map<String, Object> properties) {
            if (properties != null && properties.containsKey("namespace")) {
                this.checkIfNamespaceChangeIsAllowed((String)properties.get("namespace"));
            }
            return (GenericGraphBuilder)super.properties(properties);
        }

        private void checkIfNamespaceChangeIsAllowed(String newNamespace) {
            if (!(this.vertexToIdMap.isEmpty() || this.edgeToIdMap.isEmpty() || Objects.equals(this.getNamespace(), newNamespace))) {
                throw new IllegalStateException("Cannot change namespace after adding Elements to Graph.");
            }
        }

        public GenericGraph build() {
            return new GenericGraph(this);
        }

        public List<GenericVertex> getVertices() {
            return Lists.newArrayList(this.vertexToIdMap.values());
        }

        public class FocusBuilder {
            private String focusStrategy = "EMPTY";
            private List<VertexRef> focusSelection = new ArrayList<VertexRef>();

            public FocusBuilder first() {
                this.focusStrategy = "FIRST";
                return this;
            }

            public FocusBuilder empty() {
                this.focusStrategy = "EMPTY";
                return this;
            }

            public FocusBuilder all() {
                this.focusStrategy = "ALL";
                return this;
            }

            public FocusBuilder selection(String vertexNamespace, List<String> vertexIds) {
                Objects.requireNonNull(vertexNamespace);
                Objects.requireNonNull(vertexIds);
                List<VertexRef> vertexRefs = vertexIds.stream().map(id -> new VertexRef(vertexNamespace, (String)id)).collect(Collectors.toList());
                return this.selection(vertexRefs);
            }

            public FocusBuilder selection(List<VertexRef> vertexRefs) {
                Objects.requireNonNull(vertexRefs);
                this.focusStrategy = "SELECTION";
                this.focusSelection = new ArrayList<VertexRef>(vertexRefs);
                return this;
            }

            public FocusBuilder selection(VertexRef vertexRef) {
                Objects.requireNonNull(vertexRef);
                return this.selection(Lists.newArrayList((Object[])new VertexRef[]{vertexRef}));
            }

            public Focus build() {
                switch (this.focusStrategy) {
                    case "FIRST": {
                        ArrayList list = Lists.newArrayList();
                        if (!GenericGraphBuilder.this.vertexToIdMap.isEmpty()) {
                            list.add(GenericGraphBuilder.this.vertexToIdMap.values().iterator().next().getVertexRef());
                        }
                        return new Focus("FIRST", list);
                    }
                    case "ALL": {
                        return new Focus("ALL", GenericGraphBuilder.this.vertexToIdMap.values().stream().map(GenericVertex::getVertexRef).collect(Collectors.toList()));
                    }
                    case "EMPTY": {
                        return new Focus("EMPTY");
                    }
                    case "SELECTION": {
                        List<VertexRef> existingVertexRefs = this.focusSelection.stream().filter(v -> v.getNamespace().equals(GenericGraphBuilder.this.getNamespace()) && GenericGraphBuilder.this.vertexToIdMap.containsKey(v.getId())).collect(Collectors.toList());
                        return new Focus("SELECTION", existingVertexRefs);
                    }
                }
                Object[] validValues = new String[]{"ALL", "EMPTY", "FIRST", "SELECTION"};
                throw new IllegalStateException("Focus Strategy '" + this.focusStrategy + "' not supported. Supported values are: " + Arrays.toString(validValues));
            }

            public GenericGraphBuilder apply() {
                Focus focus = this.build();
                return GenericGraphBuilder.this.focus(focus);
            }
        }
    }

    private class GenericGraphInfo
    implements GraphInfo {
        private GenericGraphInfo() {
        }

        @Override
        public String getNamespace() {
            return (String)GenericGraph.this.properties.get("namespace");
        }

        @Override
        public String getDescription() {
            return (String)GenericGraph.this.properties.get("description");
        }

        @Override
        public String getLabel() {
            return (String)GenericGraph.this.properties.get("label");
        }
    }
}

