/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision.service;

import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.SnmpValue;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPAddressTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(IPAddressTableTracker.class);
    public static final SnmpObjId IP_ADDRESS_PREFIX_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.4.32.1");
    public static final SnmpObjId IP_ADDRESS_TABLE_ENTRY = SnmpObjId.get((String)".1.3.6.1.2.1.4.34.1");
    public static final SnmpObjId IP_ADDRESS_IF_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"3");
    public static final SnmpObjId IP_ADDRESS_TYPE_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"4");
    public static final SnmpObjId IP_ADDRESS_PREFIX_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId IP_ADDRESS_PREFIX_ORIGIN_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_PREFIX_TABLE_ENTRY, (String)"5");
    public static final SnmpObjId IP_ADDRESS_ORIGIN_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"6");
    public static final SnmpObjId IP_ADDRESS_STATUS_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"7");
    public static final SnmpObjId IP_ADDRESS_CREATED_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"8");
    public static final SnmpObjId IP_ADDRESS_LAST_CHANGED_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"9");
    public static final SnmpObjId IP_ADDRESS_ROW_STATUS_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"10");
    public static final SnmpObjId IP_ADDRESS_STORAGE_TYPE_INDEX = SnmpObjId.get((SnmpObjId)IP_ADDRESS_TABLE_ENTRY, (String)"11");
    public static final int TYPE_IPV4 = 1;
    public static final int TYPE_IPV6 = 2;
    public static final int TYPE_IPV4Z = 3;
    public static final int TYPE_IPV6Z = 4;
    public static final int TYPE_DNS = 16;
    private static final int IP_ADDRESS_TYPE_UNICAST = 1;
    private static SnmpObjId[] s_tableColumns = new SnmpObjId[]{IP_ADDRESS_IF_INDEX, IP_ADDRESS_PREFIX_INDEX, IP_ADDRESS_TYPE_INDEX};

    public IPAddressTableTracker() {
        super(s_tableColumns);
    }

    public IPAddressTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_tableColumns);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new IPAddressRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processIPAddressRow((IPAddressRow)row);
    }

    public void processIPAddressRow(IPAddressRow row) {
    }

    public static class IPAddressRow
    extends SnmpRowResult {
        public IPAddressRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
            LOG.debug("column count = {}, instance = {}", (Object)columnCount, (Object)instance);
        }

        public Integer getIfIndex() {
            SnmpValue value = this.getValue(IP_ADDRESS_IF_INDEX);
            return value.toInt();
        }

        public String getIpAddress() {
            SnmpResult result = this.getResult(IP_ADDRESS_IF_INDEX);
            if (result == null) {
                LOG.warn("BAD AGENT: Device is missing IP-MIB::ipAddressIfIndex. Skipping.");
                return null;
            }
            SnmpInstId instance = result.getInstance();
            int[] instanceIds = instance.getIds();
            int addressType = instanceIds[0];
            int addressIndex = 2;
            int addressLength = instanceIds[1];
            LOG.debug("addressType: {}, addressLength: {}, instanceIds.length: {}, instance: {}", new Object[]{addressType, addressLength, instanceIds.length, instance.toString()});
            if (addressType == 1 && instanceIds.length != 6) {
                LOG.warn("IPV4: BAD AGENT: Does not conform to RFC 4001 Section 4.1 Table Indexing!!! Report them immediately.  Making a best guess!");
                if (instanceIds.length == addressLength + addressIndex) {
                    try {
                        InetAddress address = this.byteStringToInetAddress(instanceIds, addressIndex, addressLength);
                        return InetAddressUtils.str((InetAddress)address);
                    }
                    catch (Exception e) {
                        LOG.debug("IPV4: BAD AGENT: Could not parse raw oids as octet string", (Throwable)e);
                    }
                }
                if (instanceIds[instanceIds.length - 1] == this.getIfIndex() && instanceIds.length > 6) {
                    LOG.debug("IPV4: BAD AGENT: Instance is longer than expected ({}) and last instance value matches the ifIndex ({}), assuming address start on index 2", (Object)instanceIds.length, (Object)this.getIfIndex());
                    addressIndex = 2;
                } else {
                    addressIndex = instanceIds.length - 4;
                }
                addressLength = 4;
            }
            if (addressType == 2 && instanceIds.length != 18) {
                LOG.warn("IPV6: BAD AGENT: Does not conform to RFC 4001 Section 4.1 Table Indexing!!! Report them immediately.  Making a best guess!");
                if (instanceIds.length == addressLength + addressIndex) {
                    try {
                        InetAddress address = this.byteStringToInetAddress(instanceIds, addressIndex, addressLength);
                        return InetAddressUtils.str((InetAddress)address);
                    }
                    catch (Exception e) {
                        LOG.debug("IPV6: BAD AGENT: Could not parse raw oids as octet string", (Throwable)e);
                    }
                }
                if (instanceIds[instanceIds.length - 1] == this.getIfIndex() && instanceIds.length > 18) {
                    LOG.debug("IPV6: BAD AGENT: Instance is longer than expected ({}) and last instance value matches the ifIndex ({}), assuming address start on index 2", (Object)instanceIds.length, (Object)this.getIfIndex());
                    addressIndex = 2;
                } else {
                    addressIndex = instanceIds.length - 16;
                }
                addressLength = 16;
            }
            if (addressType == 3) {
                addressLength = 4;
            } else if (addressType == 4) {
                addressLength = 16;
            }
            if (addressIndex < 0 || addressIndex + addressLength > instanceIds.length) {
                LOG.warn("BAD AGENT: Returned instanceId {} does not enough bytes to contain address!. Skipping.", (Object)instance);
                return null;
            }
            if (addressType == 1 || addressType == 2 || addressType == 4) {
                try {
                    InetAddress address = InetAddressUtils.getInetAddress((int[])instanceIds, (int)addressIndex, (int)addressLength);
                    return InetAddressUtils.str((InetAddress)address);
                }
                catch (IllegalArgumentException e) {
                    LOG.warn("Failed to parse address: {}, index {}, length {}", new Object[]{Arrays.toString(instanceIds), addressIndex, addressLength, e});
                }
            }
            return null;
        }

        private InetAddress byteStringToInetAddress(int[] rawIds, int offset, int length) {
            byte[] addressBytes = new byte[length];
            for (int i = 0; i < addressBytes.length; ++i) {
                addressBytes[i] = Integer.valueOf(rawIds[i + offset]).byteValue();
            }
            String ipaddr = new String(addressBytes, StandardCharsets.UTF_8);
            return InetAddressUtils.getInetAddress((String)ipaddr);
        }

        public Integer getType() {
            SnmpValue value = this.getValue(IP_ADDRESS_TYPE_INDEX);
            return value.toInt();
        }

        private InetAddress getNetMask() {
            SnmpValue value = this.getValue(IP_ADDRESS_PREFIX_INDEX);
            SnmpInstId netmaskRef = value.toSnmpObjId().getInstance(IP_ADDRESS_PREFIX_ORIGIN_INDEX);
            if (netmaskRef == null) {
                LOG.warn("BAD AGENT: Null netmask instanceId");
                return null;
            }
            int[] rawIds = netmaskRef.getIds();
            int addressType = rawIds[1];
            int mask = rawIds[rawIds.length - 1];
            int addressLength = rawIds[2];
            int addressIndex = 3;
            if (addressType == 1 && rawIds.length != 8) {
                LOG.warn("BAD AGENT: Does not conform to RFC 4001 Section 4.1 Table Indexing!!! Report them immediately.  Making a best guess! Length for ipv4 should be 8 but is {}", (Object)rawIds.length);
                addressIndex = rawIds.length - 5;
                addressLength = 4;
            }
            if (addressType == 2 && rawIds.length != 20) {
                LOG.warn("BAD AGENT: Does not conform to RFC 4001 Section 4.1 Table Indexing!!! Report them immediately.  Making a best guess! Length for ipv6 should be 20 but is {}", (Object)rawIds.length);
                addressIndex = rawIds.length - 17;
                addressLength = 16;
            }
            if (addressIndex < 0 || addressIndex + addressLength > rawIds.length) {
                LOG.warn("BAD AGENT: Returned instanceId {} does not enough bytes to contain address!. Skipping.", (Object)netmaskRef);
                return null;
            }
            if (addressType == 1) {
                return InetAddressUtils.convertCidrToInetAddressV4((int)mask);
            }
            if (addressType == 2) {
                return InetAddressUtils.convertCidrToInetAddressV6((int)mask);
            }
            LOG.warn("unknown address type, expected 1 (IPv4) or 2 (IPv6), but got {}", (Object)addressType);
            return null;
        }

        public OnmsIpInterface createInterfaceFromRow() {
            Integer ifIndex = this.getIfIndex();
            String ipAddr = this.getIpAddress();
            Integer type = this.getType();
            InetAddress netMask = this.getNetMask();
            LOG.debug("createInterfaceFromRow: ifIndex = {}, ipAddress = {}, type = {}, netmask = {}", new Object[]{ifIndex, ipAddr, type, netMask});
            if (type != 1 || ipAddr == null) {
                return null;
            }
            InetAddress inetAddress = InetAddressUtils.addr((String)ipAddr);
            OnmsIpInterface iface = new OnmsIpInterface(inetAddress, null);
            iface.setNetMask(netMask);
            if (ifIndex != null) {
                OnmsSnmpInterface snmpIface = new OnmsSnmpInterface(null, ifIndex);
                snmpIface.setCollectionEnabled(true);
                iface.setSnmpInterface(snmpIface);
                iface.setIfIndex(ifIndex);
            }
            return iface;
        }

        private SnmpResult getResult(SnmpObjId base) {
            for (SnmpResult result : this.getResults()) {
                if (!base.equals((Object)result.getBase())) continue;
                return result;
            }
            return null;
        }
    }
}

