/*
 * Decompiled with CFR 0.152.
 */
package jcifs.smb;

import jcifs.smb.SmbException;
import jcifs.smb.SmbFileOutputStream;

class WriterThread
extends Thread {
    private byte[] b;
    private int n;
    private boolean ready = false;
    private SmbFileOutputStream out;
    private SmbException e = null;

    WriterThread() {
        super("JCIFS-WriterThread");
    }

    boolean isReady() {
        return this.ready;
    }

    public void checkException() throws SmbException {
        if (this.e != null) {
            throw this.e;
        }
    }

    synchronized void write(byte[] buffer, int len, SmbFileOutputStream d) {
        this.b = buffer;
        this.n = len;
        this.out = d;
        this.ready = false;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        WriterThread writerThread = this;
        synchronized (writerThread) {
            try {
                while (true) {
                    this.notify();
                    this.ready = true;
                    while (this.ready) {
                        this.wait();
                    }
                    if (this.n == -1) {
                        return;
                    }
                    this.out.write(this.b, 0, this.n);
                }
            }
            catch (SmbException ex) {
                this.e = ex;
            }
            catch (Exception x) {
                this.e = new SmbException("WriterThread", (Throwable)x);
            }
            this.notify();
        }
    }
}

