/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.notifd;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.opennms.netmgt.config.DestinationPathManager;
import org.opennms.netmgt.config.destinationPaths.Escalate;
import org.opennms.netmgt.config.destinationPaths.Path;
import org.opennms.netmgt.config.destinationPaths.Target;
import org.opennms.netmgt.notifd.api.NotificationConfigProvider;

public class NotificationConfigProviderImpl
implements NotificationConfigProvider {
    private final DestinationPathManager destinationPathManager;

    @Inject
    public NotificationConfigProviderImpl(DestinationPathManager destinationPathManager) {
        this.destinationPathManager = Objects.requireNonNull(destinationPathManager);
    }

    public List<String> getDestinationPathNames() {
        try {
            return this.destinationPathManager.getPaths().keySet().stream().sorted().collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public List<String> getTargetNames(String destinationPathName, boolean includeEscalations) {
        return this.getTargets(destinationPathName, includeEscalations).stream().map(Target::getName).collect(Collectors.toList());
    }

    public List<String> getCommands(String destinationPathName, String targetName, boolean includeEscalations) {
        return this.getTargets(destinationPathName, includeEscalations).stream().filter(t -> Objects.equals(targetName, t.getName())).findFirst().map(Target::getCommands).orElse(Collections.emptyList());
    }

    private List<Target> getTargets(String destinationPathName, boolean includeEscalations) {
        try {
            Path path = this.destinationPathManager.getPath(destinationPathName);
            if (path == null) {
                return Collections.emptyList();
            }
            LinkedList<Target> targets = new LinkedList<Target>(path.getTargets());
            if (includeEscalations) {
                for (Escalate escalation : path.getEscalates()) {
                    targets.addAll(escalation.getTargets());
                }
            }
            return targets;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

