/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.elastic.agg;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Table;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.SumAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.opennms.features.elastic.client.ElasticRestClient;
import org.opennms.features.elastic.client.model.SearchResponse;
import org.opennms.features.jest.client.index.IndexSelector;
import org.opennms.netmgt.flows.api.BytesInOut;
import org.opennms.netmgt.flows.api.Conversation;
import org.opennms.netmgt.flows.api.Directional;
import org.opennms.netmgt.flows.api.Host;
import org.opennms.netmgt.flows.api.LimitedCardinalityField;
import org.opennms.netmgt.flows.api.TrafficSummary;
import org.opennms.netmgt.flows.elastic.AggregationUtils;
import org.opennms.netmgt.flows.elastic.ElasticFlowQueryService;
import org.opennms.netmgt.flows.elastic.GPath;
import org.opennms.netmgt.flows.elastic.ProportionalSumAggregation;
import org.opennms.netmgt.flows.elastic.agg.AggregatedSearchQueryProvider;
import org.opennms.netmgt.flows.elastic.agg.GroupedBy;
import org.opennms.netmgt.flows.elastic.agg.Types;
import org.opennms.netmgt.flows.filter.api.DscpFilter;
import org.opennms.netmgt.flows.filter.api.Filter;
import org.opennms.netmgt.flows.filter.api.TimeRangeFilter;

public class AggregatedFlowQueryService
extends ElasticFlowQueryService {
    public static final String INDEX_NAME = "netflow_agg";
    public static final String OTHER_NAME = "Other";
    private final AggregatedSearchQueryProvider searchQueryProvider = new AggregatedSearchQueryProvider();
    private static GPath<List<String>> ALL_TERMS_AS_INT_GPATH = GPath.integer().map(String::valueOf).field("term").field("key").array("buckets").field("my_buckets").field("aggregations", "aggs");

    public AggregatedFlowQueryService(ElasticRestClient client, IndexSelector indexSelector) {
        super(client, indexSelector);
    }

    private boolean hasTosFilter(List<Filter> filters) {
        return filters.stream().anyMatch(f -> f instanceof DscpFilter);
    }

    private GroupedBy selectGroupedBy(List<Filter> filters, GroupedBy withTos, GroupedBy withoutTos) {
        return this.hasTosFilter(filters) ? withTos : withoutTos;
    }

    private GroupedBy selectAppGroupedBy(List<Filter> filters) {
        return this.selectGroupedBy(filters, GroupedBy.EXPORTER_INTERFACE_TOS_APPLICATION, GroupedBy.EXPORTER_INTERFACE_APPLICATION);
    }

    private GroupedBy selectHostGroupedBy(List<Filter> filters) {
        return this.selectGroupedBy(filters, GroupedBy.EXPORTER_INTERFACE_TOS_HOST, GroupedBy.EXPORTER_INTERFACE_HOST);
    }

    private GroupedBy selectConvGroupedBy(List<Filter> filters) {
        return this.selectGroupedBy(filters, GroupedBy.EXPORTER_INTERFACE_TOS_CONVERSATION, GroupedBy.EXPORTER_INTERFACE_CONVERSATION);
    }

    public CompletableFuture<List<TrafficSummary<String>>> getTopNApplicationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.getTopNSummary(N, includeOther, filters, this.selectAppGroupedBy(filters), Types.APPLICATION, CompletableFuture::completedFuture);
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getTopNApplicationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.getTopNSeries(N, step, includeOther, filters, this.selectAppGroupedBy(filters), Types.APPLICATION, CompletableFuture::completedFuture);
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getTopNConversationSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.getTopNSummary(N, includeOther, filters, this.selectConvGroupedBy(filters), Types.CONVERSATION, conversation -> this.resolveHostnameForConversation((Conversation)conversation, filters));
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getTopNConversationSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.getTopNSeries(N, step, includeOther, filters, this.selectConvGroupedBy(filters), Types.CONVERSATION, conversation -> this.resolveHostnameForConversation((Conversation)conversation, filters));
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getTopNHostSummaries(int N, boolean includeOther, List<Filter> filters) {
        return this.getTopNSummary(N, includeOther, filters, this.selectHostGroupedBy(filters), Types.HOST, host -> this.resolveHostnameForHost((Host)host, filters));
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getTopNHostSeries(int N, long step, boolean includeOther, List<Filter> filters) {
        return this.getTopNSeries(N, step, includeOther, filters, this.selectHostGroupedBy(filters), Types.HOST, host -> this.resolveHostnameForHost((Host)host, filters));
    }

    public CompletableFuture<List<String>> getFieldValues(LimitedCardinalityField field, List<Filter> filters) {
        switch (field) {
            case DSCP: {
                return this.getAllTerms(GroupedBy.EXPORTER_INTERFACE_TOS, "dscp", field.size, filters);
            }
        }
        throw new UnsupportedOperationException("Enumerating aggregated field values is not supported for field: " + String.valueOf(field));
    }

    public CompletableFuture<List<TrafficSummary<String>>> getFieldSummaries(LimitedCardinalityField field, List<Filter> filters) {
        switch (field) {
            case DSCP: {
                return this.getTopNSummary(field.size, false, filters, GroupedBy.EXPORTER_INTERFACE_TOS, Types.DSCP, CompletableFuture::completedFuture);
            }
        }
        throw new UnsupportedOperationException("Summaries for aggregated values are not supported for field: " + String.valueOf(field));
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getFieldSeries(LimitedCardinalityField field, long step, List<Filter> filters) {
        switch (field) {
            case DSCP: {
                return this.getTopNSeries(field.size, step, false, filters, GroupedBy.EXPORTER_INTERFACE_TOS, Types.DSCP, CompletableFuture::completedFuture);
            }
        }
        throw new UnsupportedOperationException("Series for aggregated values are not supported for field: " + String.valueOf(field));
    }

    private CompletableFuture<List<String>> getAllTerms(GroupedBy groupedBy, String groupedByField, int fieldSize, List<Filter> filters) {
        TimeRangeFilter timeRangeFilter = Filter.find(filters, TimeRangeFilter.class).orElse(null);
        String query = this.searchQueryProvider.getAllTerms(groupedBy, groupedByField, fieldSize, filters);
        return this.searchAsync(query, timeRangeFilter).thenApply(searchResult -> {
            JsonObject wrapper = new JsonObject();
            if (searchResult.getAggregations() != null) {
                wrapper.add("aggregations", (JsonElement)searchResult.getAggregations());
                wrapper.add("aggs", (JsonElement)searchResult.getAggregations());
            }
            return ALL_TERMS_AS_INT_GPATH.eval((JsonElement)wrapper);
        });
    }

    private <T> CompletableFuture<Table<Directional<T>, Long, Double>> getTopNSeries(int N, long step, boolean includeOther, List<Filter> filters, GroupedBy groupedBy, Types.Type<T> type, Function<T, CompletableFuture<T>> transform) {
        CompletionStage<Object> seriesFuture;
        TimeRangeFilter timeRangeFilter = (TimeRangeFilter)Filter.find(filters, TimeRangeFilter.class).orElseThrow(() -> new IllegalArgumentException("Time range filter is required to derive time series."));
        ImmutableTable.Builder builder = ImmutableTable.builder();
        if (N > 0) {
            String seriesFromTopNQuery = this.searchQueryProvider.getSeriesFromTopNQuery(N, groupedBy, type.getAggregationType(), type.getKey(), step, timeRangeFilter.getStart(), timeRangeFilter.getEnd(), filters);
            seriesFuture = this.searchAsync(seriesFromTopNQuery, timeRangeFilter).thenCompose(res -> AggregatedFlowQueryService.toTableFromBuckets(builder, key -> (CompletableFuture)transform.apply(type.toEntity((String)key)), res));
        } else {
            seriesFuture = CompletableFuture.completedFuture(null);
        }
        if (includeOther) {
            String seriesFromTotalQuery = this.searchQueryProvider.getSeriesFromTotalsQuery(groupedBy.getParent(), step, timeRangeFilter.getStart(), timeRangeFilter.getEnd(), filters);
            ImmutableTable.Builder totalsTableBuilder = ImmutableTable.builder();
            CompletionStage totalSeriesFuture = this.searchAsync(seriesFromTotalQuery, timeRangeFilter).thenApply(res -> {
                AggregatedFlowQueryService.toTableFromTotals(totalsTableBuilder, type.getOtherEntity(), res);
                return null;
            });
            seriesFuture = ((CompletableFuture)seriesFuture).thenCombine(totalSeriesFuture, (topN, totals) -> {
                ImmutableTable topNTable = builder.build();
                ImmutableTable totalsTable = totalsTableBuilder.build();
                TreeSet timestamps = new TreeSet();
                timestamps.addAll(topNTable.columnKeySet());
                timestamps.addAll(totalsTable.columnKeySet());
                for (Long ts : timestamps) {
                    ImmutableMap entries = topNTable.column((Object)ts);
                    BytesInOut bytesFromTopN = entries != null ? BytesInOut.sum((ImmutableSet)entries.entrySet()) : new BytesInOut();
                    entries = totalsTable.column((Object)ts);
                    BytesInOut totalBytes = entries != null ? BytesInOut.sum((ImmutableSet)entries.entrySet()) : new BytesInOut();
                    BytesInOut otherBytes = totalBytes.minus(bytesFromTopN);
                    builder.put((Object)new Directional(type.getOtherEntity(), true), (Object)ts, (Object)otherBytes.getBytesIn());
                    builder.put((Object)new Directional(type.getOtherEntity(), false), (Object)ts, (Object)otherBytes.getBytesOut());
                }
                return null;
            });
        }
        return ((CompletableFuture)seriesFuture).thenApply(ignored -> builder.build());
    }

    private static <T> CompletableFuture<Void> toTableFromBuckets(ImmutableTable.Builder<Directional<T>, Long, Double> builder, Function<String, CompletableFuture<T>> keyToEntity, SearchResponse res) {
        JsonObject aggs = res.getAggregations();
        if (aggs == null) {
            return CompletableFuture.completedFuture(null);
        }
        MetricAggregation metricAggs = AggregationUtils.toMetricAggregation(res);
        TermsAggregation byKeyAgg = metricAggs.getTermsAggregation("by_key");
        if (byKeyAgg == null) {
            return CompletableFuture.completedFuture(null);
        }
        return AggregatedFlowQueryService.transpose(Iterables.transform((Iterable)byKeyAgg.getBuckets(), bucket -> ((CompletableFuture)keyToEntity.apply(bucket.getKey())).thenApply(resolved -> Maps.immutableEntry((Object)bucket, (Object)resolved))), Collectors.toList()).thenApply(buckets -> {
            for (Map.Entry bucket : buckets) {
                ProportionalSumAggregation bytesInAgg = (ProportionalSumAggregation)((TermsAggregation.Entry)bucket.getKey()).getAggregation("bytes_in", ProportionalSumAggregation.class);
                ProportionalSumAggregation bytesOutAgg = (ProportionalSumAggregation)((TermsAggregation.Entry)bucket.getKey()).getAggregation("bytes_out", ProportionalSumAggregation.class);
                for (ProportionalSumAggregation.DateHistogram dateHistogram : bytesInAgg.getBuckets()) {
                    builder.put((Object)new Directional(bucket.getValue(), true), (Object)dateHistogram.getTime(), (Object)dateHistogram.getValue());
                }
                for (ProportionalSumAggregation.DateHistogram dateHistogram : bytesOutAgg.getBuckets()) {
                    builder.put((Object)new Directional(bucket.getValue(), false), (Object)dateHistogram.getTime(), (Object)dateHistogram.getValue());
                }
            }
            return null;
        });
    }

    private static <T> void toTableFromTotals(ImmutableTable.Builder<Directional<T>, Long, Double> builder, T otherEntity, SearchResponse res) {
        ProportionalSumAggregation bytesOutAgg;
        JsonObject aggs = res.getAggregations();
        if (aggs == null) {
            return;
        }
        MetricAggregation metricAggs = AggregationUtils.toMetricAggregation(res);
        ProportionalSumAggregation bytesInAgg = (ProportionalSumAggregation)metricAggs.getAggregation("bytes_in", ProportionalSumAggregation.class);
        if (bytesInAgg != null) {
            for (ProportionalSumAggregation.DateHistogram dateHistogram : bytesInAgg.getBuckets()) {
                builder.put((Object)new Directional(otherEntity, true), (Object)dateHistogram.getTime(), (Object)dateHistogram.getValue());
            }
        }
        if ((bytesOutAgg = (ProportionalSumAggregation)metricAggs.getAggregation("bytes_out", ProportionalSumAggregation.class)) != null) {
            for (ProportionalSumAggregation.DateHistogram dateHistogram : bytesOutAgg.getBuckets()) {
                builder.put((Object)new Directional(otherEntity, false), (Object)dateHistogram.getTime(), (Object)dateHistogram.getValue());
            }
        }
    }

    private <T> CompletableFuture<List<TrafficSummary<T>>> getTopNSummary(int N, boolean includeOther, List<Filter> filters, GroupedBy groupedBy, Types.Type<T> type, Function<T, CompletableFuture<T>> transform) {
        CompletionStage<List<Object>> summaryFutures;
        if (N > 0) {
            String query = this.searchQueryProvider.getTopNQuery(N, groupedBy, type.getAggregationType(), type.getKey(), filters);
            summaryFutures = this.searchAsync(query, Filter.find(filters, TimeRangeFilter.class).orElse(null)).thenCompose(searchResult -> {
                JsonObject aggs = searchResult.getAggregations();
                if (aggs == null) {
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                MetricAggregation metricAggs = AggregationUtils.toMetricAggregation(searchResult);
                TermsAggregation byKeyAgg = metricAggs.getTermsAggregation("by_key");
                if (byKeyAgg == null) {
                    return CompletableFuture.completedFuture(Collections.emptyList());
                }
                ArrayList trafficSummaries = new ArrayList(N);
                for (TermsAggregation.Entry bucket : byKeyAgg.getBuckets()) {
                    SumAggregation ingress = bucket.getSumAggregation("bytes_ingress");
                    SumAggregation egress = bucket.getSumAggregation("bytes_egress");
                    trafficSummaries.add(((CompletableFuture)transform.apply(type.toEntity(bucket.getKeyAsString()))).thenApply(entity -> TrafficSummary.builder().withEntity(entity).withBytesIn(ingress.getSum().longValue()).withBytesOut(egress.getSum().longValue()).withEcnInfo((MetricAggregation)bucket).build()));
                }
                return AggregatedFlowQueryService.transpose(trafficSummaries, Collectors.toList());
            });
        } else {
            summaryFutures = CompletableFuture.completedFuture(Collections.emptyList());
        }
        if (!includeOther) {
            return summaryFutures;
        }
        CompletableFuture<TrafficSummary<String>> totalTrafficFuture = this.getOtherTraffic(groupedBy.getParent(), filters);
        return summaryFutures.thenCombine(totalTrafficFuture, (topK, total) -> {
            BytesInOut totalBytes = total.getBytesInOut();
            BytesInOut bytesFromTopK = BytesInOut.sum((List)topK);
            BytesInOut otherBytes = totalBytes.minus(bytesFromTopK);
            ArrayList<TrafficSummary> newTopK = new ArrayList<TrafficSummary>((Collection<TrafficSummary>)topK);
            newTopK.add(TrafficSummary.builder().withEntity(type.getOtherEntity()).withBytesIn(otherBytes.getBytesIn()).withBytesOut(otherBytes.getBytesOut()).withEcnInfo(total).build());
            return newTopK;
        });
    }

    private CompletableFuture<TrafficSummary<String>> getOtherTraffic(GroupedBy groupedBy, List<Filter> filters) {
        String query = this.searchQueryProvider.getSumQuery(groupedBy, filters);
        return this.searchAsync(query, Filter.find(filters, TimeRangeFilter.class).orElse(null)).thenApply(searchResult -> {
            JsonObject aggs = searchResult.getAggregations();
            MetricAggregation metricAggs = AggregationUtils.toMetricAggregation(searchResult);
            SumAggregation ingress = metricAggs.getSumAggregation("bytes_ingress");
            SumAggregation egress = metricAggs.getSumAggregation("bytes_egress");
            return TrafficSummary.builder().withEntity((Object)OTHER_NAME).withBytesIn(ingress != null ? ingress.getSum().longValue() : 0L).withBytesOut(egress != null ? egress.getSum().longValue() : 0L).withEcnInfo(metricAggs).build();
        });
    }

    public CompletableFuture<Long> getFlowCount(List<Filter> filters) {
        String query = this.searchQueryProvider.getFlowCountQuery(filters);
        return this.searchAsync(query, Filter.find(filters, TimeRangeFilter.class).orElse(null)).thenApply(res -> res.getHits().getTotalHits());
    }

    public CompletableFuture<List<String>> getApplications(String matchingPrefix, long limit, List<Filter> filters) {
        throw new UnsupportedOperationException("Enumerating applications is not supported.");
    }

    public CompletableFuture<List<String>> getConversations(String locationPattern, String protocolPattern, String lowerIPPattern, String upperIPPattern, String applicationPattern, long limit, List<Filter> filters) {
        throw new UnsupportedOperationException("Enumerating conversations is not supported.");
    }

    public CompletableFuture<List<String>> getHosts(String regex, long limit, List<Filter> filters) {
        throw new UnsupportedOperationException("Enumerating hosts is not supported.");
    }

    public CompletableFuture<List<TrafficSummary<String>>> getApplicationSummaries(Set<String> applications, boolean includeOther, List<Filter> filters) {
        throw new UnsupportedOperationException("Enumerating specific application summaries is not supported.");
    }

    public CompletableFuture<Table<Directional<String>, Long, Double>> getApplicationSeries(Set<String> applications, long step, boolean includeOther, List<Filter> filters) {
        throw new UnsupportedOperationException("Enumerating specific application series is not supported.");
    }

    public CompletableFuture<List<TrafficSummary<Conversation>>> getConversationSummaries(Set<String> conversations, boolean includeOther, List<Filter> filters) {
        throw new UnsupportedOperationException("Enumerating specific conversation summaries is not supported.");
    }

    public CompletableFuture<Table<Directional<Conversation>, Long, Double>> getConversationSeries(Set<String> conversations, long step, boolean includeOther, List<Filter> filters) {
        throw new UnsupportedOperationException("Enumerating specific conversation series is not supported.");
    }

    public CompletableFuture<List<TrafficSummary<Host>>> getHostSummaries(Set<String> hosts, boolean includeOther, List<Filter> filters) {
        throw new UnsupportedOperationException("Enumerating specific host summaries is not supported.");
    }

    public CompletableFuture<Table<Directional<Host>, Long, Double>> getHostSeries(Set<String> hosts, long step, boolean includeOther, List<Filter> filters) {
        throw new UnsupportedOperationException("Enumerating specific conversation series is not supported.");
    }

    public CompletableFuture<Conversation> resolveHostnameForConversation(Conversation convo, List<Filter> filters) {
        CompletableFuture<Optional<String>> lowerHostname = this.resolveHostname(convo.getLowerIp(), filters);
        CompletableFuture<Optional<String>> upperHostname = this.resolveHostname(convo.getUpperIp(), filters);
        return lowerHostname.thenCombine(upperHostname, (lower, upper) -> {
            Conversation.Builder result = Conversation.from((Conversation)convo);
            lower.ifPresent(arg_0 -> ((Conversation.Builder)result).withLowerHostname(arg_0));
            upper.ifPresent(arg_0 -> ((Conversation.Builder)result).withUpperHostname(arg_0));
            return result.build();
        });
    }

    public CompletableFuture<Host> resolveHostnameForHost(Host host, List<Filter> filters) {
        return this.resolveHostname(host.getIp(), filters).thenApply(hostname -> {
            Host.Builder result = Host.from((Host)host);
            hostname.ifPresent(arg_0 -> ((Host.Builder)result).withHostname(arg_0));
            return result.build();
        });
    }

    private CompletableFuture<Optional<String>> resolveHostname(String ip, List<Filter> filters) {
        TimeRangeFilter timeRangeFilter = Filter.find(filters, TimeRangeFilter.class).orElse(null);
        String hostnameQuery = this.searchQueryProvider.getHostname(ip, filters);
        return this.searchAsync(hostnameQuery, timeRangeFilter).thenApply(res -> {
            JsonObject hit = AggregationUtils.getFirstHitSource(res);
            if (hit != null && Objects.equals(hit.getAsJsonPrimitive("host_address").getAsString(), ip)) {
                return Optional.ofNullable(hit.getAsJsonPrimitive("host_name")).map(JsonPrimitive::getAsString);
            }
            return Optional.empty();
        });
    }
}

