/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.model;

import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import org.hibernate.annotations.Filter;
import org.opennms.netmgt.model.OnmsNode;

@Entity
@Table(name="bridgeBridgeLink")
@Filter(name="authorizedOnly", condition="exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = nodeid and cg.groupId in (:userGroups)) and exists (select distinct x.nodeid from node x join category_node cn on x.nodeid = cn.nodeid join category_group cg on cn.categoryId = cg.categoryId where x.nodeid = designatednodeId and cg.groupId in (:userGroups))")
public class BridgeBridgeLink
implements Serializable {
    private static final long serialVersionUID = 5224397770784854885L;
    private Integer m_id;
    private OnmsNode m_node;
    private Integer m_bridgePort;
    private Integer m_bridgePortIfIndex;
    private String m_bridgePortIfName;
    private Integer m_vlan;
    private OnmsNode m_designatedNode;
    private Integer m_designatedPort;
    private Integer m_designatedPortIfIndex;
    private String m_designatedPortIfName;
    private Integer m_designatedVlan;
    private Date m_bridgeBridgeLinkCreateTime = new Date();
    private Date m_bridgeBridgeLinkLastPollTime;

    @Id
    @Column(nullable=false)
    @SequenceGenerator(name="opennmsSequence", sequenceName="opennmsNxtId")
    @GeneratedValue(generator="opennmsSequence")
    public Integer getId() {
        return this.m_id;
    }

    public void setId(Integer id) {
        this.m_id = id;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="nodeId")
    public OnmsNode getNode() {
        return this.m_node;
    }

    public void setNode(OnmsNode node) {
        this.m_node = node;
    }

    @Column(name="bridgePort")
    public Integer getBridgePort() {
        return this.m_bridgePort;
    }

    public void setBridgePort(Integer bridgePort) {
        this.m_bridgePort = bridgePort;
    }

    @Column(name="bridgePortIfIndex")
    public Integer getBridgePortIfIndex() {
        return this.m_bridgePortIfIndex;
    }

    public void setBridgePortIfIndex(Integer bridgePortIfIndex) {
        this.m_bridgePortIfIndex = bridgePortIfIndex;
    }

    @Column(name="bridgePortIfName", length=32)
    public String getBridgePortIfName() {
        return this.m_bridgePortIfName;
    }

    public void setBridgePortIfName(String bridgePortIfName) {
        this.m_bridgePortIfName = bridgePortIfName;
    }

    @Column(name="vlan")
    public Integer getVlan() {
        return this.m_vlan;
    }

    public void setVlan(Integer vlan) {
        this.m_vlan = vlan;
    }

    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="designatednodeId", referencedColumnName="nodeId")
    public OnmsNode getDesignatedNode() {
        return this.m_designatedNode;
    }

    public void setDesignatedNode(OnmsNode designatedNode) {
        this.m_designatedNode = designatedNode;
    }

    @Column(name="designatedBridgePort")
    public Integer getDesignatedPort() {
        return this.m_designatedPort;
    }

    public void setDesignatedPort(Integer bridgePort) {
        this.m_designatedPort = bridgePort;
    }

    @Column(name="designatedBridgePortIfIndex")
    public Integer getDesignatedPortIfIndex() {
        return this.m_designatedPortIfIndex;
    }

    public void setDesignatedPortIfIndex(Integer bridgePortIfIndex) {
        this.m_designatedPortIfIndex = bridgePortIfIndex;
    }

    @Column(name="designatedBridgePortIfName", length=32)
    public String getDesignatedPortIfName() {
        return this.m_designatedPortIfName;
    }

    public void setDesignatedPortIfName(String bridgePortIfName) {
        this.m_designatedPortIfName = bridgePortIfName;
    }

    @Column(name="designatedVlan")
    public Integer getDesignatedVlan() {
        return this.m_designatedVlan;
    }

    public void setDesignatedVlan(Integer vlan) {
        this.m_designatedVlan = vlan;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeBridgeLinkCreateTime", nullable=false)
    public Date getBridgeBridgeLinkCreateTime() {
        return this.m_bridgeBridgeLinkCreateTime;
    }

    public void setBridgeBridgeLinkCreateTime(Date bridgeLinkCreateTime) {
        this.m_bridgeBridgeLinkCreateTime = bridgeLinkCreateTime;
    }

    @Temporal(value=TemporalType.TIMESTAMP)
    @Column(name="bridgeBridgeLinkLastPollTime", nullable=false)
    public Date getBridgeBridgeLinkLastPollTime() {
        return this.m_bridgeBridgeLinkLastPollTime;
    }

    public void setBridgeBridgeLinkLastPollTime(Date bridgeLinkLastPollTime) {
        this.m_bridgeBridgeLinkLastPollTime = bridgeLinkLastPollTime;
    }

    public String toString() {
        return "bridge link: nodeid:[" + this.getNode().getId() + "], bridgeport:[" + this.getBridgePort() + "], ifindex:[" + this.getBridgePortIfIndex() + "], vlan:[" + this.getVlan() + "], designatednodeid:[" + this.getDesignatedNode().getId() + "],designatedbridgeport:[" + this.getDesignatedPort() + "],designatedifindex:[" + this.getDesignatedPortIfIndex() + "], designatedvlan:[" + this.getDesignatedVlan() + "]";
    }

    public void merge(BridgeBridgeLink element) {
        if (element == null) {
            return;
        }
        this.setBridgePortIfIndex(element.getBridgePortIfIndex());
        this.setBridgePortIfName(element.getBridgePortIfName());
        this.setVlan(element.getVlan());
        this.setDesignatedNode(element.getDesignatedNode());
        this.setDesignatedPort(element.getDesignatedPort());
        this.setDesignatedPortIfIndex(element.getDesignatedPortIfIndex());
        this.setDesignatedPortIfName(element.getDesignatedPortIfName());
        this.setDesignatedVlan(element.getDesignatedVlan());
        if (element.getBridgeBridgeLinkLastPollTime() == null) {
            this.setBridgeBridgeLinkLastPollTime(element.getBridgeBridgeLinkCreateTime());
        } else {
            this.setBridgeBridgeLinkLastPollTime(element.getBridgeBridgeLinkLastPollTime());
        }
    }
}

