/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.provision;

import com.google.common.base.Strings;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.opennms.netmgt.config.api.SnmpAgentConfigFactory;
import org.opennms.netmgt.config.snmpmetadata.Config;
import org.opennms.netmgt.config.snmpmetadata.Container;
import org.opennms.netmgt.config.snmpmetadata.Entry;
import org.opennms.netmgt.config.snmpmetadata.SnmpMetadataConfig;
import org.opennms.netmgt.config.snmpmetadata.SnmpMetadataConfigDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.events.api.annotations.EventHandler;
import org.opennms.netmgt.events.api.annotations.EventListener;
import org.opennms.netmgt.events.api.model.IEvent;
import org.opennms.netmgt.events.api.model.IParm;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.monitoringLocations.OnmsMonitoringLocation;
import org.opennms.netmgt.provision.ProvisioningAdapterException;
import org.opennms.netmgt.provision.SimplerQueuedProvisioningAdapter;
import org.opennms.netmgt.provision.SnmpMetadataException;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.proxy.LocationAwareSnmpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

@EventListener(name="SnmpMetadataProvisioningAdapter")
public class SnmpMetadataProvisioningAdapter
extends SimplerQueuedProvisioningAdapter
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(SnmpMetadataProvisioningAdapter.class);
    public static final String PREFIX = "Provisiond.";
    public static final String NAME = "SnmpMetadataProvisioningAdapter";
    public static final String CONTEXT = "snmp";
    private NodeDao nodeDao;
    private SnmpAgentConfigFactory snmpConfigDao;
    private LocationAwareSnmpClient locationAwareSnmpClient;
    private EventForwarder eventForwarder;
    private SnmpMetadataConfigDao snmpMetadataAdapterConfigDao;

    public SnmpMetadataProvisioningAdapter() {
        super(NAME);
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.nodeDao, (String)"Node DAO must not be null");
        Assert.notNull((Object)this.snmpConfigDao, (String)"SNMP Configuration DAO must not be null");
        Assert.notNull((Object)this.eventForwarder, (String)"Event Forwarder must not be null");
        Assert.notNull((Object)this.locationAwareSnmpClient, (String)"Location-Aware SNMP client must not be null");
        Assert.notNull((Object)((Object)this.snmpMetadataAdapterConfigDao), (String)"SNMP Metadata Configuration DAO must not be null");
    }

    @Override
    public void doAddNode(int nodeId) throws ProvisioningAdapterException {
        SnmpMetadataConfig snmpMetadataConfig = (SnmpMetadataConfig)this.snmpMetadataAdapterConfigDao.getContainer().getObject();
        if (!snmpMetadataConfig.isEnabled()) {
            LOG.debug("SnmpMetadataProvisioningAdapter not enabled. Skipping...");
            return;
        }
        LOG.debug("doAddNode: adding nodeId: {}", (Object)nodeId);
        this.queryNode(nodeId);
    }

    @Override
    public void doUpdateNode(int nodeId) throws ProvisioningAdapterException {
        SnmpMetadataConfig snmpMetadataConfig = (SnmpMetadataConfig)this.snmpMetadataAdapterConfigDao.getContainer().getObject();
        if (!snmpMetadataConfig.isEnabled()) {
            LOG.debug("SnmpMetadataProvisioningAdapter not enabled. Skipping...");
            return;
        }
        LOG.debug("doUpdateNode: updating nodeId: {}", (Object)nodeId);
        this.queryNode(nodeId);
    }

    public List<OnmsMetaData> createMetadata(OnmsNode node, OnmsIpInterface primaryInterface) throws SnmpMetadataException {
        SnmpMetadataConfig snmpMetadataConfig = (SnmpMetadataConfig)this.snmpMetadataAdapterConfigDao.getContainer().getObject();
        if (node.getSysObjectId() == null) {
            LOG.debug("Node {} does not support SNMP. Skipping...", (Object)node.getNodeId());
            return null;
        }
        List configs = snmpMetadataConfig.getConfigs().stream().filter(c -> {
            if (Strings.isNullOrEmpty((String)c.getSysObjectId())) {
                return false;
            }
            if (c.getSysObjectId().startsWith("~")) {
                String regExp = c.getSysObjectId().substring(1);
                return node.getSysObjectId().matches(regExp);
            }
            return node.getSysObjectId().equals(c.getSysObjectId());
        }).collect(Collectors.toList());
        OnmsMonitoringLocation location = node.getLocation();
        String locationName = location == null ? null : location.getLocationName();
        SnmpAgentConfig agentConfig = this.snmpConfigDao.getAgentConfig(primaryInterface.getIpAddress(), locationName);
        ArrayList<OnmsMetaData> results = new ArrayList<OnmsMetaData>();
        for (Config config : configs) {
            SnmpObjId rootOId = SnmpObjId.get((String)config.getTree());
            CompletableFuture resultFuture = this.locationAwareSnmpClient.walk(agentConfig, new SnmpObjId[]{rootOId}).withDescription("walk_" + config.getName() + "_" + node.getLabel()).withLocation(locationName).execute();
            try {
                for (Entry entry : config.getEntries()) {
                    results.addAll(this.processEntry(CONTEXT, rootOId.append(entry.getTree()), config.getName(), entry, (List)resultFuture.get(), new ArrayList<SnmpObjId>()));
                }
            }
            catch (ExecutionException e) {
                LOG.error("Aborting SNMP walk for " + String.valueOf(agentConfig), (Throwable)e);
                throw new SnmpMetadataException("Agent failed for OId " + config.getTree() + ": " + e.getMessage());
            }
            catch (InterruptedException e) {
                throw new SnmpMetadataException("SNMP walk interrupted, exiting");
            }
        }
        return results;
    }

    public void queryNode(int nodeId) {
        OnmsNode node = (OnmsNode)this.nodeDao.get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            LOG.debug("Failed to return node for given nodeId: {}" + nodeId);
            return;
        }
        OnmsIpInterface primaryInterface = node.getPrimaryInterface();
        if (primaryInterface == null) {
            throw new ProvisioningAdapterException("Can't find primary interface for nodeId: " + nodeId);
        }
        EventBuilder ebldr = null;
        try {
            List<OnmsMetaData> results = this.createMetadata(node, primaryInterface);
            if (results == null) {
                return;
            }
            if (((SnmpMetadataConfig)this.snmpMetadataAdapterConfigDao.getContainer().getObject()).getResultsBehavior().equals("update")) {
                for (OnmsMetaData result : results) {
                    node.addMetaData(result.getContext(), result.getKey(), result.getValue());
                }
            } else {
                results.addAll(node.getMetaData().stream().filter(m -> !m.getContext().equals(CONTEXT)).collect(Collectors.toList()));
                node.setMetaData(results);
            }
            this.nodeDao.saveOrUpdate((Object)node);
            ebldr = new EventBuilder("uei.opennms.org/internal/discovery/hardwareInventorySuccessful", "Provisiond.SnmpMetadataProvisioningAdapter");
            ebldr.addParam("method", NAME);
            ebldr.setNodeid((long)nodeId);
            ebldr.setInterface(primaryInterface.getIpAddress());
            this.getEventForwarder().sendNow(ebldr.getEvent());
        }
        catch (Throwable e) {
            ebldr = new EventBuilder("uei.opennms.org/internal/discovery/hardwareInventoryFailed", "Provisiond.SnmpMetadataProvisioningAdapter");
            ebldr.addParam("method", NAME);
            ebldr.setNodeid((long)nodeId);
            ebldr.setInterface(primaryInterface.getIpAddress());
            ebldr.addParam("reason", e.getMessage());
            this.getEventForwarder().sendNow(ebldr.getEvent());
        }
    }

    private List<OnmsMetaData> processEntry(String context, SnmpObjId baseOId, String parentName, Container entry, List<SnmpResult> walk, List<SnmpObjId> indices) {
        ArrayList<OnmsMetaData> results = new ArrayList<OnmsMetaData>();
        if (indices != null && indices.size() > 0) {
            for (SnmpObjId index : indices) {
                Optional<SnmpResult> result = walk.stream().filter(s -> s.getAbsoluteInstance().equals((Object)baseOId.append(index))).findFirst();
                if (!result.isPresent()) continue;
                results.add(new OnmsMetaData(context, parentName + "[" + String.valueOf(index) + "]." + entry.getName(), result.get().getValue().toDisplayString()));
            }
        } else {
            Optional<SnmpResult> result = walk.stream().filter(s -> s.getAbsoluteInstance().equals((Object)(entry.isExact() ? baseOId : baseOId.append(".0")))).findFirst();
            if (result.isPresent()) {
                results.add(new OnmsMetaData(context, parentName + "." + entry.getName(), result.get().getValue().toDisplayString()));
            }
        }
        if (entry.getEntries().size() > 0) {
            List matchingIndexOIds = entry.getEntries().stream().filter(e -> e.isIndex()).map(e -> baseOId.append(SnmpObjId.get((String)e.getTree()))).collect(Collectors.toList());
            Optional firstIndex = matchingIndexOIds.stream().findFirst();
            List<Object> newIndices = firstIndex.isPresent() ? walk.stream().map(s -> s.getAbsoluteInstance()).filter(s -> ((SnmpObjId)firstIndex.get()).isPrefixOf(s)).map(s -> this.stripPrefix((SnmpObjId)s, (SnmpObjId)firstIndex.get())).collect(Collectors.toList()) : new ArrayList();
            for (Entry next : entry.getEntries()) {
                results.addAll(this.processEntry(context, baseOId.append(next.getTree()), (String)(parentName == null ? "" : parentName + ".") + entry.getName(), next, walk, newIndices));
            }
        }
        return results;
    }

    private SnmpObjId stripPrefix(SnmpObjId snmpObjId, SnmpObjId prefix) {
        if (prefix.isPrefixOf(snmpObjId)) {
            int[] ids = snmpObjId.getIds();
            int[] pfx = prefix.getIds();
            SnmpObjId newOid = SnmpObjId.get((int[])Arrays.copyOfRange(ids, pfx.length, ids.length));
            return newOid;
        }
        return null;
    }

    @Override
    public void doNotifyConfigChange(int nodeId) throws ProvisioningAdapterException {
        LOG.debug("doNotifyConfigChange: nodeid: {}", (Object)nodeId);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @EventHandler(uei="uei.opennms.org/internal/reloadDaemonConfig")
    public void handleReloadConfigEvent(IEvent event) {
        if (this.isReloadConfigEventTarget(event)) {
            EventBuilder ebldr = null;
            LOG.debug("Reloading the Hardware Inventory adapter configuration");
            try {
                this.snmpMetadataAdapterConfigDao.getContainer().reload();
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigSuccessful", "Provisiond.SnmpMetadataProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.SnmpMetadataProvisioningAdapter");
            }
            catch (Throwable e) {
                LOG.warn("Unable to reload Hardware Inventory adapter configuration", e);
                ebldr = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfigFailed", "Provisiond.SnmpMetadataProvisioningAdapter");
                ebldr.addParam("daemonName", "Provisiond.SnmpMetadataProvisioningAdapter");
                ebldr.addParam("reason", e.getMessage());
            }
            if (ebldr != null) {
                ebldr.addParam("method", NAME);
                this.getEventForwarder().sendNow(ebldr.getEvent());
            }
        }
    }

    private boolean isReloadConfigEventTarget(IEvent event) {
        boolean isTarget = false;
        for (IParm parm : event.getParmCollection()) {
            if (!"daemonName".equals(parm.getParmName()) || !"Provisiond.SnmpMetadataProvisioningAdapter".equalsIgnoreCase(parm.getValue().getContent())) continue;
            isTarget = true;
            break;
        }
        LOG.debug("isReloadConfigEventTarget: Provisiond. {} was target of reload event: {}", (Object)NAME, (Object)isTarget);
        return isTarget;
    }

    public NodeDao getNodeDao() {
        return this.nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.nodeDao = nodeDao;
    }

    public SnmpAgentConfigFactory getSnmpConfigDao() {
        return this.snmpConfigDao;
    }

    public void setSnmpConfigDao(SnmpAgentConfigFactory snmpConfigDao) {
        this.snmpConfigDao = snmpConfigDao;
    }

    public LocationAwareSnmpClient getLocationAwareSnmpClient() {
        return this.locationAwareSnmpClient;
    }

    public void setLocationAwareSnmpClient(LocationAwareSnmpClient locationAwareSnmpClient) {
        this.locationAwareSnmpClient = locationAwareSnmpClient;
    }

    public EventForwarder getEventForwarder() {
        return this.eventForwarder;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public SnmpMetadataConfigDao getSnmpMetadataAdapterConfigDao() {
        return this.snmpMetadataAdapterConfigDao;
    }

    public void setSnmpMetadataAdapterConfigDao(SnmpMetadataConfigDao snmpMetadataAdapterConfigDao) {
        this.snmpMetadataAdapterConfigDao = snmpMetadataAdapterConfigDao;
    }
}

