/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.values;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.MissingTemplateException;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElement;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.InformationElementDatabase;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Semantics;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ie.Value;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.DataRecord;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FieldSpecifier;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.ipfix.proto.FlowSetHeader;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Field;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Session;
import org.opennms.netmgt.telemetry.protocols.netflow.parser.session.Template;

public class ListValue
extends Value<List<List<Value<?>>>> {
    private final Semantic semantic;
    private final List<List<Value<?>>> values;

    public ListValue(String name, Optional<Semantics> semantics, Semantic semantic, List<List<Value<?>>> values) {
        super(name, semantics);
        this.semantic = Objects.requireNonNull(semantic);
        this.values = Objects.requireNonNull(values);
    }

    public static InformationElement parserWithBasicList(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) throws InvalidPacketException, MissingTemplateException {
                Semantic semantic = Semantic.parse(buffer, BufferUtils.uint8((ByteBuf)buffer));
                FieldSpecifier field = new FieldSpecifier(database, buffer);
                LinkedList values = new LinkedList();
                while (buffer.isReadable()) {
                    values.add(Collections.singletonList(DataRecord.parseField(field, resolver, buffer)));
                }
                return new ListValue(name, semantics, semantic, values);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 5;
            }

            @Override
            public int getMaximumFieldLength() {
                return 65535;
            }
        };
    }

    public static InformationElement parserWithSubTemplateList(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) throws InvalidPacketException, MissingTemplateException {
                Semantic semantic = Semantic.parse(buffer, BufferUtils.uint8((ByteBuf)buffer));
                int templateId = BufferUtils.uint16((ByteBuf)buffer);
                Template template = resolver.lookupTemplate(templateId);
                LinkedList values = new LinkedList();
                while (buffer.isReadable()) {
                    ArrayList record = new ArrayList(template.count());
                    for (Field field : template) {
                        record.add(DataRecord.parseField(field, resolver, buffer));
                    }
                    values.add(record);
                }
                return new ListValue(name, semantics, semantic, values);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 3;
            }

            @Override
            public int getMaximumFieldLength() {
                return 65535;
            }
        };
    }

    public static InformationElement parserWithSubTemplateMultiList(InformationElementDatabase database, final String name, final Optional<Semantics> semantics) {
        return new InformationElement(){

            @Override
            public Value<?> parse(InformationElementDatabase database, Session.Resolver resolver, ByteBuf buffer) throws InvalidPacketException, MissingTemplateException {
                Semantic semantic = Semantic.parse(buffer, BufferUtils.uint8((ByteBuf)buffer));
                LinkedList values = new LinkedList();
                while (buffer.isReadable()) {
                    FlowSetHeader header = new FlowSetHeader(buffer);
                    if (header.setId <= 255) {
                        throw new InvalidPacketException(buffer, "Invalid template ID: %d", header.setId);
                    }
                    ByteBuf payloadBuffer = BufferUtils.slice((ByteBuf)buffer, (int)(header.length - 4));
                    Template template = resolver.lookupTemplate(header.setId);
                    while (payloadBuffer.isReadable()) {
                        ArrayList record = new ArrayList(template.count());
                        for (Field field : template) {
                            record.add(DataRecord.parseField(field, resolver, payloadBuffer));
                        }
                        values.add(record);
                    }
                }
                return new ListValue(name, semantics, semantic, values);
            }

            @Override
            public String getName() {
                return name;
            }

            @Override
            public int getMinimumFieldLength() {
                return 0;
            }

            @Override
            public int getMaximumFieldLength() {
                return 65535;
            }
        };
    }

    @Override
    public List<List<Value<?>>> getValue() {
        return this.values;
    }

    public Semantic getSemantic() {
        return this.semantic;
    }

    @Override
    public void visit(Value.Visitor visitor) {
        visitor.accept(this);
    }

    public static enum Semantic {
        UNDEFINED,
        NONE_OF,
        EXACTLY_ONE_OF,
        ONE_OR_MORE_OF,
        ALL_OF,
        ORDERED;


        public static Semantic parse(ByteBuf buffer, int i) throws InvalidPacketException {
            switch (i) {
                case 255: {
                    return UNDEFINED;
                }
                case 0: {
                    return NONE_OF;
                }
                case 1: {
                    return EXACTLY_ONE_OF;
                }
                case 2: {
                    return ONE_OR_MORE_OF;
                }
                case 3: {
                    return ALL_OF;
                }
                case 4: {
                    return ORDERED;
                }
            }
            throw new InvalidPacketException(buffer, "Illegal semantic value: 0x%02x", i);
        }
    }
}

