/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import org.opennms.core.utils.LldpUtils;
import org.opennms.netmgt.enlinkd.model.LldpElement;
import org.opennms.netmgt.enlinkd.snmp.LldpSnmpUtils;
import org.opennms.netmgt.snmp.AggregateTracker;
import org.opennms.netmgt.snmp.Collectable;
import org.opennms.netmgt.snmp.ErrorStatus;
import org.opennms.netmgt.snmp.ErrorStatusException;
import org.opennms.netmgt.snmp.NamedSnmpVar;
import org.opennms.netmgt.snmp.SnmpResult;
import org.opennms.netmgt.snmp.SnmpStore;
import org.opennms.netmgt.snmp.SnmpValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LldpLocalGroupTracker
extends AggregateTracker {
    private static final Logger LOG = LoggerFactory.getLogger(LldpLocalGroupTracker.class);
    public static final String LLDP_LOC_CHASSISID_SUBTYPE_ALIAS = "lldpLocChassisIdSubtype";
    public static final String LLDP_LOC_CHASSISID_SUBTYPE_OID = ".1.0.8802.1.1.2.1.3.1";
    public static final String LLDP_LOC_CHASSISID_ALIAS = "lldpLocChassisId";
    public static final String LLDP_LOC_CHASSISID_OID = ".1.0.8802.1.1.2.1.3.2";
    public static final String LLDP_LOC_SYSNAME_ALIAS = "lldpLocSysName";
    public static final String LLDP_LOC_SYSNAME_OID = ".1.0.8802.1.1.2.1.3.3";
    public static NamedSnmpVar[] ms_elemList = new NamedSnmpVar[3];
    private final SnmpStore m_store = new SnmpStore(ms_elemList);

    public LldpLocalGroupTracker() {
        super((Collectable[])NamedSnmpVar.getTrackersFor((NamedSnmpVar[])ms_elemList));
    }

    public Integer getLldpLocChassisidSubType() {
        return this.m_store.getInt32(LLDP_LOC_CHASSISID_SUBTYPE_ALIAS);
    }

    public SnmpValue getLldpLocChassisid() {
        return this.m_store.getValue(LLDP_LOC_CHASSISID_ALIAS);
    }

    public String getLldpLocSysname() {
        return this.m_store.getDisplayString(LLDP_LOC_SYSNAME_ALIAS);
    }

    protected void storeResult(SnmpResult res) {
        this.m_store.storeResult(res);
    }

    protected void reportGenErr(String msg) {
        LOG.warn("Error retrieving LLDP local group: {}", (Object)msg);
    }

    protected void reportNoSuchNameErr(String msg) {
        LOG.info("Error retrieving LLDP local group: {}", (Object)msg);
    }

    protected void reportFatalErr(ErrorStatusException ex) {
        LOG.warn("Error retrieving LLDP local group: {}", (Object)ex.getMessage(), (Object)ex);
    }

    protected void reportNonFatalErr(ErrorStatus status) {
        LOG.info("Non-fatal error ({}) retrieving LLDP local group: {}", (Object)status, (Object)(status.retry() ? "Retrying." : "Giving up."));
    }

    public LldpElement getLldpElement() {
        LldpElement lldpElement = new LldpElement();
        lldpElement.setLldpChassisIdSubType(LldpUtils.LldpChassisIdSubType.get((Integer)this.getLldpLocChassisidSubType()));
        lldpElement.setLldpChassisId(LldpSnmpUtils.decodeLldpChassisId(lldpElement.getLldpChassisIdSubType(), this.getLldpLocChassisid()));
        lldpElement.setLldpSysname(this.getLldpLocSysname());
        return lldpElement;
    }

    public void printSnmpData() {
        System.out.printf("\t\t%s (%s)= %s (%s)\n", LLDP_LOC_CHASSISID_SUBTYPE_OID, LLDP_LOC_CHASSISID_SUBTYPE_ALIAS, this.getLldpLocChassisidSubType(), LldpUtils.LldpChassisIdSubType.get((Integer)this.getLldpLocChassisidSubType()));
        System.out.printf("\t\t%s (%s)= %s \n", LLDP_LOC_CHASSISID_OID, LLDP_LOC_CHASSISID_ALIAS, LldpSnmpUtils.decodeLldpChassisId(LldpUtils.LldpChassisIdSubType.get((Integer)this.getLldpLocChassisidSubType()), this.getLldpLocChassisid()));
        System.out.printf("\t\t%s (%s)= %s \n", LLDP_LOC_SYSNAME_OID, LLDP_LOC_SYSNAME_ALIAS, this.getLldpLocSysname());
    }

    static {
        int ndx = 0;
        LldpLocalGroupTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpInt32", LLDP_LOC_CHASSISID_SUBTYPE_ALIAS, LLDP_LOC_CHASSISID_SUBTYPE_OID);
        LldpLocalGroupTracker.ms_elemList[ndx++] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", LLDP_LOC_CHASSISID_ALIAS, LLDP_LOC_CHASSISID_OID);
        LldpLocalGroupTracker.ms_elemList[ndx] = new NamedSnmpVar("org.opennms.protocols.snmp.SnmpOctetString", LLDP_LOC_SYSNAME_ALIAS, LLDP_LOC_SYSNAME_OID);
    }
}

