/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.config.snmp;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import org.opennms.netmgt.config.snmp.Configuration;
import org.opennms.netmgt.config.snmp.Range;
import org.opennms.netmgt.config.snmp.SnmpConfigVisitor;

@XmlRootElement(name="definition")
@XmlAccessorType(value=XmlAccessType.NONE)
@XmlType(propOrder={"m_ranges", "m_specifics", "m_ipMatches"})
public class Definition
extends Configuration
implements Serializable {
    private static final long serialVersionUID = 5646937263626185373L;
    @XmlElement(name="range")
    private List<Range> m_ranges = new ArrayList<Range>();
    @XmlElement(name="specific")
    private List<String> m_specifics = new ArrayList<String>();
    @XmlElement(name="ip-match")
    private List<String> m_ipMatches = new ArrayList<String>();
    @XmlAttribute(name="location")
    private String m_location;
    @XmlAttribute(name="profile-label")
    private String m_profileLabel;

    public List<Range> getRanges() {
        if (this.m_ranges == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_ranges);
    }

    public void setRanges(List<Range> ranges) {
        this.m_ranges = new ArrayList<Range>(ranges);
    }

    public void addRange(Range range) throws IndexOutOfBoundsException {
        this.m_ranges.add(range);
    }

    public boolean removeRange(Range range) {
        return this.m_ranges.remove(range);
    }

    public List<String> getSpecifics() {
        if (this.m_specifics == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_specifics);
    }

    public void setSpecifics(List<String> specifics) {
        this.m_specifics = new ArrayList<String>(specifics);
    }

    public void addSpecific(String specific) throws IndexOutOfBoundsException {
        this.m_specifics.add(specific);
    }

    public boolean removeSpecific(String specific) {
        return this.m_specifics.remove(specific);
    }

    public List<String> getIpMatches() {
        if (this.m_ipMatches == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.m_ipMatches);
    }

    public void setIpMatches(List<String> ipMatches) {
        this.m_ipMatches = new ArrayList<String>(ipMatches);
    }

    public void addIpMatch(String ipMatch) throws IndexOutOfBoundsException {
        this.m_ipMatches.add(ipMatch);
    }

    public boolean removeIpMatch(String ipMatch) {
        return this.m_ipMatches.remove(ipMatch);
    }

    public String getLocation() {
        return this.m_location;
    }

    public void setLocation(String location) {
        this.m_location = location;
    }

    public String getProfileLabel() {
        return this.m_profileLabel;
    }

    public void setProfileLabel(String profileLabel) {
        this.m_profileLabel = profileLabel;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.m_ipMatches == null ? 0 : this.m_ipMatches.hashCode());
        result = 31 * result + (this.m_ranges == null ? 0 : this.m_ranges.hashCode());
        result = 31 * result + (this.m_specifics == null ? 0 : this.m_specifics.hashCode());
        result = 31 * result + (this.m_location == null ? 0 : this.m_location.hashCode());
        result = 31 * result + (this.m_profileLabel == null ? 0 : this.m_profileLabel.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof Definition)) {
            return false;
        }
        Definition other = (Definition)obj;
        if (this.m_ipMatches == null ? other.m_ipMatches != null : !this.m_ipMatches.equals(other.m_ipMatches)) {
            return false;
        }
        if (this.m_ranges == null ? other.m_ranges != null : !this.m_ranges.equals(other.m_ranges)) {
            return false;
        }
        if (this.m_specifics == null ? other.m_specifics != null : !this.m_specifics.equals(other.m_specifics)) {
            return false;
        }
        if (this.m_location == null) {
            if (other.m_location != null) {
                return false;
            }
        } else {
            if (!this.m_location.equals(other.m_location)) {
                return false;
            }
            if (!this.m_profileLabel.equals(other.m_profileLabel)) {
                return false;
            }
        }
        return true;
    }

    public void visit(SnmpConfigVisitor visitor) {
        visitor.visitDefinition(this);
        visitor.visitSpecifics(this.getSpecifics());
        visitor.visitSpecificsFinished();
        visitor.visitRanges(this.getRanges());
        visitor.visitRangesFinished();
        visitor.visitIpMatches(this.getIpMatches());
        visitor.visitIpMatchesFinished();
        visitor.visitDefinitionFinished();
    }

    @Override
    public String toString() {
        return "Definition [authPassphrase=" + this.getAuthPassphrase() + ", authProtocol=" + this.getAuthProtocol() + ", contextEngineId=" + this.getContextEngineId() + ", contextName=" + this.getContextName() + ", engineId=" + this.getEngineId() + ", enterpriseId=" + this.getEnterpriseId() + ", maxRepetitions=" + this.getMaxRepetitions() + ", maxRequestSize=" + this.getMaxRequestSize() + ", maxVarsPerPdu=" + this.getMaxVarsPerPdu() + ", port=" + this.getPort() + ", privacyPassphrase=" + this.getPrivacyPassphrase() + ", privacyProtocol=" + this.getPrivacyProtocol() + ", proxyHost=" + this.getProxyHost() + ", readCommunity=" + this.getReadCommunity() + ", retries=" + this.getRetry() + ", securityLevel=" + this.getSecurityLevel() + ", securityName=" + this.getSecurityName() + ", timeout=" + this.getTimeout() + ", version=" + this.getVersion() + ", writeCommunity=" + this.getWriteCommunity() + ", ranges=" + String.valueOf(this.m_ranges) + ", specifics=" + String.valueOf(this.m_specifics) + ", ipMatches=" + String.valueOf(this.m_ipMatches) + "]";
    }
}

