/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.utils.assets;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;
import org.opennms.core.logging.Logging;
import org.opennms.core.sysprops.SystemProperties;
import org.opennms.core.utils.StringUtils;
import org.opennms.web.utils.assets.AssetLocator;
import org.opennms.web.utils.assets.AssetResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.UrlResource;
import org.springframework.util.FileCopyUtils;
import org.springframework.web.context.support.ServletContextResource;
import org.springframework.web.servlet.resource.AbstractResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolverChain;

public class AssetLocatorImpl
extends AbstractResourceResolver
implements AssetLocator,
InitializingBean {
    private static Logger LOG = LoggerFactory.getLogger(AssetLocatorImpl.class);
    private static AssetLocator s_instance;
    private static final Resource s_assetsPath;
    private ScheduledExecutorService m_executor = null;
    private Map<String, List<AssetResource>> m_unminified = new HashMap<String, List<AssetResource>>();
    private Map<String, List<AssetResource>> m_minified = new HashMap<String, List<AssetResource>>();
    long m_lastModified = 0L;
    long m_reload;
    String m_filesystemPath = System.getProperty("org.opennms.web.assets.path");
    boolean m_useMinified = Boolean.parseBoolean(System.getProperty("org.opennms.web.assets.minified", "true"));

    public static AssetLocator getInstance() {
        return s_instance;
    }

    public AssetLocatorImpl() {
        this.m_reload = SystemProperties.getLong((String)"org.opennms.web.assets.reload", (Long)5000L);
    }

    @Override
    public long lastModified() {
        return this.m_lastModified;
    }

    @Override
    public Collection<String> getAssets() {
        return this.getAssets(this.m_useMinified);
    }

    @Override
    public Collection<String> getAssets(boolean minified) {
        return minified ? this.m_minified.keySet() : this.m_unminified.keySet();
    }

    @Override
    public Optional<Collection<AssetResource>> getResources(String assetName) {
        return this.getResources(assetName, this.m_useMinified);
    }

    @Override
    public Optional<Collection<AssetResource>> getResources(String assetName, boolean minified) {
        return Optional.ofNullable(minified ? (Collection)this.m_minified.get(assetName) : (Collection)this.m_unminified.get(assetName));
    }

    @Override
    public Optional<AssetResource> getResource(String assetName, String type) {
        return this.getResource(assetName, type, this.m_useMinified);
    }

    @Override
    public Optional<AssetResource> getResource(String assetName, String type, boolean minified) {
        Optional<Collection<AssetResource>> resources = this.getResources(assetName, minified);
        if (resources.isPresent()) {
            Collection<AssetResource> r = resources.get();
            return r.parallelStream().filter(resource -> type.equals(resource.getType())).findFirst();
        }
        return Optional.empty();
    }

    @Override
    public Optional<InputStream> open(String assetName, String type) throws IOException {
        return this.open(assetName, type, this.m_useMinified);
    }

    @Override
    public Optional<InputStream> open(String assetName, String type, boolean minified) throws IOException {
        return this.withLogPrefix(() -> {
            Optional<AssetResource> r = this.getResource(assetName, type, minified);
            if (!r.isPresent()) {
                LOG.info("Unable to locate asset resource {}:{}", (Object)assetName, (Object)type);
                return Optional.empty();
            }
            AssetResource resource = r.get();
            if (this.m_filesystemPath != null) {
                Path p = Paths.get(this.m_filesystemPath, new String[0]).resolve(resource.getPath());
                LOG.debug("assets path is set, attempting to load {}:{} from {}", new Object[]{assetName, type, p});
                if (p.toFile().exists()) {
                    return Optional.of(new FileInputStream(p.toFile()));
                }
            }
            String resourcePath = resource.getPath();
            LOG.debug("Opening resource {} for asset {}", (Object)resourcePath, r);
            URL url = this.getClass().getResource(resourcePath);
            if (url != null) {
                return Optional.of(url.openStream());
            }
            return Optional.of(new ClassPathResource(resourcePath).getInputStream());
        });
    }

    @Override
    public void reload() {
        Map<String, List<AssetResource>> minified = this.loadAssets(true);
        Map<String, List<AssetResource>> unminified = this.loadAssets(false);
        if (minified != null) {
            this.m_minified = minified;
        }
        if (unminified != null) {
            this.m_unminified = unminified;
        }
    }

    public void afterPropertiesSet() throws Exception {
        if (this.m_reload > 0L) {
            this.m_executor = Executors.newSingleThreadScheduledExecutor();
            this.m_executor.scheduleAtFixedRate(() -> this.reload(), this.m_reload, this.m_reload, TimeUnit.MILLISECONDS);
        }
        this.reload();
        s_instance = this;
    }

    public long getReloadMinutes() {
        return this.m_reload;
    }

    public void setReloadMinutes(long minutes) {
        this.m_reload = minutes;
    }

    public boolean getUseMinified() {
        return this.m_useMinified;
    }

    public void setUseMinified(boolean minified) {
        this.m_useMinified = minified;
    }

    private Map<String, List<AssetResource>> loadAssets(boolean minified) {
        return this.withLogPrefix(() -> {
            try {
                Path p;
                HashMap newAssets = new HashMap();
                ClassPathResource r = new ClassPathResource(minified ? "/assets/assets.min.json" : "/assets/assets.json");
                if (this.m_filesystemPath != null && (p = Paths.get(this.m_filesystemPath, new String[0]).resolve(minified ? "assets.min.json" : "assets.json")).toFile().exists()) {
                    r = new FileSystemResource(p.toFile());
                }
                LOG.debug("Loading asset data from {}", (Object)r);
                byte[] bdata = FileCopyUtils.copyToByteArray((InputStream)r.getInputStream());
                String json = new String(bdata, StandardCharsets.UTF_8);
                JSONObject assetsObj = new JSONObject(json);
                JSONArray names = assetsObj.names();
                for (int i = 0; i < names.length(); ++i) {
                    String assetName = names.getString(i);
                    JSONObject assetObj = assetsObj.getJSONObject(assetName);
                    ArrayList<AssetResource> assets = new ArrayList<AssetResource>(assetObj.length());
                    JSONArray keys = assetObj.names();
                    int count = 0;
                    for (int j = 0; j < keys.length(); ++j) {
                        String type = keys.getString(j);
                        if (assetObj.isNull(type)) continue;
                        Object item = assetObj.get(type);
                        if (item instanceof JSONArray) {
                            LOG.debug("{} is an anonymous type resource; skipping indexing", (Object)type);
                            continue;
                        }
                        String path = assetObj.getString(type);
                        assets.add(new AssetResource(assetName, type, path));
                        ++count;
                    }
                    if (count <= 0) continue;
                    newAssets.put(assetName, assets);
                }
                this.m_lastModified = Math.max(this.getLastModified(), r.lastModified());
                return newAssets;
            }
            catch (Exception e) {
                LOG.warn("Failed to load asset manifest.", (Throwable)e);
                return null;
            }
        });
    }

    private long getLastModified() {
        long lastModified = 0L;
        if (this.m_filesystemPath != null) {
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(this.m_filesystemPath, new String[0]));){
                for (Path path : stream) {
                    lastModified = Math.max(path.toFile().lastModified(), lastModified);
                }
            }
            catch (IOException e) {
                LOG.warn("Failed to scan {} for modified files.", (Object)this.m_filesystemPath);
            }
        }
        return lastModified;
    }

    protected Resource resolveResourceInternal(HttpServletRequest request, String requestPath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return this.getResource(requestPath, locations);
    }

    protected Resource getResource(String requestPath, List<? extends Resource> locations) {
        return this.withLogPrefix(() -> {
            for (Resource location : locations) {
                try {
                    if (this.resourcesMatch(s_assetsPath, location)) {
                        int index;
                        Resource resource = location.createRelative(requestPath);
                        LOG.debug("checking request {} in location {}", (Object)requestPath, (Object)location);
                        String fileName = resource.getFilename();
                        if (this.m_filesystemPath != null) {
                            File f = Paths.get(this.m_filesystemPath, fileName).toFile();
                            LOG.debug("Checking for resource in filesystem: {}", (Object)f);
                            if (f.exists() && f.canRead()) {
                                LOG.trace("File exists and is readable: {}", (Object)f);
                                return new FileSystemResource(f);
                            }
                        }
                        if ((index = fileName.lastIndexOf(".")) > 0) {
                            String assetName = fileName.substring(0, index);
                            String type = fileName.substring(index + 1);
                            Optional<AssetResource> assetResource = this.getResource(assetName, type);
                            LOG.debug("Checking for resource in classpath: {}.{} ({})", new Object[]{assetName, type, assetResource});
                            if (assetResource.isPresent()) {
                                ClassPathResource relativeResource = new ClassPathResource("/" + assetResource.get().getPath());
                                LOG.debug("Using ClassPathResource: {}", (Object)relativeResource);
                                if (relativeResource.exists() && relativeResource.isReadable()) {
                                    LOG.trace("Resource exists and is readable: {}", (Object)relativeResource);
                                    return relativeResource;
                                }
                            } else {
                                LOG.debug("Asset resource was not found: {}:{}", (Object)assetName, (Object)type);
                            }
                        }
                        if (resource.exists()) {
                            return resource;
                        }
                    }
                    LOG.debug("unhandled location {} for request path {}", (Object)location, (Object)requestPath);
                }
                catch (IOException e) {
                    LOG.debug("Failed to create relative path from {} in {}. Trying next location.", new Object[]{requestPath, location, e});
                }
            }
            return null;
        });
    }

    private boolean resourcesMatch(Resource a, Resource b) {
        String aPath = this.getPath(a);
        String bPath = this.getPath(b);
        if (aPath == null || bPath == null) {
            return false;
        }
        return aPath.equals(bPath);
    }

    private String getPath(Resource resource) {
        String ret = null;
        if (resource instanceof UrlResource) {
            try {
                ret = resource.getURL().toExternalForm();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (resource instanceof ClassPathResource) {
            ret = ((ClassPathResource)resource).getPath();
        } else if (resource instanceof ServletContextResource) {
            ret = ((ServletContextResource)resource).getPath();
        } else {
            try {
                ret = resource.getURL().getPath();
            }
            catch (IOException e) {
                return null;
            }
        }
        if (ret == null) {
            return null;
        }
        String retString = StringUtils.trim((String)ret);
        return retString.startsWith("/") ? retString.substring(1) : retString;
    }

    protected String resolveUrlPathInternal(String resourcePath, List<? extends Resource> locations, ResourceResolverChain chain) {
        return StringUtils.hasText((String)resourcePath) && this.getResource(resourcePath, locations) != null ? resourcePath : null;
    }

    private <T> T withLogPrefix(Callable<T> cb) {
        try {
            return (T)Logging.withPrefix((String)"web", cb);
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
    }

    static {
        s_assetsPath = new ClassPathResource("/assets/");
    }
}

