/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import com.google.common.base.Strings;
import com.google.gson.Gson;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.opennms.features.distributed.kvstore.api.JsonStore;
import org.opennms.netmgt.dao.api.GraphDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.RrdDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.svclayer.api.GraphResultsService;
import org.opennms.web.svclayer.model.Graph;
import org.opennms.web.svclayer.model.GraphResults;
import org.opennms.web.svclayer.model.RelativeTimePeriod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultGraphResultsService
implements GraphResultsService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultGraphResultsService.class);
    public static final String RESOURCE_IDS_CONTEXT = "resourceIds";
    private ResourceDao m_resourceDao;
    private GraphDao m_graphDao;
    private NodeDao m_nodeDao;
    private RrdDao m_rrdDao;
    private EventProxy m_eventProxy;
    private JsonStore m_jsonStore;
    private final Gson m_gson = new Gson();
    private RelativeTimePeriod[] m_periods = RelativeTimePeriod.getDefaultPeriods();

    @Override
    public GraphResults findResults(ResourceId[] resourceIds, String[] reports, String generatedId, String nodeCriteria, long start, long end, String relativeTime) {
        Optional result;
        OnmsResource nodeResource;
        OnmsNode node;
        if (reports == null) {
            throw new IllegalArgumentException("reports argument cannot be null");
        }
        if (end < start) {
            throw new IllegalArgumentException("end time cannot be before start time");
        }
        GraphResults graphResults = new GraphResults();
        graphResults.setStart(new Date(start));
        graphResults.setEnd(new Date(end));
        graphResults.setRelativeTime(relativeTime);
        graphResults.setRelativeTimePeriods(this.m_periods);
        graphResults.setReports(reports);
        graphResults.setNodeCriteria(nodeCriteria);
        graphResults.setGeneratedId(generatedId);
        HashMap<ResourceId, Object> resourcesMap = new HashMap<ResourceId, Object>();
        for (ResourceId resourceId : resourceIds) {
            LOG.debug("findResults: parent, childType, childName = {}, {}, {}", new Object[]{resourceId.parent, resourceId.type, resourceId.name});
            OnmsResource resource = null;
            if (!resourcesMap.containsKey(resourceId.parent)) {
                List resourceList = this.m_resourceDao.getResourceById(resourceId).getChildResources();
                if (resourceList == null) {
                    LOG.warn("findResults: zero child resources found for {}", (Object)resourceId.parent);
                } else {
                    resourcesMap.put(resourceId.parent, resourceList);
                    LOG.debug("findResults: add resourceList to map for {}", (Object)resourceId.parent);
                }
            }
            for (OnmsResource r : (List)resourcesMap.get(resourceId.parent)) {
                if (!resourceId.type.equals(r.getResourceType().getName()) || !resourceId.name.equals(r.getName())) continue;
                resource = r;
                LOG.debug("findResults: found resource in map{}", (Object)r.toString());
                break;
            }
            try {
                graphResults.addGraphResultSet(this.createGraphResultSet(resourceId, resource, reports, graphResults));
            }
            catch (IllegalArgumentException e) {
                LOG.warn(e.getMessage(), (Throwable)e);
            }
        }
        if (!Strings.isNullOrEmpty((String)nodeCriteria) && (node = this.m_nodeDao.get(nodeCriteria)) != null && (nodeResource = this.m_resourceDao.getResourceForNode(node)) != null) {
            List childResources = nodeResource.getChildResources();
            for (OnmsResource resource : childResources) {
                try {
                    graphResults.addGraphResultSet(this.createGraphResultSet(null, resource, reports, graphResults));
                }
                catch (IllegalArgumentException e) {
                    LOG.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
        if (!Strings.isNullOrEmpty((String)generatedId) && (result = this.m_jsonStore.get(generatedId, RESOURCE_IDS_CONTEXT)).isPresent()) {
            try {
                String[] resourceArray;
                for (String resourceId : resourceArray = (String[])this.m_gson.fromJson((String)result.get(), String[].class)) {
                    try {
                        OnmsResource resource = this.m_resourceDao.getResourceById(ResourceId.fromString((String)resourceId));
                        if (resource == null) continue;
                        graphResults.addGraphResultSet(this.createGraphResultSet(null, resource, reports, graphResults));
                    }
                    catch (IllegalArgumentException e) {
                        LOG.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Exception while parsing json string {}", result.get());
            }
        }
        graphResults.setGraphTopOffsetWithText(this.m_rrdDao.getGraphTopOffsetWithText());
        graphResults.setGraphLeftOffset(this.m_rrdDao.getGraphLeftOffset());
        graphResults.setGraphRightOffset(this.m_rrdDao.getGraphRightOffset());
        return graphResults;
    }

    @Override
    public PrefabGraph[] getAllPrefabGraphs(ResourceId resourceId) {
        OnmsResource resource = this.m_resourceDao.getResourceById(resourceId);
        return this.m_graphDao.getPrefabGraphsForResource(resource);
    }

    private GraphResults.GraphResultSet createGraphResultSet(ResourceId resourceId, OnmsResource resource, String[] reports, GraphResults graphResults) throws IllegalArgumentException {
        if (resource == null && (resource = this.m_resourceDao.getResourceById(resourceId)) == null) {
            throw new IllegalArgumentException("Could not find resource \"" + String.valueOf(resourceId) + "\"");
        }
        GraphResults.GraphResultSet rs = graphResults.new GraphResults.GraphResultSet();
        rs.setResource(resource);
        if (reports.length == 1 && "all".equals(reports[0])) {
            PrefabGraph[] queries = this.m_graphDao.getPrefabGraphsForResource(resource);
            ArrayList<String> queryNames = new ArrayList<String>(queries.length);
            for (String string : queries) {
                queryNames.add(string.getName());
            }
            reports = queryNames.toArray(new String[queryNames.size()]);
        }
        ArrayList<Graph> graphs = new ArrayList<Graph>(reports.length);
        LinkedList<String> filesToPromote = new LinkedList<String>();
        for (String string : reports) {
            PrefabGraph prefabGraph = this.m_graphDao.getPrefabGraph(string);
            Graph graph = new Graph(prefabGraph, resource, graphResults.getStart(), graphResults.getEnd());
            this.getAttributeFiles(graph, filesToPromote);
            graphs.add(graph);
        }
        this.sendEvent(filesToPromote);
        Collections.sort(graphs);
        rs.setGraphs(graphs);
        return rs;
    }

    private void sendEvent(List<String> filesToPromote) {
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/promoteQueueData", "OpenNMS.Webapp");
        bldr.addParam("filesToPromote", filesToPromote);
        try {
            this.m_eventProxy.send(bldr.getEvent());
        }
        catch (EventProxyException e) {
            LOG.warn("Unable to send promotion event to opennms daemon", (Throwable)e);
        }
    }

    private void getAttributeFiles(Graph graph, List<String> filesToPromote) {
        Collection<RrdGraphAttribute> attrs = graph.getRequiredRrGraphdAttributes();
        String rrdBaseDir = System.getProperty("rrd.base.dir");
        for (RrdGraphAttribute rrdAttr : attrs) {
            LOG.debug("getAttributeFiles: ResourceType, ParentResourceType = {}, {}", (Object)rrdAttr.getResource().getResourceType().getLabel(), (Object)rrdAttr.getResource().getParent().getResourceType().getLabel());
            if (rrdAttr.getResource().getParent().getResourceType().getLabel().equals("nodeSource")) {
                filesToPromote.add(rrdBaseDir + File.separator + "fs" + File.separator + rrdAttr.getRrdRelativePath());
                continue;
            }
            filesToPromote.add(rrdBaseDir + File.separator + rrdAttr.getRrdRelativePath());
        }
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"nodeDao property has not been set");
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"resourceDao property has not been set");
        Assert.state((this.m_graphDao != null ? 1 : 0) != 0, (String)"graphDao property has not been set");
        Assert.state((this.m_rrdDao != null ? 1 : 0) != 0, (String)"rrdDao property has not been set");
        Assert.state((this.m_jsonStore != null ? 1 : 0) != 0, (String)"jsonStore property has not been set");
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public GraphDao getGraphDao() {
        return this.m_graphDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public RrdDao getRrdDao() {
        return this.m_rrdDao;
    }

    public void setRrdDao(RrdDao rrdDao) {
        this.m_rrdDao = rrdDao;
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    public void setJsonStore(JsonStore jsonStore) {
        this.m_jsonStore = jsonStore;
    }
}

