/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.poller.monitors;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.mate.api.Interpolator;
import org.opennms.core.spring.BeanUtils;
import org.opennms.core.utils.ParameterMap;
import org.opennms.core.wsman.WSManClient;
import org.opennms.core.wsman.WSManClientFactory;
import org.opennms.core.wsman.WSManEndpoint;
import org.opennms.core.wsman.cxf.CXFWSManClientFactory;
import org.opennms.core.wsman.exceptions.WSManException;
import org.opennms.core.wsman.utils.ResponseHandlingUtils;
import org.opennms.core.wsman.utils.RetryNTimesLoop;
import org.opennms.netmgt.config.wsman.credentials.Definition;
import org.opennms.netmgt.dao.WSManConfigDao;
import org.opennms.netmgt.poller.MonitoredService;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.netmgt.poller.monitors.support.ParameterSubstitutingMonitor;
import org.opennms.netmgt.provision.detector.wsman.WsmanEndpointUtils;
import org.w3c.dom.Node;

public class WsManMonitor
extends ParameterSubstitutingMonitor {
    private static final String WSMAN_RETRY_KEY = "retry";
    public static final String RESOURCE_URI_PARAM = "resource-uri";
    public static final String RULE_PARAM = "rule";
    public static final String SELECTOR_PARAM_PREFIX = "selector.";
    private WSManClientFactory m_factory = new CXFWSManClientFactory();
    private WSManConfigDao m_wsManConfigDao;

    public Map<String, Object> getRuntimeAttributes(MonitoredService svc, Map<String, Object> parameters) {
        Map runtimeAttributes = super.getRuntimeAttributes(svc, parameters);
        if (this.m_wsManConfigDao == null) {
            this.m_wsManConfigDao = (WSManConfigDao)BeanUtils.getBean((String)"daoContext", (String)"wsManConfigDao", WSManConfigDao.class);
        }
        Definition config = this.m_wsManConfigDao.getAgentConfig(svc.getAddress());
        WsmanEndpointUtils.toMap(WSManConfigDao.getEndpoint(config, svc.getAddress())).forEach((key, value) -> runtimeAttributes.put(key, Interpolator.pleaseInterpolate((Object)value)));
        runtimeAttributes.put(WSMAN_RETRY_KEY, config.getRetry());
        return runtimeAttributes;
    }

    public PollStatus poll(MonitoredService svc, Map<String, Object> parameters) {
        WSManEndpoint endpoint;
        String resourceUri = WsManMonitor.getKeyedString(parameters, (String)RESOURCE_URI_PARAM, null);
        if (resourceUri == null) {
            throw new IllegalArgumentException("'resource-uri' parameter is required.");
        }
        String rule = WsManMonitor.resolveKeyedString(parameters, (String)RULE_PARAM, null);
        if (rule == null) {
            throw new IllegalArgumentException("'rule' parameter is required.");
        }
        HashMap selectors = Maps.newHashMap();
        for (Map.Entry<String, Object> parameter : parameters.entrySet()) {
            if (!parameter.getKey().startsWith(SELECTOR_PARAM_PREFIX)) continue;
            String selectorKey = parameter.getKey().substring(SELECTOR_PARAM_PREFIX.length());
            Object selectorValue = parameter.getValue();
            if (selectorValue == null) continue;
            selectors.put(selectorKey, selectorValue instanceof String ? (String)selectorValue : selectorValue.toString());
        }
        try {
            Map<String, String> filteredMap = parameters.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(e -> (String)e.getKey(), e -> e.getValue().toString()));
            endpoint = WsmanEndpointUtils.fromMap(filteredMap);
        }
        catch (MalformedURLException e2) {
            return PollStatus.down((String)e2.getMessage());
        }
        WSManClient client = this.m_factory.getClient(endpoint);
        RetryNTimesLoop retryLoop = new RetryNTimesLoop(ParameterMap.getKeyedInteger(parameters, (String)WSMAN_RETRY_KEY, (int)0));
        Node node = null;
        try {
            while (retryLoop.shouldContinue()) {
                try {
                    node = client.get(resourceUri, (Map)selectors);
                    break;
                }
                catch (WSManException e3) {
                    retryLoop.takeException(e3);
                }
            }
        }
        catch (WSManException e4) {
            return PollStatus.down((String)e4.getMessage());
        }
        if (node == null) {
            return PollStatus.down((String)String.format("No resource was found at URI: '%s' with selectors: '%s'.", resourceUri, selectors));
        }
        ListMultimap<String, String> elementValues = ResponseHandlingUtils.toMultiMap(node);
        try {
            ResponseHandlingUtils.getMatchingIndex(rule, elementValues);
            return PollStatus.up();
        }
        catch (NoSuchElementException e5) {
            return PollStatus.down((String)String.format("No index was matched by rule: '%s' with values '%s'.", rule, elementValues));
        }
    }

    public void setWSManConfigDao(WSManConfigDao wsManConfigDao) {
        this.m_wsManConfigDao = Objects.requireNonNull(wsManConfigDao);
    }

    public void setWSManClientFactory(WSManClientFactory factory) {
        this.m_factory = Objects.requireNonNull(factory);
    }
}

