/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.navigate;

import java.util.List;
import org.opennms.web.navigate.DisplayStatus;
import org.opennms.web.navigate.MenuContext;
import org.opennms.web.navigate.NavBarEntry;

public class LocationBasedNavBarEntry
implements NavBarEntry {
    private String m_locationMatch;
    private String m_url;
    private String m_name;
    private String m_systemProperty;
    private String m_systemPropertyValue;
    private List<NavBarEntry> m_entries;

    @Override
    public String getDisplayString() {
        return this.m_name;
    }

    @Override
    public String getUrl() {
        return this.m_url;
    }

    public void setUrl(String url) {
        this.m_url = url;
    }

    @Override
    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    @Override
    public String getSystemProperty() {
        return this.m_systemProperty;
    }

    public void setSystemProperty(String systemProperty) {
        this.m_systemProperty = systemProperty;
    }

    @Override
    public String getSystemPropertyValue() {
        return this.m_systemPropertyValue;
    }

    public void setSystemPropertyValue(String systemPropertyValue) {
        this.m_systemPropertyValue = systemPropertyValue;
    }

    @Override
    public List<NavBarEntry> getEntries() {
        return this.m_entries;
    }

    public void setEntries(List<NavBarEntry> entries) {
        this.m_entries = entries;
    }

    @Override
    public boolean hasEntries() {
        return this.m_entries != null && this.m_entries.size() > 0;
    }

    @Override
    public DisplayStatus evaluate(MenuContext context) {
        if (!this.evaluateSystemProperty()) {
            return DisplayStatus.NO_DISPLAY;
        }
        return this.isLinkMatches(context) ? DisplayStatus.DISPLAY_NO_LINK : DisplayStatus.DISPLAY_LINK;
    }

    private boolean evaluateSystemProperty() {
        if (this.m_systemProperty != null && !this.m_systemProperty.isEmpty() && this.m_systemPropertyValue != null && !this.m_systemPropertyValue.isEmpty()) {
            String value = System.getProperty(this.m_systemProperty);
            return value != null && !value.isEmpty() && value.equals(this.m_systemPropertyValue);
        }
        return true;
    }

    public String getLocationMatch() {
        return this.m_locationMatch;
    }

    public void setLocationMatch(String locationMatch) {
        this.m_locationMatch = locationMatch;
    }

    protected boolean isLinkMatches(MenuContext context) {
        return this.m_locationMatch.equals(context.getLocation());
    }
}

