/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.scheduler.command;

import org.apache.karaf.scheduler.Scheduler;
import org.apache.karaf.scheduler.command.support.TriggerJob;
import org.apache.karaf.shell.api.action.Action;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Option;
import org.apache.karaf.shell.api.action.lifecycle.Reference;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="scheduler", name="trigger", description="Manually trigger a scheduled job")
@Service
public class Trigger
implements Action {
    @Argument(description="Name of the job to trigger", required=true)
    String name;
    @Option(name="-b", aliases={"background"}, description="schedule the trigger in the background", required=false)
    boolean background = false;
    @Reference
    Scheduler scheduler;

    public Object execute() throws Exception {
        if (this.background) {
            System.out.println("Scheduling background trigger for job " + this.name);
            this.scheduler.schedule(new TriggerJob(this.scheduler, this.name), this.scheduler.NOW());
        } else {
            System.out.println("Triggering job " + this.name);
            if (!this.scheduler.trigger(this.name)) {
                System.out.println("Could not find a scheduled job with name " + this.name);
            }
        }
        return null;
    }
}

