/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Paint;
import java.awt.Stroke;
import java.io.IOException;
import javax.swing.ImageIcon;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.data.DataProcessor;
import org.jrobin.graph.Area;
import org.jrobin.graph.CommentText;
import org.jrobin.graph.HRule;
import org.jrobin.graph.ImageParameters;
import org.jrobin.graph.ImageWorker;
import org.jrobin.graph.LegendComposer;
import org.jrobin.graph.LegendText;
import org.jrobin.graph.Line;
import org.jrobin.graph.Mapper;
import org.jrobin.graph.PlotElement;
import org.jrobin.graph.PrintText;
import org.jrobin.graph.RrdGraphConstants;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.RrdGraphInfo;
import org.jrobin.graph.Source;
import org.jrobin.graph.SourcedPlotElement;
import org.jrobin.graph.Stack;
import org.jrobin.graph.TimeAxis;
import org.jrobin.graph.VRule;
import org.jrobin.graph.ValueAxis;
import org.jrobin.graph.ValueAxisLogarithmic;
import org.jrobin.graph.ValueAxisMrtg;
import org.jrobin.graph.ValueScaler;

public class RrdGraph
implements RrdGraphConstants {
    RrdGraphDef gdef;
    ImageParameters im = new ImageParameters();
    DataProcessor dproc;
    ImageWorker worker;
    Mapper mapper;
    RrdGraphInfo info = new RrdGraphInfo();
    private String signature;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RrdGraph(RrdGraphDef gdef) throws IOException, RrdException {
        this.gdef = gdef;
        this.signature = gdef.getSignature();
        this.worker = new ImageWorker(100, 100);
        try {
            this.createGraph();
        }
        finally {
            this.worker.dispose();
            this.worker = null;
            this.dproc = null;
        }
    }

    public RrdGraphInfo getRrdGraphInfo() {
        return this.info;
    }

    private void createGraph() throws RrdException, IOException {
        boolean lazy = this.lazyCheck();
        if (!lazy || this.gdef.printStatementCount() != 0) {
            this.fetchData();
            this.resolveTextElements();
            if (this.gdef.shouldPlot() && !lazy) {
                this.calculatePlotValues();
                this.findMinMaxValues();
                this.identifySiUnit();
                this.expandValueRange();
                this.removeOutOfRangeRules();
                this.initializeLimits();
                this.placeLegends();
                this.createImageWorker();
                this.drawBackground();
                this.drawData();
                this.drawGrid();
                this.drawAxis();
                this.drawText();
                this.drawLegend();
                this.drawRules();
                this.gator();
                this.drawOverlay();
                this.saveImage();
            }
        }
        this.collectInfo();
    }

    private void collectInfo() {
        this.info.filename = this.gdef.filename;
        this.info.width = this.im.xgif;
        this.info.height = this.im.ygif;
        for (CommentText comment : this.gdef.comments) {
            PrintText pt;
            if (!(comment instanceof PrintText) || !(pt = (PrintText)comment).isPrint()) continue;
            this.info.addPrintLine(pt.resolvedText);
        }
        if (this.gdef.imageInfo != null) {
            this.info.imgInfo = Util.sprintf(this.gdef.imageInfo, this.gdef.filename, this.im.xgif, this.im.ygif);
        }
    }

    private void saveImage() throws IOException {
        this.info.bytes = !this.gdef.filename.equals("-") ? this.worker.saveImage(this.gdef.filename, this.gdef.imageFormat, this.gdef.imageQuality) : this.worker.getImageBytes(this.gdef.imageFormat, this.gdef.imageQuality);
    }

    private void drawOverlay() throws IOException {
        if (this.gdef.overlayImage != null) {
            this.worker.loadImage(this.gdef.overlayImage);
        }
    }

    private void gator() {
        if (!this.gdef.onlyGraph && this.gdef.showSignature) {
            Font font = this.gdef.getFont(5);
            int x = (int)((double)(this.im.xgif - 2) - this.worker.getFontAscent(font));
            int y = 4;
            this.worker.transform(x, y, 1.5707963267948966);
            this.worker.drawString(this.signature, 0, 0, font, Color.LIGHT_GRAY);
            this.worker.reset();
        }
    }

    private void drawRules() {
        this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
        for (PlotElement pe : this.gdef.plotElements) {
            if (pe instanceof HRule) {
                HRule hr = (HRule)pe;
                if (!(hr.value >= this.im.minval) || !(hr.value <= this.im.maxval)) continue;
                int y = this.mapper.ytr(hr.value);
                this.worker.drawLine(this.im.xorigin, y, this.im.xorigin + this.im.xsize, y, hr.color, new BasicStroke(hr.width));
                continue;
            }
            if (!(pe instanceof VRule)) continue;
            VRule vr = (VRule)pe;
            if (vr.timestamp < this.im.start || vr.timestamp > this.im.end) continue;
            int x = this.mapper.xtr(vr.timestamp);
            this.worker.drawLine(x, this.im.yorigin, x, this.im.yorigin - this.im.ysize, vr.color, new BasicStroke(vr.width));
        }
        this.worker.reset();
    }

    private void drawText() {
        if (!this.gdef.onlyGraph) {
            int y;
            int x;
            if (this.gdef.title != null) {
                x = this.im.xgif / 2 - (int)(this.worker.getStringWidth(this.gdef.title, this.gdef.getFont(1)) / 2.0);
                y = 12 + (int)this.worker.getFontAscent(this.gdef.getFont(1));
                this.worker.drawString(this.gdef.title, x, y, this.gdef.getFont(1), this.gdef.colors[6]);
            }
            if (this.gdef.verticalLabel != null) {
                x = 10;
                y = this.im.yorigin - this.im.ysize / 2 + (int)this.worker.getStringWidth(this.gdef.verticalLabel, this.gdef.getFont(3)) / 2;
                int ascent = (int)this.worker.getFontAscent(this.gdef.getFont(3));
                this.worker.transform(x, y, -1.5707963267948966);
                this.worker.drawString(this.gdef.verticalLabel, 0, ascent, this.gdef.getFont(3), this.gdef.colors[6]);
                this.worker.reset();
            }
        }
    }

    private void drawGrid() {
        if (!this.gdef.onlyGraph) {
            boolean ok;
            Paint shade1 = this.gdef.colors[2];
            Paint shade2 = this.gdef.colors[3];
            BasicStroke borderStroke = new BasicStroke(1.0f);
            this.worker.drawLine(0, 0, this.im.xgif - 1, 0, shade1, borderStroke);
            this.worker.drawLine(1, 1, this.im.xgif - 2, 1, shade1, borderStroke);
            this.worker.drawLine(0, 0, 0, this.im.ygif - 1, shade1, borderStroke);
            this.worker.drawLine(1, 1, 1, this.im.ygif - 2, shade1, borderStroke);
            this.worker.drawLine(this.im.xgif - 1, 0, this.im.xgif - 1, this.im.ygif - 1, shade2, borderStroke);
            this.worker.drawLine(0, this.im.ygif - 1, this.im.xgif - 1, this.im.ygif - 1, shade2, borderStroke);
            this.worker.drawLine(this.im.xgif - 2, 1, this.im.xgif - 2, this.im.ygif - 2, shade2, borderStroke);
            this.worker.drawLine(1, this.im.ygif - 2, this.im.xgif - 2, this.im.ygif - 2, shade2, borderStroke);
            if (this.gdef.drawXGrid) {
                new TimeAxis(this).draw();
            }
            if (this.gdef.drawYGrid && !(ok = this.gdef.altYMrtg ? new ValueAxisMrtg(this).draw() : (this.gdef.logarithmic ? new ValueAxisLogarithmic(this).draw() : new ValueAxis(this).draw()))) {
                String msg = "No Data Found";
                this.worker.drawString(msg, this.im.xgif / 2 - (int)this.worker.getStringWidth(msg, this.gdef.getFont(1)) / 2, (2 * this.im.yorigin - this.im.ysize) / 2, this.gdef.getFont(1), this.gdef.colors[6]);
            }
        }
    }

    private void drawData() throws RrdException {
        this.worker.setAntiAliasing(this.gdef.antiAliasing);
        this.worker.clip(this.im.xorigin + 1, this.im.yorigin - this.gdef.height - 1, this.gdef.width - 1, this.gdef.height + 2);
        double areazero = this.mapper.ytr(this.im.minval > 0.0 ? this.im.minval : (this.im.maxval < 0.0 ? this.im.maxval : 0.0));
        double[] x = this.xtr(this.dproc.getTimestamps());
        double[] lastY = null;
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (!(plotElement instanceof SourcedPlotElement)) continue;
            SourcedPlotElement source = (SourcedPlotElement)plotElement;
            double[] y = this.ytr(source.getValues());
            if (source instanceof Line) {
                this.worker.drawPolyline(x, y, source.color, (Stroke)new BasicStroke(((Line)source).width));
            } else if (source instanceof Area) {
                this.worker.fillPolygon(x, areazero, y, source.color);
            } else if (source instanceof Stack) {
                Stack stack = (Stack)source;
                float width = stack.getParentLineWidth();
                if (width >= 0.0f) {
                    this.worker.drawPolyline(x, y, stack.color, (Stroke)new BasicStroke(width));
                } else {
                    this.worker.fillPolygon(x, lastY, y, stack.color);
                    this.worker.drawPolyline(x, lastY, stack.getParentColor(), (Stroke)new BasicStroke(0.0f));
                }
            } else {
                throw new RrdException("Unknown plot source: " + source.getClass().getName());
            }
            lastY = y;
        }
        this.worker.reset();
        this.worker.setAntiAliasing(false);
    }

    private void drawAxis() {
        if (!this.gdef.onlyGraph) {
            Paint gridColor = this.gdef.colors[4];
            Paint fontColor = this.gdef.colors[6];
            Paint arrowColor = this.gdef.colors[8];
            BasicStroke stroke = new BasicStroke(1.0f);
            this.worker.drawLine(this.im.xorigin + this.im.xsize, this.im.yorigin, this.im.xorigin + this.im.xsize, this.im.yorigin - this.im.ysize, gridColor, stroke);
            this.worker.drawLine(this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xorigin + this.im.xsize, this.im.yorigin - this.im.ysize, gridColor, stroke);
            this.worker.drawLine(this.im.xorigin - 4, this.im.yorigin, this.im.xorigin + this.im.xsize + 4, this.im.yorigin, fontColor, stroke);
            this.worker.drawLine(this.im.xorigin, this.im.yorigin, this.im.xorigin, this.im.yorigin - this.im.ysize, gridColor, stroke);
            this.worker.drawLine(this.im.xorigin + this.im.xsize + 4, this.im.yorigin - 3, this.im.xorigin + this.im.xsize + 4, this.im.yorigin + 3, arrowColor, stroke);
            this.worker.drawLine(this.im.xorigin + this.im.xsize + 4, this.im.yorigin - 3, this.im.xorigin + this.im.xsize + 9, this.im.yorigin, arrowColor, stroke);
            this.worker.drawLine(this.im.xorigin + this.im.xsize + 4, this.im.yorigin + 3, this.im.xorigin + this.im.xsize + 9, this.im.yorigin, arrowColor, stroke);
        }
    }

    private void drawBackground() throws IOException {
        this.worker.fillRect(0, 0, this.im.xgif, this.im.ygif, this.gdef.colors[1]);
        if (this.gdef.backgroundImage != null) {
            this.worker.loadImage(this.gdef.backgroundImage);
        }
        this.worker.fillRect(this.im.xorigin, this.im.yorigin - this.im.ysize, this.im.xsize, this.im.ysize, this.gdef.colors[0]);
    }

    private void createImageWorker() {
        this.worker.resize(this.im.xgif, this.im.ygif);
    }

    private void placeLegends() {
        if (!this.gdef.noLegend && !this.gdef.onlyGraph) {
            int border = (int)(this.getSmallFontCharWidth() * 2.0);
            LegendComposer lc = new LegendComposer(this, border, this.im.ygif, this.im.xgif - 2 * border);
            this.im.ygif = lc.placeComments() + 6;
        }
    }

    private void initializeLimits() throws RrdException {
        this.im.xsize = this.gdef.width;
        this.im.ysize = this.gdef.height;
        this.im.unitslength = this.gdef.unitsLength;
        if (this.gdef.onlyGraph) {
            if (this.im.ysize > 64) {
                throw new RrdException("Cannot create graph only, height too big");
            }
            this.im.xorigin = 0;
        } else {
            this.im.xorigin = (int)(10.0 + (double)this.im.unitslength * this.getSmallFontCharWidth());
        }
        if (this.gdef.verticalLabel != null) {
            this.im.xorigin = (int)((double)this.im.xorigin + this.getFontHeight(3));
        }
        this.im.yorigin = this.gdef.onlyGraph ? this.im.ysize : 12 + this.im.ysize;
        this.mapper = new Mapper(this);
        if (this.gdef.title != null) {
            this.im.yorigin = (int)((double)this.im.yorigin + (this.getFontHeight(1) + 6.0));
        }
        if (this.gdef.onlyGraph) {
            this.im.xgif = this.im.xsize;
            this.im.ygif = this.im.yorigin;
        } else {
            this.im.xgif = 16 + this.im.xsize + this.im.xorigin;
            this.im.ygif = this.im.yorigin + (int)(2.0 * this.getFontHeight(0));
        }
    }

    private void removeOutOfRangeRules() {
        for (PlotElement plotElement : this.gdef.plotElements) {
            if (plotElement instanceof HRule) {
                ((HRule)plotElement).setLegendVisibility(this.im.minval, this.im.maxval, this.gdef.forceRulesLegend);
                continue;
            }
            if (!(plotElement instanceof VRule)) continue;
            ((VRule)plotElement).setLegendVisibility(this.im.start, this.im.end, this.gdef.forceRulesLegend);
        }
    }

    private void expandValueRange() {
        this.im.ygridstep = this.gdef.valueAxisSetting != null ? this.gdef.valueAxisSetting.gridStep : Double.NaN;
        int n = this.im.ylabfact = this.gdef.valueAxisSetting != null ? this.gdef.valueAxisSetting.labelFactor : 0;
        if (!this.gdef.rigid && !this.gdef.logarithmic) {
            double[] sensiblevalues = new double[]{1000.0, 900.0, 800.0, 750.0, 700.0, 600.0, 500.0, 400.0, 300.0, 250.0, 200.0, 125.0, 100.0, 90.0, 80.0, 75.0, 70.0, 60.0, 50.0, 40.0, 30.0, 25.0, 20.0, 10.0, 9.0, 8.0, 7.0, 6.0, 5.0, 4.0, 3.5, 3.0, 2.5, 2.0, 1.8, 1.5, 1.2, 1.0, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3, 0.2, 0.1, 0.0, -1.0};
            if (Double.isNaN(this.im.ygridstep)) {
                if (this.gdef.altYMrtg) {
                    double scaled_max;
                    double scaled_min;
                    this.im.decimals = Math.ceil(Math.log10(Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))));
                    this.im.quadrant = 0;
                    if (this.im.minval < 0.0) {
                        this.im.quadrant = 2;
                        if (this.im.maxval <= 0.0) {
                            this.im.quadrant = 4;
                        }
                    }
                    switch (this.im.quadrant) {
                        case 2: {
                            this.im.scaledstep = Math.ceil(50.0 * Math.pow(10.0, -this.im.decimals) * Math.max(Math.abs(this.im.maxval), Math.abs(this.im.minval))) * Math.pow(10.0, this.im.decimals - 2.0);
                            scaled_min = -2.0 * this.im.scaledstep;
                            scaled_max = 2.0 * this.im.scaledstep;
                            break;
                        }
                        case 4: {
                            this.im.scaledstep = Math.ceil(25.0 * Math.pow(10.0, -this.im.decimals) * Math.abs(this.im.minval)) * Math.pow(10.0, this.im.decimals - 2.0);
                            scaled_min = -4.0 * this.im.scaledstep;
                            scaled_max = 0.0;
                            break;
                        }
                        default: {
                            this.im.scaledstep = Math.ceil(25.0 * Math.pow(10.0, -this.im.decimals) * this.im.maxval) * Math.pow(10.0, this.im.decimals - 2.0);
                            scaled_min = 0.0;
                            scaled_max = 4.0 * this.im.scaledstep;
                        }
                    }
                    this.im.minval = scaled_min;
                    this.im.maxval = scaled_max;
                } else if (this.gdef.altAutoscale) {
                    double delt = this.im.maxval - this.im.minval;
                    double adj = delt * 0.1;
                    double fact = 2.0 * Math.pow(10.0, Math.floor(Math.log10(Math.max(Math.abs(this.im.minval), Math.abs(this.im.maxval)))) - 2.0);
                    if (delt < fact) {
                        adj = (fact - delt) * 0.55;
                    }
                    this.im.minval -= adj;
                    this.im.maxval += adj;
                } else if (this.gdef.altAutoscaleMax) {
                    double adj = (this.im.maxval - this.im.minval) * 0.1;
                    this.im.maxval += adj;
                } else {
                    double scaled_min = this.im.minval / this.im.magfact;
                    double scaled_max = this.im.maxval / this.im.magfact;
                    int i = 1;
                    while (sensiblevalues[i] > 0.0) {
                        if (sensiblevalues[i - 1] >= scaled_min && sensiblevalues[i] <= scaled_min) {
                            this.im.minval = sensiblevalues[i] * this.im.magfact;
                        }
                        if (-sensiblevalues[i - 1] <= scaled_min && -sensiblevalues[i] >= scaled_min) {
                            this.im.minval = -sensiblevalues[i - 1] * this.im.magfact;
                        }
                        if (sensiblevalues[i - 1] >= scaled_max && sensiblevalues[i] <= scaled_max) {
                            this.im.maxval = sensiblevalues[i - 1] * this.im.magfact;
                        }
                        if (-sensiblevalues[i - 1] <= scaled_max && -sensiblevalues[i] >= scaled_max) {
                            this.im.maxval = -sensiblevalues[i] * this.im.magfact;
                        }
                        ++i;
                    }
                }
            } else {
                this.im.minval = (double)this.im.ylabfact * this.im.ygridstep * Math.floor(this.im.minval / ((double)this.im.ylabfact * this.im.ygridstep));
                this.im.maxval = (double)this.im.ylabfact * this.im.ygridstep * Math.ceil(this.im.maxval / ((double)this.im.ylabfact * this.im.ygridstep));
            }
        }
    }

    private void identifySiUnit() {
        this.im.unitsexponent = this.gdef.unitsExponent;
        this.im.base = this.gdef.base;
        if (!this.gdef.logarithmic) {
            char[] symbol = new char[]{'a', 'f', 'p', 'n', 'u', 'm', ' ', 'k', 'M', 'G', 'T', 'P', 'E'};
            int symbcenter = 6;
            double digits = this.im.unitsexponent != Integer.MAX_VALUE ? Math.floor((double)this.im.unitsexponent / 3.0) : Math.floor(Math.log(Math.max(Math.abs(this.im.minval), Math.abs(this.im.maxval))) / Math.log(this.im.base));
            this.im.magfact = Math.pow(this.im.base, digits);
            this.im.symbol = digits + (double)symbcenter < (double)symbol.length && digits + (double)symbcenter >= 0.0 ? symbol[(int)digits + symbcenter] : (char)63;
        }
    }

    private void findMinMaxValues() {
        double minval = Double.NaN;
        double maxval = Double.NaN;
        for (PlotElement pe : this.gdef.plotElements) {
            if (!(pe instanceof SourcedPlotElement)) continue;
            minval = Util.min(((SourcedPlotElement)pe).getMinValue(), minval);
            maxval = Util.max(((SourcedPlotElement)pe).getMaxValue(), maxval);
        }
        if (Double.isNaN(minval)) {
            minval = 0.0;
        }
        if (Double.isNaN(maxval)) {
            maxval = 1.0;
        }
        this.im.minval = this.gdef.minValue;
        this.im.maxval = this.gdef.maxValue;
        if (Double.isNaN(this.im.minval) || !this.gdef.logarithmic && !this.gdef.rigid && this.im.minval > minval) {
            this.im.minval = minval;
        }
        if (Double.isNaN(this.im.maxval) || !this.gdef.rigid && this.im.maxval < maxval) {
            this.im.maxval = this.gdef.logarithmic ? maxval * 1.1 : maxval;
        }
        if (this.im.minval > this.im.maxval) {
            this.im.minval = 0.99 * this.im.maxval;
        }
        if (Math.abs(this.im.minval - this.im.maxval) < 1.0E-7) {
            this.im.maxval *= 1.01;
            if (!this.gdef.logarithmic) {
                this.im.minval *= 0.99;
            }
            if (this.im.maxval == 0.0) {
                this.im.maxval = 1.0;
            }
        }
    }

    private void calculatePlotValues() throws RrdException {
        for (PlotElement pe : this.gdef.plotElements) {
            if (!(pe instanceof SourcedPlotElement)) continue;
            ((SourcedPlotElement)pe).assignValues(this.dproc);
        }
    }

    private void resolveTextElements() throws RrdException {
        ValueScaler valueScaler = new ValueScaler(this.gdef.base);
        for (CommentText comment : this.gdef.comments) {
            comment.resolveText(this.dproc, valueScaler);
        }
    }

    private void fetchData() throws RrdException, IOException {
        this.dproc = new DataProcessor(this.gdef.startTime, this.gdef.endTime);
        this.dproc.setPoolUsed(this.gdef.poolUsed);
        if (this.gdef.step > 0L) {
            this.dproc.setStep(this.gdef.step);
        }
        for (Source src : this.gdef.sources) {
            src.requestData(this.dproc);
        }
        this.dproc.processData();
        this.im.start = this.gdef.startTime;
        this.im.end = this.gdef.endTime;
    }

    private boolean lazyCheck() {
        if (!this.gdef.lazy || !Util.fileExists(this.gdef.filename)) {
            return false;
        }
        long secPerPixel = (this.gdef.endTime - this.gdef.startTime) / (long)this.gdef.width;
        long elapsed = Util.getTimestamp() - Util.getLastModified(this.gdef.filename);
        return elapsed <= secPerPixel;
    }

    private void drawLegend() {
        if (!this.gdef.onlyGraph && !this.gdef.noLegend) {
            int ascent = (int)this.worker.getFontAscent(this.gdef.getFont(4));
            int box = (int)this.getBox();
            int boxSpace = (int)this.getBoxSpace();
            for (CommentText c : this.gdef.comments) {
                if (!c.isValidGraphElement()) continue;
                int x = c.x;
                int y = c.y + ascent;
                if (c instanceof LegendText) {
                    this.worker.fillRect(x, y - box, box, box, this.gdef.colors[7]);
                    this.worker.fillRect(x + 1, y - box + 1, box - 2, box - 2, this.gdef.colors[0]);
                    this.worker.fillRect(x + 1, y - box + 1, box - 2, box - 2, ((LegendText)c).legendColor);
                    this.worker.drawString(c.resolvedText, x + boxSpace, y, this.gdef.getFont(4), this.gdef.colors[6]);
                    continue;
                }
                this.worker.drawString(c.resolvedText, x, y, this.gdef.getFont(4), this.gdef.colors[6]);
            }
        }
    }

    double getFontHeight(int fonttag) {
        return this.worker.getFontHeight(this.gdef.getFont(fonttag));
    }

    double getFontCharWidth(int fonttag) {
        return this.worker.getStringWidth("a", this.gdef.getFont(fonttag));
    }

    double getSmallFontHeight() {
        return this.getFontHeight(4);
    }

    private double getTitleFontHeight() {
        return this.getFontHeight(1);
    }

    private double getSmallFontCharWidth() {
        return this.getFontCharWidth(4);
    }

    double getInterlegendSpace() {
        return this.getFontCharWidth(4) * 2.0;
    }

    double getLeading() {
        return this.getFontHeight(4) * 1.2;
    }

    double getSmallLeading() {
        return this.getFontHeight(4) * 0.7;
    }

    double getBoxSpace() {
        return Math.ceil(this.getFontHeight(4) * 1.2);
    }

    private double getBox() {
        return this.getFontHeight(4) * 0.9;
    }

    double[] xtr(long[] timestamps) {
        double[] timestampsDev = new double[2 * timestamps.length - 1];
        int i = 0;
        int j = 0;
        while (i < timestamps.length) {
            timestampsDev[j] = this.mapper.xtr(timestamps[i]);
            if (i < timestamps.length - 1) {
                timestampsDev[j + 1] = timestampsDev[j];
            }
            ++i;
            j += 2;
        }
        return timestampsDev;
    }

    double[] ytr(double[] values) {
        double[] valuesDev = new double[2 * values.length - 1];
        int i = 0;
        int j = 0;
        while (i < values.length) {
            valuesDev[j] = Double.isNaN(values[i]) ? Double.NaN : (double)this.mapper.ytr(values[i]);
            if (j > 0) {
                valuesDev[j - 1] = valuesDev[j];
            }
            ++i;
            j += 2;
        }
        return valuesDev;
    }

    public void render(Graphics g) {
        byte[] imageData = this.getRrdGraphInfo().getBytes();
        ImageIcon image = new ImageIcon(imageData);
        image.paintIcon(null, g, 0, 0);
    }
}

