/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.node;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringEscapeUtils;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.mate.api.EntityScopeProvider;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsMetaData;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.Match;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.providers.SearchResultItemBuilder;

public class NodeMetaDataSearchProvider
implements SearchProvider {
    private final NodeDao nodeDao;
    private final EntityScopeProvider entityScopeProvider;

    public NodeMetaDataSearchProvider(NodeDao nodeDao, EntityScopeProvider entityScopeProvider) {
        this.nodeDao = Objects.requireNonNull(nodeDao);
        this.entityScopeProvider = Objects.requireNonNull(entityScopeProvider);
    }

    public SearchContext getContext() {
        return Contexts.Node;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        CriteriaBuilder criteriaBuilder = new CriteriaBuilder(OnmsNode.class).sql("{alias}.nodeid IN (SELECT m.id FROM node_metadata m WHERE m.key !~ '.*([pP]assword|[sS]ecret).*' AND m.value LIKE '%" + StringEscapeUtils.escapeSql((String)input) + "%')").distinct();
        int totalCount = this.nodeDao.countMatching(criteriaBuilder.toCriteria());
        Criteria criteria = criteriaBuilder.orderBy("label").distinct().limit(Integer.valueOf(query.getMaxResults())).toCriteria();
        List matchingNodes = this.nodeDao.findMatching(criteria);
        List searchResultItems = matchingNodes.stream().map(node -> {
            SearchResultItem searchResultItem = new SearchResultItemBuilder().withOnmsNode((OnmsNode)node, this.entityScopeProvider).build();
            for (OnmsMetaData onmsMetaData : node.getMetaData()) {
                if (onmsMetaData.getValue() == null || onmsMetaData.getKey().matches(".*([pP]assword|[sS]ecret).*") || !onmsMetaData.getValue().contains(input)) continue;
                searchResultItem.addMatch(new Match(onmsMetaData.getContext() + ":" + onmsMetaData.getKey(), "Meta-Data '" + onmsMetaData.getContext() + ":" + onmsMetaData.getKey() + "'", onmsMetaData.getValue()));
                break;
            }
            searchResultItem.setWeight(100);
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Node).withMore(totalCount > searchResultItems.size()).withResults(searchResultItems);
        return searchResult;
    }
}

