/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.search.providers.action;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.search.api.Contexts;
import org.opennms.netmgt.search.api.QueryUtils;
import org.opennms.netmgt.search.api.SearchContext;
import org.opennms.netmgt.search.api.SearchProvider;
import org.opennms.netmgt.search.api.SearchQuery;
import org.opennms.netmgt.search.api.SearchResult;
import org.opennms.netmgt.search.api.SearchResultItem;
import org.opennms.netmgt.search.api.UrlUtils;

public class CategorySearchProvider
implements SearchProvider {
    private final CategoryDao categoryDao;

    public CategorySearchProvider(CategoryDao categoryDao) {
        this.categoryDao = Objects.requireNonNull(categoryDao);
    }

    public SearchContext getContext() {
        return Contexts.Action;
    }

    public SearchResult query(SearchQuery query) {
        String input = query.getInput();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsCategory.class).ilike("name", QueryUtils.ilike((String)input)).orderBy("name").distinct();
        int totalCount = this.categoryDao.countMatching(builder.toCriteria());
        Criteria criteria = builder.limit(Integer.valueOf(query.getMaxResults())).toCriteria();
        List matchingResult = this.categoryDao.findMatching(criteria);
        List searchResultItems = matchingResult.stream().map(category -> {
            SearchResultItem searchResultItem = new SearchResultItem();
            searchResultItem.setIdentifier(category.getId().toString());
            searchResultItem.setLabel("Show nodes in category '" + category.getName() + "'");
            searchResultItem.setUrl("element/nodeList.htm?category1=" + UrlUtils.encode((String)category.getName()));
            return searchResultItem;
        }).collect(Collectors.toList());
        SearchResult searchResult = new SearchResult(Contexts.Action).withMore(totalCount > searchResultItems.size()).withResults(searchResultItems);
        return searchResult;
    }
}

