/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.enlinkd.snmp;

import java.net.InetAddress;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.enlinkd.model.OspfLink;
import org.opennms.netmgt.snmp.RowCallback;
import org.opennms.netmgt.snmp.SnmpInstId;
import org.opennms.netmgt.snmp.SnmpObjId;
import org.opennms.netmgt.snmp.SnmpRowResult;
import org.opennms.netmgt.snmp.TableTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OspfNbrTableTracker
extends TableTracker {
    private static final Logger LOG = LoggerFactory.getLogger(OspfNbrTableTracker.class);
    public static final SnmpObjId OSPF_NBR_IPADDRESS_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.10.1.1");
    public static final SnmpObjId OSPF_NBR_ADDRESS_LESS_INDEX_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.10.1.2");
    public static final SnmpObjId OSPF_NBR_ROUTERID_OID = SnmpObjId.get((String)".1.3.6.1.2.1.14.10.1.3");
    public static final String OSPF_NBR_IPADDRESS = "ospfNbrIpAddr";
    public static final String OSPF_NBR_ADDRESS_LESS_INDEX = "ospfNbrAddressLessIndex";
    public static final String OSPF_NBR_ROUTERID = "ospfNbrRtrId";
    public static final SnmpObjId[] s_ospfnbrtable_elemList = new SnmpObjId[]{OSPF_NBR_IPADDRESS_OID, OSPF_NBR_ADDRESS_LESS_INDEX_OID, OSPF_NBR_ROUTERID_OID};

    public OspfNbrTableTracker() {
        super(s_ospfnbrtable_elemList);
    }

    public OspfNbrTableTracker(RowCallback rowProcessor) {
        super(rowProcessor, s_ospfnbrtable_elemList);
    }

    public SnmpRowResult createRowResult(int columnCount, SnmpInstId instance) {
        return new OspfNbrRow(columnCount, instance);
    }

    public void rowCompleted(SnmpRowResult row) {
        this.processOspfNbrRow((OspfNbrRow)row);
    }

    public void processOspfNbrRow(OspfNbrRow row) {
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_NBR_IPADDRESS_OID) + "." + row.getInstance().toString(), OSPF_NBR_IPADDRESS, InetAddressUtils.str((InetAddress)row.getOspfNbrIpAddress()));
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_NBR_ADDRESS_LESS_INDEX_OID) + "." + row.getInstance().toString(), OSPF_NBR_ADDRESS_LESS_INDEX, row.getOspfNbrAddressLessIndex());
        System.out.printf("\t\t%s (%s)= %s \n", String.valueOf(OSPF_NBR_ROUTERID_OID) + "." + row.getInstance().toString(), OSPF_NBR_ROUTERID, InetAddressUtils.str((InetAddress)row.getOspfNbrRouterId()));
    }

    public static class OspfNbrRow
    extends SnmpRowResult {
        public OspfNbrRow(int columnCount, SnmpInstId instance) {
            super(columnCount, instance);
        }

        public InetAddress getOspfNbrIpAddress() {
            return this.getValue(OSPF_NBR_IPADDRESS_OID).toInetAddress();
        }

        public InetAddress getOspfNbrRouterId() {
            return this.getValue(OSPF_NBR_ROUTERID_OID).toInetAddress();
        }

        public Integer getOspfNbrAddressLessIndex() {
            return this.getValue(OSPF_NBR_ADDRESS_LESS_INDEX_OID).toInt();
        }

        public OspfLink getOspfLink() {
            LOG.debug("getOspfLink: row count: {}", (Object)this.getColumnCount());
            OspfLink link = new OspfLink();
            LOG.debug("getOspfLink: nbr router id: {}, nbr ip address {}, nbr address less ifindex {}", new Object[]{InetAddressUtils.str((InetAddress)this.getOspfNbrRouterId()), InetAddressUtils.str((InetAddress)this.getOspfNbrIpAddress()), this.getOspfNbrAddressLessIndex()});
            link.setOspfRemRouterId(this.getOspfNbrRouterId());
            link.setOspfRemIpAddr(this.getOspfNbrIpAddress());
            link.setOspfRemAddressLessIndex(this.getOspfNbrAddressLessIndex());
            return link;
        }
    }
}

