/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.support;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.opennms.core.logging.Logging;
import org.opennms.core.utils.FuzzyDateFormatter;
import org.opennms.netmgt.vmmgr.ControllerUtils;
import org.opennms.upgrade.api.Ignore;
import org.opennms.upgrade.api.OnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeComparator;
import org.opennms.upgrade.api.OnmsUpgradeException;
import org.opennms.upgrade.support.UpgradeStatus;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class Upgrade {
    private String classScope = "org.opennms.upgrade";
    private UpgradeStatus upgradeStatus;

    public UpgradeStatus getUpgradeStatus() throws OnmsUpgradeException {
        if (this.upgradeStatus == null) {
            this.upgradeStatus = new UpgradeStatus();
        }
        return this.upgradeStatus;
    }

    public void setUpgradeStatus(UpgradeStatus upgradeStatus) {
        this.upgradeStatus = upgradeStatus;
    }

    public String getClassScope() {
        return this.classScope;
    }

    public void setClassScope(String classScope) {
        this.classScope = classScope;
    }

    protected boolean isOpennmsRunning() {
        try {
            return ControllerUtils.getController().status() == 0;
        }
        catch (Exception e) {
            this.log("Warning: can't retrieve OpeNNMS status (assuming it is not running).\n", new Object[0]);
            return false;
        }
    }

    protected boolean wasExecuted(OnmsUpgrade upg) throws OnmsUpgradeException {
        return this.getUpgradeStatus().wasExecuted(upg);
    }

    protected void executeUpgrade(OnmsUpgrade upg) {
        Date start = new Date();
        try {
            if (this.wasExecuted(upg)) {
                this.log("  Task %s has been executed at %s\n", upg.getId(), this.getUpgradeStatus().getLastExecutionTime(upg));
                return;
            }
            this.log("- Running pre-execution phase\n", new Object[0]);
            upg.preExecute();
        }
        catch (OnmsUpgradeException e) {
            this.log("  Ignoring: %s\n", e.getMessage());
            return;
        }
        try {
            this.log("- Running execution phase\n", new Object[0]);
            upg.execute();
            if (upg.runOnlyOnce()) {
                this.log("- Saving the execution state\n", new Object[0]);
                this.markAsExecuted(upg);
            } else {
                this.log("- Ignore the execution status, as this task is executed with every call\n", new Object[0]);
            }
        }
        catch (OnmsUpgradeException executeException) {
            this.log("  Warning: can't perform the upgrade operation because: %s\n", executeException.getMessage());
            try {
                this.log("- Executing rollback phase\n", new Object[0]);
                upg.rollback();
            }
            catch (OnmsUpgradeException rollbackException) {
                this.log("  Warning: can't rollback the upgrade because: %s\n", rollbackException.getMessage());
                rollbackException.printStackTrace();
            }
        }
        try {
            this.log("- Running post-execution phase\n", new Object[0]);
            upg.postExecute();
        }
        catch (OnmsUpgradeException e) {
            this.log("  Warning: can't run the post-execute phase because: %s\n", e.getMessage());
        }
        this.log("\nFinished in %s\n\n", FuzzyDateFormatter.calculateDifference((Date)start, (Date)new Date()));
    }

    protected void markAsExecuted(OnmsUpgrade upg) throws OnmsUpgradeException {
        this.getUpgradeStatus().markAsExecuted(upg);
    }

    protected void log(String msgFormat, Object ... args) {
        System.out.printf(msgFormat, args);
    }

    protected List<OnmsUpgrade> getUpgradeObjects() throws OnmsUpgradeException {
        ArrayList<OnmsUpgrade> upgrades = new ArrayList<OnmsUpgrade>();
        try {
            ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(true);
            provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(OnmsUpgrade.class));
            Set components = provider.findCandidateComponents(this.getClassScope());
            for (BeanDefinition component : components) {
                Class<?> cls;
                if (component.isAbstract() || (cls = Class.forName(component.getBeanClassName())).getAnnotation(Ignore.class) != null) continue;
                OnmsUpgrade upgrade = (OnmsUpgrade)cls.newInstance();
                upgrades.add(upgrade);
                this.log("Found upgrade task %s\n", upgrade.getId());
            }
            Collections.sort(upgrades, new OnmsUpgradeComparator());
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("  Can't find the upgrade classes because: " + e.getMessage(), e);
        }
        return upgrades;
    }

    public void execute() throws OnmsUpgradeException {
        Map mdc = Logging.getCopyOfContextMap();
        Logging.putPrefix((String)"upgrade");
        this.log("\n==============================================================================\n", new Object[0]);
        this.log("OpenNMS Upgrader", new Object[0]);
        this.log("\n==============================================================================\n\n", new Object[0]);
        this.log("OpenNMS is currently %s\n", this.isOpennmsRunning() ? "running" : "stopped");
        List<OnmsUpgrade> upgradeObjects = this.getUpgradeObjects();
        for (OnmsUpgrade upg : upgradeObjects) {
            this.log("Processing %s: %s\n", upg.getId(), upg.getDescription());
            if (this.isOpennmsRunning()) {
                if (upg.requiresOnmsRunning()) {
                    this.executeUpgrade(upg);
                    continue;
                }
                this.log("  Task %s requires that OpenNMS is stopped but it is running (ignoring)\n", upg.getId());
                continue;
            }
            if (upg.requiresOnmsRunning()) {
                this.log("  Task %s requires OpenNMS is running but it is stopped (ignoring)\n", upg.getId());
                continue;
            }
            this.executeUpgrade(upg);
        }
        this.log("\n*** Thanks for using OpenNMS!\n", new Object[0]);
        this.log("***\n", new Object[0]);
        this.log("*** Consider joining our active and supportive online community through\n", new Object[0]);
        this.log("***\n", new Object[0]);
        this.log("*** https://www.opennms.com/participate/\n", new Object[0]);
        this.log("***\n", new Object[0]);
        this.log("*** To connect with users, testers, experts, and contributors.\n", new Object[0]);
        this.log("***\n", new Object[0]);
        this.log("*** Or email us directly at contactus@opennms.com to learn more.\n", new Object[0]);
        this.log("\nUpgrade completed successfully!\n", new Object[0]);
        Logging.setContextMap((Map)mdc);
    }

    public static void main(String[] args) throws OnmsUpgradeException {
        new Upgrade().execute();
    }
}

