/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class VmwareAssetsMigratorOffline
extends AbstractOnmsUpgrade {
    private static final int BATCH_SIZE = 2000;

    @Override
    public int getOrder() {
        return 9;
    }

    @Override
    public String getDescription() {
        return "Moves VMware asset data to the node's metadata.";
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        try (Connection connection = DataSourceFactory.getInstance().getConnection();){
            Statement preExecutionStatement = connection.createStatement();
            try (ResultSet preExecutionResultSet = preExecutionStatement.executeQuery("SELECT EXISTS (SELECT 1 FROM pg_attribute WHERE attrelid = (SELECT oid FROM pg_class WHERE relname = 'assets') AND attname = 'vmwaretopologyinfo')");){
                preExecutionResultSet.next();
                if (!preExecutionResultSet.getBoolean(1)) {
                    throw new OnmsUpgradeException("The 'vmwaretopologyinfo' columns do not exist anymore");
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new OnmsUpgradeException("Error checking for column 'vmwaretopologyinfo'", e);
            }
        }
        catch (SQLException e) {
            throw new OnmsUpgradeException("Error opening database connection", e);
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        long nodeCount = 0L;
        try (Connection connection = DataSourceFactory.getInstance().getConnection();){
            connection.setAutoCommit(false);
            while (true) {
                Statement selectStatement = connection.createStatement();
                try {
                    ResultSet resultSet = selectStatement.executeQuery("SELECT nodeid, vmwaremanagedobjectid, vmwaremanagedentitytype, vmwaremanagementserver, vmwaretopologyinfo, vmwarestate FROM assets WHERE vmwaremanagementserver IS NOT NULL LIMIT 2000");
                    try {
                        if (!resultSet.next()) break;
                        try {
                            PreparedStatement insertStatement = connection.prepareStatement("INSERT INTO node_metadata (id, context, key, value) VALUES  (?,?,?,?)");
                            try {
                                PreparedStatement nullifyStatement = connection.prepareStatement("UPDATE assets SET vmwaremanagedobjectid=NULL, vmwaremanagedentitytype=NULL, vmwaremanagementserver=NULL, vmwaretopologyinfo=NULL, vmwarestate=NULL WHERE nodeid=?");
                                try {
                                    do {
                                        Integer nodeId = resultSet.getInt("nodeid");
                                        String vmwareManagedObjectId = resultSet.getString("vmwaremanagedobjectid");
                                        String vmwareManagedentityType = resultSet.getString("vmwaremanagedentitytype");
                                        String vmwareManagementServer = resultSet.getString("vmwaremanagementserver");
                                        String vmwareTopologyInfo = resultSet.getString("vmwaretopologyinfo");
                                        String vmwareState = resultSet.getString("vmwarestate");
                                        insertStatement.setInt(1, nodeId);
                                        insertStatement.setString(2, "VMware");
                                        insertStatement.setString(3, "managedObjectId");
                                        insertStatement.setString(4, vmwareManagedObjectId);
                                        insertStatement.execute();
                                        insertStatement.setInt(1, nodeId);
                                        insertStatement.setString(2, "VMware");
                                        insertStatement.setString(3, "managedEntityType");
                                        insertStatement.setString(4, vmwareManagedentityType);
                                        insertStatement.execute();
                                        insertStatement.setInt(1, nodeId);
                                        insertStatement.setString(2, "VMware");
                                        insertStatement.setString(3, "managementServer");
                                        insertStatement.setString(4, vmwareManagementServer);
                                        insertStatement.execute();
                                        insertStatement.setInt(1, nodeId);
                                        insertStatement.setString(2, "VMware");
                                        insertStatement.setString(3, "topologyInfo");
                                        insertStatement.setString(4, vmwareTopologyInfo);
                                        insertStatement.execute();
                                        insertStatement.setInt(1, nodeId);
                                        insertStatement.setString(2, "VMware");
                                        insertStatement.setString(3, "state");
                                        insertStatement.setString(4, vmwareState);
                                        insertStatement.execute();
                                        nullifyStatement.setInt(1, nodeId);
                                        nullifyStatement.execute();
                                        ++nodeCount;
                                    } while (resultSet.next());
                                    this.log("Processed %d node entries, %d metadata entries inserted...\n", nodeCount, nodeCount * 5L);
                                    connection.commit();
                                    continue;
                                }
                                finally {
                                    if (nullifyStatement == null) continue;
                                    nullifyStatement.close();
                                    continue;
                                }
                            }
                            finally {
                                if (insertStatement == null) continue;
                                insertStatement.close();
                                continue;
                            }
                        }
                        catch (SQLException e) {
                            connection.rollback();
                            connection.setAutoCommit(true);
                            throw e;
                        }
                    }
                    finally {
                        if (resultSet == null) continue;
                        resultSet.close();
                        continue;
                    }
                }
                finally {
                    if (selectStatement == null) continue;
                    selectStatement.close();
                    continue;
                }
                break;
            }
            connection.setAutoCommit(true);
            this.log("Rows migrated. Dropping VMware asset columns...\n", new Object[0]);
            Statement postMigrationStatement = connection.createStatement();
            postMigrationStatement.execute("ALTER TABLE assets DROP COLUMN vmwaremanagedobjectid");
            postMigrationStatement.execute("ALTER TABLE assets DROP COLUMN vmwaremanagedentitytype");
            postMigrationStatement.execute("ALTER TABLE assets DROP COLUMN vmwaremanagementserver");
            postMigrationStatement.execute("ALTER TABLE assets DROP COLUMN vmwaretopologyinfo");
            postMigrationStatement.execute("ALTER TABLE assets DROP COLUMN vmwarestate");
        }
        catch (Throwable e) {
            throw new OnmsUpgradeException("Can't move asset data to metadata table: " + e.getMessage(), e);
        }
    }
}

