/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang.StringUtils;
import org.opennms.core.utils.RrdLabelUtils;
import org.opennms.netmgt.model.ResourceId;

public class SnmpInterface {
    private int nodeId;
    private String foreignId;
    private String foreignSource;
    private String ifName;
    private String ifDescr;
    private String physAddr;
    private String oldRrdLabel;
    private String newRrdLabel;
    private boolean storeByForeignSource;

    public SnmpInterface(ResultSet rs, boolean storeByForeignSource) throws SQLException {
        this(rs.getInt("nodeid"), rs.getString("foreignsource"), rs.getString("foreignid"), rs.getString("snmpifdescr"), rs.getString("snmpifname"), rs.getString("snmpphysaddr"), storeByForeignSource);
    }

    public SnmpInterface(int nodeId, String foreignSource, String foreignId, String ifDescr, String ifName, String physAddr, boolean storeByForeignSource) {
        this.nodeId = nodeId;
        this.foreignSource = this.normalize(foreignSource);
        this.foreignId = this.normalize(foreignId);
        this.ifDescr = this.normalize(ifDescr);
        this.ifName = this.normalize(ifName);
        this.physAddr = this.normalize(physAddr);
        this.storeByForeignSource = storeByForeignSource;
        this.initialize();
    }

    private String normalize(String source) {
        return StringUtils.isBlank((String)source) ? null : StringUtils.trim((String)source);
    }

    protected void initialize() {
        if (this.ifDescr == null && this.ifName == null) {
            this.ifName = "null";
        }
        this.oldRrdLabel = RrdLabelUtils.computeLabelForRRD((String)this.ifName, (String)this.ifDescr, null);
        this.newRrdLabel = RrdLabelUtils.computeLabelForRRD((String)this.ifName, (String)this.ifDescr, (String)this.physAddr);
    }

    public int getNodeId() {
        return this.nodeId;
    }

    public String getForeignId() {
        return this.foreignId;
    }

    public String getForeignSource() {
        return this.foreignSource;
    }

    public String getIfName() {
        return this.ifName;
    }

    public String getIfDescr() {
        return this.ifDescr;
    }

    public String getPhysAddr() {
        return this.physAddr;
    }

    public String getOldRrdLabel() {
        return this.oldRrdLabel;
    }

    public String getNewRrdLabel() {
        return this.newRrdLabel;
    }

    public ResourceId getOldResourceId() {
        return this.getResourceId(this.oldRrdLabel);
    }

    public ResourceId getNewResourceId() {
        return this.getResourceId(this.newRrdLabel);
    }

    private ResourceId getResourceId(String label) {
        String parentType = this.storeByForeignSource ? "nodeSource" : "node";
        String parentId = this.storeByForeignSource ? this.foreignSource + ":" + this.foreignId : Integer.toString(this.nodeId);
        return ResourceId.get((String)parentType, (String)parentId).resolve("interfaceSnmp", label);
    }

    public boolean shouldUpdate(String resourceId) {
        return resourceId.endsWith("interfaceSnmp[" + this.oldRrdLabel + "]");
    }

    public String toString() {
        return "Interface[ifName=" + this.getIfName() + ", nodeId=" + this.getNodeId() + ", foreignSource=" + this.getForeignSource() + ", foreignId=" + this.getForeignId() + "]";
    }
}

