/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.upgrade.implementations;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.opennms.core.utils.ConfigFileConstants;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.config.service.Attribute;
import org.opennms.netmgt.config.service.Invoke;
import org.opennms.netmgt.config.service.InvokeAtType;
import org.opennms.netmgt.config.service.Service;
import org.opennms.netmgt.config.service.ServiceConfiguration;
import org.opennms.upgrade.api.AbstractOnmsUpgrade;
import org.opennms.upgrade.api.OnmsUpgradeException;

public class RemotePollerServiceConfigMigratorOffline
extends AbstractOnmsUpgrade {
    private File configFile;
    public static final String DEPRECATED_REMOTE_POLLER_SERVICENAME = "OpenNMS:Name=PollerBackEnd";
    public static final String PERSPECTIVE_POLLER_SERVICENAME = "OpenNMS:Name=PerspectivePoller";

    public RemotePollerServiceConfigMigratorOffline() throws OnmsUpgradeException {
        try {
            this.configFile = ConfigFileConstants.getFile((int)ConfigFileConstants.SERVICE_CONF_FILE_NAME);
        }
        catch (IOException e) {
            throw new OnmsUpgradeException("Can't find Services Configuration file", e);
        }
    }

    @Override
    public int getOrder() {
        return 14;
    }

    @Override
    public String getDescription() {
        return "Remove deprecated RemotePoller service entry from service-configuration.xml, see NMS-12684";
    }

    @Override
    public void preExecute() throws OnmsUpgradeException {
        try {
            this.log("Creating backup of %s\n", this.configFile);
            this.zipFile(this.configFile);
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't backup service-configurations.xml because " + e.getMessage());
        }
    }

    @Override
    public void postExecute() throws OnmsUpgradeException {
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        if (zip.exists()) {
            this.log("Removing backup %s\n", zip);
            FileUtils.deleteQuietly((File)zip);
        }
    }

    @Override
    public void rollback() throws OnmsUpgradeException {
        this.log("Restoring backup %s\n", this.configFile);
        File zip = new File(this.configFile.getAbsolutePath() + ".zip");
        FileUtils.deleteQuietly((File)this.configFile);
        this.unzipFile(zip, zip.getParentFile());
    }

    @Override
    public void execute() throws OnmsUpgradeException {
        try {
            ServiceConfiguration currentCfg = (ServiceConfiguration)JaxbUtils.unmarshal(ServiceConfiguration.class, (File)this.configFile);
            boolean skipRemovePollerNgEntryCreation = false;
            boolean deprecatedServiceEnabled = true;
            this.log("Current configuration: " + currentCfg.getServices().size() + " services.\n", new Object[0]);
            for (int i = currentCfg.getServices().size() - 1; i >= 0; --i) {
                Service localSvc = (Service)currentCfg.getServices().get(i);
                String name = localSvc.getName();
                if (DEPRECATED_REMOTE_POLLER_SERVICENAME.equals(name)) {
                    deprecatedServiceEnabled = localSvc.isEnabled();
                    currentCfg.getServices().remove(i);
                    this.log("Removing deprecated '%s' entry\n", DEPRECATED_REMOTE_POLLER_SERVICENAME);
                }
                if (!PERSPECTIVE_POLLER_SERVICENAME.equals(name)) continue;
                skipRemovePollerNgEntryCreation = true;
            }
            if (skipRemovePollerNgEntryCreation) {
                this.log("A service entry named '%s' already exists.\n", PERSPECTIVE_POLLER_SERVICENAME);
            } else {
                Service service = new Service();
                service.setEnabled(Boolean.valueOf(deprecatedServiceEnabled));
                service.setName(PERSPECTIVE_POLLER_SERVICENAME);
                service.setClassName("org.opennms.netmgt.daemon.SimpleSpringContextJmxServiceDaemon");
                service.getAttributes().add(new Attribute("LoggingPrefix", "java.lang.String", "perspectivepollerd"));
                service.getAttributes().add(new Attribute("SpringContext", "java.lang.String", "perspectivepollerdContext"));
                service.setInvokes((List)Lists.newArrayList((Object[])new Invoke[]{new Invoke(InvokeAtType.START, Integer.valueOf(0), "init", Collections.emptyList()), new Invoke(InvokeAtType.START, Integer.valueOf(1), "start", Collections.emptyList()), new Invoke(InvokeAtType.STATUS, Integer.valueOf(0), "status", Collections.emptyList()), new Invoke(InvokeAtType.STOP, Integer.valueOf(0), "stop", Collections.emptyList())}));
                this.log("Adding new 'OpenNMS:Name=PerspectivePoller' entry\n", new Object[0]);
                currentCfg.addService(service);
            }
            this.log("Final configuration: " + currentCfg.getServices().size() + " services.\n", new Object[0]);
            StringWriter sw = new StringWriter();
            sw.write("<?xml version=\"1.0\"?>\n");
            sw.write("<!-- NOTE!!!!!!!!!!!!!!!!!!!\n");
            sw.write("The order in which these services are specified is important - for example, Eventd\n");
            sw.write("will need to come up last so that none of the event topic subcribers loose any event.\n");
            sw.write("\nWhen splitting services to run on mutiple VMs, the order of the services should be\n");
            sw.write("maintained\n");
            sw.write("-->\n");
            JaxbUtils.marshal((Object)currentCfg, (Writer)sw);
            FileWriter fw = new FileWriter(this.configFile);
            fw.write(sw.toString());
            fw.close();
        }
        catch (Exception e) {
            throw new OnmsUpgradeException("Can't migrate service-configuration.xml because " + e.getMessage(), e);
        }
    }

    @Override
    public boolean requiresOnmsRunning() {
        return false;
    }
}

