/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows;

import com.google.common.base.MoreObjects;
import io.netty.buffer.ByteBuf;
import org.bson.BsonWriter;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.InvalidPacketException;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;

public enum Status {
    SUCCESS(0),
    OTHER(1),
    TIMEOUT(2),
    INTERNAL_ERROR(3),
    BAD_REQUEST(4),
    FORBIDDEN(5),
    TOO_LARGE(6),
    NOT_IMPLEMENTED(7),
    NOT_FOUND(8),
    UNAVAILABLE(9),
    UNAUTHORIZED(10);

    public final int value;

    private Status(int value) {
        this.value = value;
    }

    public static Status from(ByteBuf buffer) throws InvalidPacketException {
        int value = (int)BufferUtils.uint32((ByteBuf)buffer);
        switch (value) {
            case 0: {
                return SUCCESS;
            }
            case 1: {
                return OTHER;
            }
            case 2: {
                return TIMEOUT;
            }
            case 3: {
                return INTERNAL_ERROR;
            }
            case 4: {
                return BAD_REQUEST;
            }
            case 5: {
                return FORBIDDEN;
            }
            case 6: {
                return TOO_LARGE;
            }
            case 7: {
                return NOT_IMPLEMENTED;
            }
            case 8: {
                return NOT_FOUND;
            }
            case 9: {
                return UNAVAILABLE;
            }
            case 10: {
                return UNAUTHORIZED;
            }
        }
        throw new InvalidPacketException(buffer, "Unknown value: {}", value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)((Object)this)).add("value", this.value).toString();
    }

    public void writeBson(BsonWriter bsonWriter, SampleDatagramEnrichment enr) {
        bsonWriter.writeInt32(this.value);
    }
}

