/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.protocols.sflow.parser;

import java.net.InetSocketAddress;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.bson.BsonBinaryWriter;
import org.bson.BsonWriter;
import org.bson.ByteBuf;
import org.bson.io.BasicOutputBuffer;
import org.bson.io.BsonOutput;
import org.opennms.core.concurrent.LogPreservingThreadFactory;
import org.opennms.core.ipc.sink.api.AsyncDispatcher;
import org.opennms.core.ipc.sink.api.Message;
import org.opennms.netmgt.dnsresolver.api.DnsResolver;
import org.opennms.netmgt.telemetry.api.receiver.TelemetryMessage;
import org.opennms.netmgt.telemetry.listeners.Dispatchable;
import org.opennms.netmgt.telemetry.listeners.UdpParser;
import org.opennms.netmgt.telemetry.listeners.utils.BufferUtils;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnricher;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.SampleDatagramEnrichment;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.DatagramVersion;
import org.opennms.netmgt.telemetry.protocols.sflow.parser.proto.flows.SampleDatagram;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SFlowUdpParser
implements UdpParser,
Dispatchable {
    private static final Logger LOG = LoggerFactory.getLogger(SFlowUdpParser.class);
    private static final int DEFAULT_NUM_THREADS = Runtime.getRuntime().availableProcessors() * 2;
    private final ThreadLocal<Boolean> isParserThread = new ThreadLocal();
    private final ThreadFactory threadFactory;
    private final String name;
    private final AsyncDispatcher<TelemetryMessage> dispatcher;
    private SampleDatagramEnricher enricher;
    private int threads = DEFAULT_NUM_THREADS;
    private boolean dnsLookupsEnabled = true;
    private ExecutorService executor;
    private final DnsResolver dnsResolver;

    public SFlowUdpParser(String name, AsyncDispatcher<TelemetryMessage> dispatcher, DnsResolver dnsResolver) {
        this.name = Objects.requireNonNull(name);
        this.dispatcher = Objects.requireNonNull(dispatcher);
        this.dnsResolver = Objects.requireNonNull(dnsResolver);
        final LogPreservingThreadFactory logPreservingThreadFactory = new LogPreservingThreadFactory("Telemetryd-sFlow-" + name, Integer.MAX_VALUE);
        this.threadFactory = new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return logPreservingThreadFactory.newThread(() -> {
                    SFlowUdpParser.this.isParserThread.set(true);
                    r.run();
                });
            }
        };
    }

    public boolean handles(io.netty.buffer.ByteBuf buffer) {
        return BufferUtils.uint32((io.netty.buffer.ByteBuf)buffer) == (long)DatagramVersion.VERSION5.value;
    }

    public CompletableFuture<?> parse(io.netty.buffer.ByteBuf buffer, InetSocketAddress remoteAddress, InetSocketAddress localAddress) throws Exception {
        SampleDatagram packet = new SampleDatagram(buffer);
        LOG.trace("Got packet: {}", (Object)packet);
        CompletableFuture future = new CompletableFuture();
        this.executor.execute(() -> this.enricher.enrich(packet).whenComplete((enrichment, ex) -> {
            if (ex != null) {
                future.completeExceptionally((Throwable)ex);
                return;
            }
            Runnable dispatch = () -> {
                BasicOutputBuffer output = new BasicOutputBuffer();
                try (BsonBinaryWriter bsonWriter = new BsonBinaryWriter((BsonOutput)output);){
                    bsonWriter.writeStartDocument();
                    bsonWriter.writeName("time");
                    bsonWriter.writeInt64(System.currentTimeMillis());
                    bsonWriter.writeName("data");
                    packet.version.datagram.writeBson((BsonWriter)bsonWriter, (SampleDatagramEnrichment)enrichment);
                    bsonWriter.writeEndDocument();
                }
                TelemetryMessage msg = new TelemetryMessage(remoteAddress, ((ByteBuf)output.getByteBuffers().get(0)).asNIO());
                this.dispatcher.send((Message)msg).whenComplete((any, exx) -> {
                    if (exx != null) {
                        future.completeExceptionally((Throwable)exx);
                    }
                    future.complete(any);
                });
            };
            if (Boolean.TRUE.equals(this.isParserThread.get())) {
                dispatch.run();
            } else {
                this.executor.execute(dispatch);
            }
        }));
        return future;
    }

    public boolean getDnsLookupsEnabled() {
        return this.dnsLookupsEnabled;
    }

    public void setDnsLookupsEnabled(boolean dnsLookupsEnabled) {
        this.dnsLookupsEnabled = dnsLookupsEnabled;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return "SFlow";
    }

    public Object dumpInternalState() {
        return null;
    }

    public void start(ScheduledExecutorService executorService) {
        this.executor = new ThreadPoolExecutor(1, this.threads, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), this.threadFactory, (r, executor) -> {
            try {
                if (!executor.isShutdown()) {
                    executor.getQueue().put(r);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RejectedExecutionException("Executor interrupted while waiting for capacity in the work queue.", e);
            }
        });
        this.enricher = new SampleDatagramEnricher(this.dnsResolver, this.getDnsLookupsEnabled());
    }

    public void stop() {
        this.executor.shutdown();
    }

    public int getThreads() {
        return this.threads;
    }

    public void setThreads(int threads) {
        if (threads < 1) {
            throw new IllegalArgumentException("Threads must be >= 1");
        }
        this.threads = threads;
    }

    SampleDatagramEnricher getEnricher() {
        return this.enricher;
    }
}

