/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.graph.provider.bsm;

import org.opennms.netmgt.bsm.service.model.Status;
import org.opennms.netmgt.bsm.service.model.functions.map.MapFunction;
import org.opennms.netmgt.bsm.service.model.graph.GraphEdge;
import org.opennms.netmgt.graph.api.generic.GenericEdge;
import org.opennms.netmgt.graph.api.info.Severity;
import org.opennms.netmgt.graph.domain.AbstractDomainEdge;
import org.opennms.netmgt.graph.provider.bsm.BusinessServiceVertex;

public final class BusinessServiceEdge
extends AbstractDomainEdge {
    public BusinessServiceEdge(GenericEdge genericEdge) {
        super(genericEdge);
    }

    public MapFunction getMapFunction() {
        return (MapFunction)this.delegate.getProperty("mapFunction");
    }

    public float getWeight() {
        return ((Float)this.delegate.getProperty("weight")).floatValue();
    }

    public static final BusinessServiceEdgeBuilder builder() {
        return new BusinessServiceEdgeBuilder();
    }

    public static BusinessServiceEdge from(GenericEdge genericEdge) {
        return new BusinessServiceEdge(genericEdge);
    }

    static interface Properties {
        public static final String MAP_FUNCTION = "mapFunction";
        public static final String WEIGHT = "weight";
    }

    public static final class BusinessServiceEdgeBuilder
    extends AbstractDomainEdge.AbstractDomainEdgeBuilder<BusinessServiceEdgeBuilder> {
        private BusinessServiceEdgeBuilder() {
        }

        BusinessServiceEdgeBuilder graphEdge(GraphEdge graphEdge) {
            this.mapFunction(graphEdge.getMapFunction());
            this.weight(graphEdge.getWeight());
            this.status(graphEdge.getStatus());
            return this;
        }

        BusinessServiceEdgeBuilder weight(float weight) {
            this.property("weight", Float.valueOf(weight));
            return this;
        }

        BusinessServiceEdgeBuilder mapFunction(MapFunction mapFunction) {
            this.property("mapFunction", mapFunction);
            return this;
        }

        BusinessServiceEdgeBuilder status(Status status) {
            Severity severity = BusinessServiceVertex.convert(status);
            this.property("status", severity);
            return this;
        }

        public BusinessServiceEdge build() {
            return new BusinessServiceEdge(((GenericEdge.GenericEdgeBuilder)((GenericEdge.GenericEdgeBuilder)GenericEdge.builder().namespace("bsm")).properties(this.properties)).source(this.source).target(this.target).build());
        }
    }
}

