/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.coordinator.group.runtime;

import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.coordinator.group.runtime.CoordinatorPlayback;

public interface CoordinatorLoader<U>
extends AutoCloseable {
    public CompletableFuture<Void> load(TopicPartition var1, CoordinatorPlayback<U> var2);

    public static interface Deserializer<T> {
        public T deserialize(ByteBuffer var1, ByteBuffer var2) throws RuntimeException;
    }

    public static class UnknownRecordTypeException
    extends RuntimeException {
        private final short unknownType;

        public UnknownRecordTypeException(short unknownType) {
            super(String.format("Found an unknown record type %d", unknownType));
            this.unknownType = unknownType;
        }

        public short unknownType() {
            return this.unknownType;
        }
    }
}

