/*
 * Decompiled with CFR 0.152.
 */
package org.jolokia.osgi.security;

import javax.management.ObjectName;
import org.jolokia.restrictor.Restrictor;
import org.jolokia.util.HttpMethod;
import org.jolokia.util.RequestType;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class DelegatingRestrictor
implements Restrictor {
    private BundleContext bundleContext;
    private static final RestrictorCheck HTTP_METHOD_CHECK = new RestrictorCheck(){

        @Override
        public boolean check(Restrictor restrictor, Object ... args) {
            return restrictor.isHttpMethodAllowed((HttpMethod)((Object)args[0]));
        }
    };
    private static final RestrictorCheck TYPE_CHECK = new RestrictorCheck(){

        @Override
        public boolean check(Restrictor restrictor, Object ... args) {
            return restrictor.isTypeAllowed((RequestType)((Object)args[0]));
        }
    };
    private static final RestrictorCheck ATTRIBUTE_READ_CHECK = new RestrictorCheck(){

        @Override
        public boolean check(Restrictor restrictor, Object ... args) {
            return restrictor.isAttributeReadAllowed((ObjectName)args[0], (String)args[1]);
        }
    };
    private static final RestrictorCheck ATTRIBUTE_WRITE_CHECK = new RestrictorCheck(){

        @Override
        public boolean check(Restrictor restrictor, Object ... args) {
            return restrictor.isAttributeWriteAllowed((ObjectName)args[0], (String)args[1]);
        }
    };
    private static final RestrictorCheck OPERATION_CHECK = new RestrictorCheck(){

        @Override
        public boolean check(Restrictor restrictor, Object ... args) {
            return restrictor.isOperationAllowed((ObjectName)args[0], (String)args[1]);
        }
    };
    private static final RestrictorCheck REMOTE_CHECK = new RestrictorCheck(){

        @Override
        public boolean check(Restrictor restrictor, Object ... args) {
            String[] argsS = new String[args.length];
            for (int i = 0; i < args.length; ++i) {
                argsS[i] = (String)args[i];
            }
            return restrictor.isRemoteAccessAllowed(argsS);
        }
    };
    private static final RestrictorCheck CORS_CHECK = new RestrictorCheck(){

        @Override
        public boolean check(Restrictor restrictor, Object ... args) {
            return restrictor.isOriginAllowed((String)args[0], (Boolean)args[1]);
        }
    };

    public DelegatingRestrictor(BundleContext pBundleContext) {
        this.bundleContext = pBundleContext;
    }

    private boolean checkRestrictorService(RestrictorCheck pCheck, Object ... args) {
        try {
            ServiceReference[] serviceRefs = this.bundleContext.getServiceReferences(Restrictor.class.getName(), null);
            if (serviceRefs != null) {
                boolean ret = true;
                boolean found = false;
                for (ServiceReference serviceRef : serviceRefs) {
                    Restrictor restrictor = (Restrictor)this.bundleContext.getService(serviceRef);
                    if (restrictor == null) continue;
                    ret = ret && pCheck.check(restrictor, args);
                    found = true;
                }
                return found && ret;
            }
            return false;
        }
        catch (InvalidSyntaxException e) {
            throw new IllegalArgumentException("Impossible exception (we don't use a filter for fetching the services)", e);
        }
    }

    @Override
    public boolean isHttpMethodAllowed(HttpMethod pMethod) {
        return this.checkRestrictorService(HTTP_METHOD_CHECK, new Object[]{pMethod});
    }

    @Override
    public boolean isTypeAllowed(RequestType pType) {
        return this.checkRestrictorService(TYPE_CHECK, new Object[]{pType});
    }

    @Override
    public boolean isAttributeReadAllowed(ObjectName pName, String pAttribute) {
        return this.checkRestrictorService(ATTRIBUTE_READ_CHECK, pName, pAttribute);
    }

    @Override
    public boolean isAttributeWriteAllowed(ObjectName pName, String pAttribute) {
        return this.checkRestrictorService(ATTRIBUTE_WRITE_CHECK, pName, pAttribute);
    }

    @Override
    public boolean isOperationAllowed(ObjectName pName, String pOperation) {
        return this.checkRestrictorService(OPERATION_CHECK, pName, pOperation);
    }

    @Override
    public boolean isRemoteAccessAllowed(String ... pHostOrAddress) {
        return this.checkRestrictorService(REMOTE_CHECK, pHostOrAddress);
    }

    @Override
    public boolean isOriginAllowed(String pOrigin, boolean pOnlyWhenStrictCheckingIsEnabled) {
        return this.checkRestrictorService(CORS_CHECK, pOrigin, pOnlyWhenStrictCheckingIsEnabled);
    }

    private static interface RestrictorCheck {
        public boolean check(Restrictor var1, Object ... var2);
    }
}

