/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.frame;

import io.pkts.buffer.Buffer;
import io.pkts.frame.Frame;
import io.pkts.frame.PcapGlobalHeader;
import io.pkts.framer.FramerManager;
import io.pkts.protocol.Protocol;
import java.io.IOException;
import java.io.ObjectInput;

public abstract class AbstractFrame
implements Frame {
    private final PcapGlobalHeader pcapGlobalHader;
    private final FramerManager framerManager;
    private final Protocol protocol;
    private final Buffer payload;
    private Frame nextFrame;

    public AbstractFrame(FramerManager framerManager, PcapGlobalHeader header, Protocol p, Buffer payload) {
        assert (framerManager != null);
        assert (p != null);
        this.pcapGlobalHader = header;
        this.framerManager = framerManager;
        this.protocol = p;
        this.payload = payload;
    }

    @Override
    public final boolean hasProtocol(Protocol p) throws IOException {
        return this.getFrame(p) != null;
    }

    @Override
    public final Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public final Frame getFrame(Protocol p) throws IOException {
        if (this.protocol == p) {
            return this;
        }
        Frame next = this.getNextFrame();
        if (next != null) {
            return next.getFrame(p);
        }
        return null;
    }

    @Override
    public final void frameAll() throws IOException {
    }

    @Override
    public final String getName() {
        return this.protocol.getName();
    }

    @Override
    public final Frame getNextFrame() throws IOException {
        if (this.nextFrame == null) {
            this.nextFrame = this.framePayload(this.framerManager, this.payload.slice());
        }
        return this.nextFrame;
    }

    @Override
    public final Buffer getPayload() {
        return this.payload;
    }

    @Override
    public PcapGlobalHeader getPcapGlobalHeader() {
        return this.pcapGlobalHader;
    }

    protected abstract Frame framePayload(FramerManager var1, Buffer var2) throws IOException;

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
    }
}

