/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.alarmd.northbounder.email;

import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.alarmd.api.NorthboundAlarm;
import org.opennms.netmgt.config.javamail.SendmailMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@XmlRootElement(name="email-filter")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class EmailFilter {
    private static final Logger LOG = LoggerFactory.getLogger(EmailFilter.class);
    @XmlAttribute(name="enabled", required=false)
    private Boolean m_enabled;
    @XmlAttribute(name="name", required=false)
    private String m_name;
    @XmlElement(name="rule", required=true)
    private String m_rule;
    @XmlElement(name="from", required=false)
    private String m_from;
    @XmlElement(name="to", required=false)
    private String m_to;
    @XmlElement(name="subject", required=false)
    private String m_subject;
    @XmlElement(name="body", required=false)
    private String m_body;

    public EmailFilter() {
    }

    public EmailFilter(String name, String rule) {
        this.m_name = name;
        this.m_rule = rule;
    }

    public Boolean isEnabled() {
        return this.m_enabled == null ? Boolean.TRUE : this.m_enabled;
    }

    public String getName() {
        return this.m_name;
    }

    public String getRule() {
        return this.m_rule;
    }

    public String getFrom() {
        return this.m_from;
    }

    public String getTo() {
        return this.m_to;
    }

    public String getSubject() {
        return this.m_subject;
    }

    public String getBody() {
        return this.m_body;
    }

    public void setEnabled(Boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setRule(String rule) {
        this.m_rule = rule;
    }

    public void setFrom(String from) {
        this.m_from = from;
    }

    public void setTo(String to) {
        this.m_to = to;
    }

    public void setSubject(String subject) {
        this.m_subject = subject;
    }

    public void setBody(String body) {
        this.m_body = body;
    }

    public boolean accepts(NorthboundAlarm alarm) {
        if (!this.isEnabled().booleanValue()) {
            return false;
        }
        StandardEvaluationContext context = new StandardEvaluationContext((Object)alarm);
        SpelExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(this.getRule());
        boolean passed = false;
        try {
            passed = (Boolean)exp.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception e) {
            LOG.warn("accepts: can't evaluate expression {} for alarm {} because: {}", new Object[]{this.getRule(), alarm.getUei(), e.getMessage()});
        }
        LOG.debug("accepts: checking {} ? {}", (Object)this.getRule(), (Object)passed);
        return passed;
    }

    public void update(SendmailMessage message) {
        if (this.m_from != null) {
            message.setFrom(this.m_from);
        }
        if (this.m_to != null) {
            message.setTo(this.m_to);
        }
        if (this.m_subject != null) {
            message.setSubject(this.m_subject);
        }
        if (this.m_body != null) {
            message.setBody(this.m_body);
        }
    }
}

