/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.discovery;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.opennms.core.logging.Logging;
import org.opennms.core.spring.BeanUtils;
import org.opennms.netmgt.config.DiscoveryConfigFactory;
import org.opennms.netmgt.config.discovery.Detector;
import org.opennms.netmgt.config.discovery.DiscoveryConfiguration;
import org.opennms.netmgt.config.discovery.Parameter;
import org.opennms.netmgt.discovery.Discovery;
import org.opennms.netmgt.discovery.DiscoveryJob;
import org.opennms.netmgt.discovery.DiscoveryResult;
import org.opennms.netmgt.discovery.DiscoveryTaskExecutor;
import org.opennms.netmgt.discovery.RangeChunker;
import org.opennms.netmgt.events.api.EventForwarder;
import org.opennms.netmgt.icmp.proxy.LocationAwarePingClient;
import org.opennms.netmgt.icmp.proxy.PingSweepRequestBuilder;
import org.opennms.netmgt.icmp.proxy.PingSweepSummary;
import org.opennms.netmgt.model.discovery.IPPollRange;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.LocationAwareDetectorClient;
import org.opennms.netmgt.xml.event.Log;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class DiscoveryTaskExecutorImpl
implements DiscoveryTaskExecutor {
    private static final Logger LOG = LoggerFactory.getLogger(DiscoveryTaskExecutorImpl.class);
    @Autowired
    private RangeChunker rangeChunker;
    @Autowired
    private LocationAwarePingClient locationAwarePingClient;
    @Autowired
    private EventForwarder eventForwarder;
    @Autowired(required=false)
    private LocationAwareDetectorClient locationAwareDetectorClient;
    private final AtomicInteger taskIdTracker = new AtomicInteger();

    @Override
    public CompletableFuture<Void> handleDiscoveryTask(DiscoveryConfiguration config) {
        final Map<String, List<DiscoveryJob>> jobsByLocation = this.rangeChunker.chunk(config);
        if (jobsByLocation.size() == 0) {
            LOG.info("No IP addresses to discover.");
            return CompletableFuture.completedFuture(null);
        }
        final int taskId = this.taskIdTracker.incrementAndGet();
        final ArrayList futures = new ArrayList(jobsByLocation.keySet().size());
        Logging.withPrefix((String)Discovery.getLoggingCategory(), (Runnable)new Runnable(){

            @Override
            public void run() {
                jobsByLocation.entrySet().stream().map(e -> DiscoveryTaskExecutorImpl.this.triggerJobsAsync((String)e.getKey(), (List)e.getValue(), taskId)).forEach(futures::add);
            }
        });
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
    }

    private CompletableFuture<Void> triggerJobsAsync(String location, List<DiscoveryJob> jobs, int taskId) {
        LOG.debug("Processing {} jobs at location {} (on task #{}).", new Object[]{jobs.size(), location, taskId});
        LinkedList<DiscoveryJob> queue = new LinkedList<DiscoveryJob>(jobs);
        AtomicInteger jobIndexTracker = new AtomicInteger();
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.triggerNextJobAsync(location, queue, jobIndexTracker, jobs.size(), taskId, future);
        return future;
    }

    private void triggerNextJobAsync(String location, Queue<DiscoveryJob> jobs, AtomicInteger jobIndexTracker, int totalNumberOfJobs, int taskId, CompletableFuture<Void> future) {
        DiscoveryJob job = jobs.poll();
        if (job == null) {
            future.complete(null);
            return;
        }
        PingSweepRequestBuilder builder = this.locationAwarePingClient.sweep().withLocation(job.getLocation()).withPacketsPerSecond(job.getPacketsPerSecond());
        for (IPPollRange range : job.getRanges()) {
            try {
                InetAddress begin = InetAddress.getByAddress(range.getAddressRange().getBegin());
                InetAddress end = InetAddress.getByAddress(range.getAddressRange().getEnd());
                builder.withRange(begin, end, range.getRetries(), range.getTimeout(), TimeUnit.MILLISECONDS);
            }
            catch (UnknownHostException e) {
                LOG.error("Failed to retrieve addresses from range: {}. The range will be skipped.", (Throwable)e);
            }
        }
        int jobIndex = jobIndexTracker.incrementAndGet();
        LOG.debug("Starting job {} of {} at location {} (on task #{}).", new Object[]{jobIndex, totalNumberOfJobs, location, taskId});
        builder.execute().whenComplete((summary, ex) -> Logging.withPrefix((String)Discovery.getLoggingCategory(), (Runnable)new Runnable(){
            final /* synthetic */ PingSweepSummary val$summary;
            final /* synthetic */ DiscoveryJob val$job;
            final /* synthetic */ int val$jobIndex;
            final /* synthetic */ int val$totalNumberOfJobs;
            final /* synthetic */ String val$location;
            final /* synthetic */ int val$taskId;
            final /* synthetic */ Queue val$jobs;
            final /* synthetic */ AtomicInteger val$jobIndexTracker;
            final /* synthetic */ CompletableFuture val$future;
            final /* synthetic */ Throwable val$ex;
            {
                this.val$summary = pingSweepSummary;
                this.val$job = discoveryJob;
                this.val$jobIndex = n;
                this.val$totalNumberOfJobs = n2;
                this.val$location = string;
                this.val$taskId = n3;
                this.val$jobs = queue;
                this.val$jobIndexTracker = atomicInteger;
                this.val$future = completableFuture;
                this.val$ex = throwable;
            }

            @Override
            public void run() {
                if (this.val$summary != null) {
                    CompletableFuture<List<DiscoveryResult>> resultsFuture = DiscoveryTaskExecutorImpl.this.performDetection(this.val$job.getLocation(), this.val$summary, this.val$job.getConfig());
                    resultsFuture.whenComplete((results, throwable) -> {
                        LOG.debug("Job {} of {} at location {} (on task #{}) completed succesfully.", new Object[]{this.val$jobIndex, this.val$totalNumberOfJobs, this.val$location, this.val$taskId});
                        Log eventLog = DiscoveryTaskExecutorImpl.toNewSuspectEvents(this.val$job, results);
                        if (eventLog.getEvents() != null && eventLog.getEvents().getEventCount() >= 1) {
                            DiscoveryTaskExecutorImpl.this.eventForwarder.sendNow(eventLog);
                        }
                        DiscoveryTaskExecutorImpl.this.triggerNextJobAsync(this.val$location, this.val$jobs, this.val$jobIndexTracker, this.val$totalNumberOfJobs, this.val$taskId, this.val$future);
                    });
                } else {
                    LOG.error("An error occurred while processing job {} of {} at location {} (on task #{}). No newSuspect events will be generated.", new Object[]{this.val$jobIndex, this.val$totalNumberOfJobs, this.val$location, this.val$taskId, this.val$ex});
                    DiscoveryTaskExecutorImpl.this.triggerNextJobAsync(this.val$location, this.val$jobs, this.val$jobIndexTracker, this.val$totalNumberOfJobs, this.val$taskId, this.val$future);
                }
            }
        }));
    }

    private static Log toNewSuspectEvents(DiscoveryJob job, List<DiscoveryResult> results) {
        Log eventLog = new Log();
        for (DiscoveryResult entry : results) {
            EventBuilder eb = new EventBuilder("uei.opennms.org/internal/discovery/newSuspect", "Discovery");
            eb.setInterface(entry.getAddress());
            eb.addParam("RTT", entry.getPingDuration().doubleValue());
            if (job.getForeignSource() != null) {
                eb.addParam("foreignSource", job.getForeignSource());
            }
            if (job.getLocation() != null) {
                eb.addParam("location", job.getLocation());
            }
            eventLog.addEvent(eb.getEvent());
        }
        return eventLog;
    }

    private CompletableFuture<List<DiscoveryResult>> performDetection(String location, PingSweepSummary summary, DiscoveryConfiguration config) {
        List<CompletableFuture> futures = summary.getResponses().entrySet().stream().map(entry -> this.launchDetectors((InetAddress)entry.getKey(), (Double)entry.getValue(), location, config)).collect(Collectors.toList());
        CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
        CompletionStage futureList = allFutures.thenApply(result -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
        return ((CompletableFuture)futureList).thenApply(results -> results.stream().filter(DiscoveryResult::getDetectResult).collect(Collectors.toList()));
    }

    private CompletableFuture<DiscoveryResult> launchDetectors(InetAddress inetAddress, Double pingDuration, String location, DiscoveryConfiguration config) {
        CompletionStage<DiscoveryResult> future = new CompletableFuture<DiscoveryResult>();
        DiscoveryConfigFactory configFactory = new DiscoveryConfigFactory(config);
        List detectors = configFactory.getListOfDetectors(inetAddress, location);
        if (detectors.size() > 0) {
            try {
                List<CompletableFuture> futures = detectors.stream().map(detector -> this.detect((Detector)detector, inetAddress, location)).collect(Collectors.toList());
                CompletableFuture<Void> allFutures = CompletableFuture.allOf(futures.toArray(new CompletableFuture[futures.size()]));
                CompletionStage futureList = allFutures.thenApply(result -> futures.stream().map(CompletableFuture::join).collect(Collectors.toList()));
                future = ((CompletableFuture)futureList).thenApply(results -> {
                    boolean allResult = results.stream().allMatch(result -> result);
                    return new DiscoveryResult(allResult, inetAddress, pingDuration);
                });
                return future;
            }
            catch (Exception e) {
                LOG.error("Exception while performing detection in discovery for IP Address {} at location {}", new Object[]{inetAddress.getHostAddress(), location, e});
                future.complete(new DiscoveryResult(false, inetAddress, pingDuration));
            }
        } else {
            future.complete(new DiscoveryResult(true, inetAddress, pingDuration));
        }
        return future;
    }

    private CompletableFuture<Boolean> detect(Detector detector, InetAddress inetAddress, String location) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        try {
            LOG.info("Attemping to detect '{}' service on IP Address {} at location {}", new Object[]{detector.getName(), inetAddress.getHostAddress(), location});
            Map<String, String> attributes = detector.getParameters().stream().collect(Collectors.toMap(Parameter::getKey, Parameter::getValue));
            CompletableFuture result = this.getLocationAwareDetectorClient().detect().withAddress(inetAddress).withClassName(detector.getClassName()).withLocation(location).withAttributes(attributes).execute();
            result.whenComplete((response, ex) -> Logging.withPrefix((String)Discovery.getLoggingCategory(), (Runnable)new Runnable(){
                final /* synthetic */ Throwable val$ex;
                final /* synthetic */ Detector val$detector;
                final /* synthetic */ InetAddress val$inetAddress;
                final /* synthetic */ String val$location;
                final /* synthetic */ CompletableFuture val$future;
                final /* synthetic */ Boolean val$response;
                {
                    this.val$ex = throwable;
                    this.val$detector = detector;
                    this.val$inetAddress = inetAddress;
                    this.val$location = string;
                    this.val$future = completableFuture;
                    this.val$response = bl;
                }

                @Override
                public void run() {
                    if (this.val$ex != null) {
                        LOG.error("Exception while detecting '{}' service on IP Address {} at location {} ", new Object[]{this.val$detector.getName(), this.val$inetAddress.getHostAddress(), this.val$location, this.val$ex});
                        this.val$future.complete(false);
                    } else {
                        LOG.info("Service Detection {} for service '{}' on IP Address {} at location {}", new Object[]{this.val$response != false ? "succeeded" : "failed", this.val$detector.getName(), this.val$inetAddress.getHostAddress(), this.val$location});
                        this.val$future.complete(this.val$response);
                    }
                }
            }));
        }
        catch (Exception e) {
            LOG.error("Exception while detecting {} service on IP Address {} at location {} ", new Object[]{detector.getName(), inetAddress.getHostAddress(), location, e});
            future.complete(false);
        }
        return future;
    }

    public void setRangeChunker(RangeChunker rangeChunker) {
        this.rangeChunker = rangeChunker;
    }

    public void setLocationAwarePingClient(LocationAwarePingClient locationAwarePingClient) {
        this.locationAwarePingClient = locationAwarePingClient;
    }

    public void setEventForwarder(EventForwarder eventForwarder) {
        this.eventForwarder = eventForwarder;
    }

    public void setLocationAwareDetectorClient(LocationAwareDetectorClient locationAwareDetectorClient) {
        this.locationAwareDetectorClient = locationAwareDetectorClient;
    }

    public LocationAwareDetectorClient getLocationAwareDetectorClient() {
        if (this.locationAwareDetectorClient == null) {
            return (LocationAwareDetectorClient)BeanUtils.getBean((String)"provisiondContext", (String)"locationAwareDetectorClient", LocationAwareDetectorClient.class);
        }
        return this.locationAwareDetectorClient;
    }
}

