/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.header;

import io.pkts.buffer.Buffer;
import io.pkts.buffer.Buffers;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.header.impl.CSeqHeaderImpl;
import io.pkts.packet.sip.impl.PreConditions;
import io.pkts.packet.sip.impl.SipParser;
import java.io.IOException;

public interface CSeqHeader
extends SipHeader {
    public static final String METHOD_CANNOT_BE_NULL_OR_EMPTY = "Method cannot be null or empty";
    public static final Buffer NAME = Buffers.wrap((String)"CSeq");

    public Buffer getMethod();

    public long getSeqNumber();

    @Override
    public CSeqHeader clone();

    @Override
    public Builder copy();

    @Override
    default public boolean isCSeqHeader() {
        return true;
    }

    @Override
    default public CSeqHeader toCSeqHeader() {
        return this;
    }

    public static CSeqHeader frame(Buffer value) throws SipParseException {
        try {
            Buffer valueCopy = value.slice();
            Buffer cseq = SipParser.expectDigit(value);
            long number = Long.parseLong(cseq.toString());
            SipParser.consumeWS(value);
            Buffer method = value.readLine();
            return new CSeqHeaderImpl(number, method, valueCopy);
        }
        catch (IOException e) {
            throw new SipParseException(value.getReaderIndex(), "Could not read from the underlying stream while parsing method");
        }
    }

    public static Builder withMethod(Buffer method) {
        return new Builder(PreConditions.assertNotEmpty(method, METHOD_CANNOT_BE_NULL_OR_EMPTY));
    }

    public static Builder withMethod(String method) {
        return new Builder(Buffers.wrap((String)PreConditions.assertNotEmpty(method, METHOD_CANNOT_BE_NULL_OR_EMPTY)));
    }

    public static class Builder
    implements SipHeader.Builder<CSeqHeader> {
        private long cseq;
        private Buffer method;

        private Builder(Buffer method) {
            this.method = method;
        }

        public Builder withCSeq(long cseq) throws SipParseException {
            PreConditions.assertArgument(cseq >= 0L, "Sequence number must be greater or equal to zero");
            this.cseq = cseq;
            return this;
        }

        public Builder increment() {
            ++this.cseq;
            return this;
        }

        public Builder withMethod(Buffer method) throws SipParseException {
            PreConditions.assertNotEmpty(method, CSeqHeader.METHOD_CANNOT_BE_NULL_OR_EMPTY);
            this.method = method;
            return this;
        }

        public Builder withMethod(String method) throws SipParseException {
            this.method = Buffers.wrap((String)PreConditions.assertNotEmpty(method, CSeqHeader.METHOD_CANNOT_BE_NULL_OR_EMPTY));
            return this;
        }

        public Builder withValue(Buffer value) {
            throw new RuntimeException("Not implemented yet");
        }

        @Override
        public CSeqHeader build() {
            int size = Buffers.stringSizeOf((long)this.cseq);
            Buffer value = Buffers.createBuffer((int)(size + 1 + this.method.getReadableBytes()));
            value.writeAsString(this.cseq);
            value.write((byte)32);
            this.method.getBytes(value);
            return new CSeqHeaderImpl(this.cseq, this.method, value);
        }
    }
}

