/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.classification.internal.value;

import java.util.List;
import java.util.Objects;
import org.opennms.netmgt.flows.classification.internal.value.StringValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangedValue {
    private static final Logger LOG = LoggerFactory.getLogger(RangedValue.class);
    private final int start;
    private final int end;

    public RangedValue(String input) {
        this(new StringValue(input));
    }

    public RangedValue(StringValue input) {
        Objects.requireNonNull(input);
        int[] range = this.verifyInput(input);
        this.start = range[0];
        this.end = range[1];
    }

    public RangedValue(int start, int end) {
        this.verifyBounds(start, end);
        this.start = start;
        this.end = end;
    }

    public boolean isInRange(int value) {
        return value >= this.start && value <= this.end;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    private void verifyBounds(int lowerBound, int higherBound) {
        if (lowerBound > higherBound) {
            throw new IllegalArgumentException("Range is not defined correctly");
        }
    }

    private int[] verifyInput(StringValue input) {
        if (input.isNullOrEmpty()) {
            throw new IllegalArgumentException("Range must not be null or empty");
        }
        List<StringValue> range = input.splitBy("-");
        if (range.size() > 2) {
            LOG.warn("Received multiple ranges {}. Will only use {}", range, range.subList(0, 2));
        }
        for (int i = 0; i < Math.min(range.size(), 2); ++i) {
            try {
                Integer.parseInt(range.get(i).getValue());
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Value '" + String.valueOf(range.get(i)) + "' is not a valid number", ex);
            }
        }
        int lowerBound = Integer.parseInt(range.get(0).getValue());
        int higherBound = range.size() == 1 ? lowerBound : Integer.parseInt(range.get(1).getValue());
        this.verifyBounds(lowerBound, higherBound);
        return new int[]{lowerBound, higherBound};
    }
}

