/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.phreak;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import org.drools.core.phreak.ReactiveCollection;
import org.drools.core.phreak.ReactiveObject;
import org.drools.core.phreak.ReactiveObjectUtil;
import org.drools.core.reteoo.Tuple;

public class ReactiveList<T>
extends ReactiveCollection<T, List<T>>
implements List<T> {
    public ReactiveList() {
        this(new ArrayList());
    }

    public ReactiveList(List<T> wrapped) {
        super(wrapped);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        boolean result = ((List)this.wrapped).addAll(index, c);
        if (result) {
            for (T element : c) {
                ReactiveObjectUtil.notifyModification(element, this.getLeftTuples(), ReactiveObjectUtil.ModificationType.ADD);
                if (!(element instanceof ReactiveObject)) continue;
                for (Tuple lts : this.getLeftTuples()) {
                    ((ReactiveObject)element).addLeftTuple(lts);
                }
            }
        }
        return result;
    }

    @Override
    public T get(int index) {
        return (T)((List)this.wrapped).get(index);
    }

    @Override
    public T set(int index, T element) {
        T previous = ((List)this.wrapped).set(index, element);
        if (previous != element) {
            ReactiveObjectUtil.notifyModification(element, this.getLeftTuples(), ReactiveObjectUtil.ModificationType.ADD);
            if (element instanceof ReactiveObject) {
                for (Tuple lts : this.getLeftTuples()) {
                    ((ReactiveObject)element).addLeftTuple(lts);
                }
            }
            if (previous instanceof ReactiveObject) {
                for (Tuple lts : this.getLeftTuples()) {
                    ((ReactiveObject)previous).removeLeftTuple(lts);
                }
            }
            ReactiveObjectUtil.notifyModification(previous, this.getLeftTuples(), ReactiveObjectUtil.ModificationType.REMOVE);
        }
        return previous;
    }

    @Override
    public void add(int index, T element) {
        ((List)this.wrapped).add(index, element);
        ReactiveObjectUtil.notifyModification(element, this.getLeftTuples(), ReactiveObjectUtil.ModificationType.ADD);
        if (element instanceof ReactiveObject) {
            for (Tuple lts : this.getLeftTuples()) {
                ((ReactiveObject)element).addLeftTuple(lts);
            }
        }
    }

    @Override
    public T remove(int index) {
        Object result = ((List)this.wrapped).remove(index);
        if (result instanceof ReactiveObject) {
            for (Tuple lts : this.getLeftTuples()) {
                ((ReactiveObject)result).removeLeftTuple(lts);
            }
        }
        ReactiveObjectUtil.notifyModification(result, this.getLeftTuples(), ReactiveObjectUtil.ModificationType.REMOVE);
        return (T)result;
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.wrapped).indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.wrapped).lastIndexOf(o);
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        ReactiveList result = new ReactiveList(((List)this.wrapped).subList(fromIndex, toIndex));
        for (Tuple lts : this.getLeftTuples()) {
            result.addLeftTuple(lts);
        }
        return result;
    }

    @Override
    public ListIterator<T> listIterator() {
        return new ReactiveListIterator(((List)this.wrapped).listIterator());
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new ReactiveListIterator(((List)this.wrapped).listIterator(index));
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ReactiveList[").append(this.wrapped).append("]");
        return builder.toString();
    }

    private class ReactiveListIterator
    extends ReactiveCollection.ReactiveIterator<ListIterator<T>>
    implements ListIterator<T> {
        public ReactiveListIterator(ListIterator<T> wrapped) {
            super((ReactiveCollection)ReactiveList.this, wrapped);
        }

        @Override
        public int nextIndex() {
            return ((ListIterator)this.wrapped).nextIndex();
        }

        @Override
        public int previousIndex() {
            return ((ListIterator)this.wrapped).previousIndex();
        }

        @Override
        public boolean hasPrevious() {
            return ((ListIterator)this.wrapped).hasPrevious();
        }

        @Override
        public T previous() {
            this.last = ((ListIterator)this.wrapped).previous();
            return this.last;
        }

        @Override
        public void set(T e) {
            if (this.last != null) {
                ((ListIterator)this.wrapped).set(e);
                if (this.last != e) {
                    ReactiveObjectUtil.notifyModification(e, ReactiveList.this.getLeftTuples(), ReactiveObjectUtil.ModificationType.ADD);
                    if (e instanceof ReactiveObject) {
                        for (Tuple lts : ReactiveList.this.getLeftTuples()) {
                            ((ReactiveObject)e).addLeftTuple(lts);
                        }
                    }
                    if (this.last instanceof ReactiveObject) {
                        for (Tuple lts : ReactiveList.this.getLeftTuples()) {
                            ((ReactiveObject)this.last).removeLeftTuple(lts);
                        }
                    }
                    ReactiveObjectUtil.notifyModification(this.last, ReactiveList.this.getLeftTuples(), ReactiveObjectUtil.ModificationType.REMOVE);
                }
                this.last = e;
            }
        }

        @Override
        public void add(T e) {
            ((ListIterator)this.wrapped).add(e);
            ReactiveObjectUtil.notifyModification(e, ReactiveList.this.getLeftTuples(), ReactiveObjectUtil.ModificationType.ADD);
            if (e instanceof ReactiveObject) {
                for (Tuple lts : ReactiveList.this.getLeftTuples()) {
                    ((ReactiveObject)e).addLeftTuple(lts);
                }
            }
            this.last = null;
        }
    }
}

