/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.features.jmxconfiggenerator.jmxconfig;

import com.google.common.collect.Collections2;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.JMException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.FilterCriteria;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.MBeanServerQuery;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.MBeanServerQueryException;
import org.opennms.features.jmxconfiggenerator.jmxconfig.query.QueryResult;
import org.opennms.features.jmxconfiggenerator.log.LogAdapter;
import org.opennms.features.namecutter.NameCutter;
import org.opennms.netmgt.collection.api.AttributeType;
import org.opennms.netmgt.config.collectd.jmx.Attrib;
import org.opennms.netmgt.config.collectd.jmx.CompAttrib;
import org.opennms.netmgt.config.collectd.jmx.CompMember;
import org.opennms.netmgt.config.collectd.jmx.JmxCollection;
import org.opennms.netmgt.config.collectd.jmx.JmxDatacollectionConfig;
import org.opennms.netmgt.config.collectd.jmx.Mbean;
import org.opennms.netmgt.config.collectd.jmx.Rrd;

public class JmxDatacollectionConfiggenerator {
    private final LogAdapter logger;
    private final List<String> standardVmBeans;
    private final List<String> numbers;
    protected final Map<String, Integer> aliasMap = new HashMap<String, Integer>();
    protected final List<String> aliasList = new ArrayList<String>();
    private final Rrd rrd;
    private final NameCutter nameCutter = new NameCutter();

    public JmxDatacollectionConfiggenerator(LogAdapter logger) {
        this.logger = logger;
        this.standardVmBeans = new ArrayList<String>();
        this.standardVmBeans.add("JMImplementation");
        this.standardVmBeans.add("com.sun.management");
        this.standardVmBeans.add("java.lang");
        this.standardVmBeans.add("java.nio");
        this.standardVmBeans.add("java.util.logging");
        this.numbers = new ArrayList<String>();
        this.numbers.add("int");
        this.numbers.add("long");
        this.numbers.add("double");
        this.numbers.add("float");
        this.numbers.add("java.lang.Long");
        this.numbers.add("java.lang.Integer");
        this.numbers.add("java.lang.Double");
        this.numbers.add("java.lang.Float");
        this.rrd = new Rrd();
        this.rrd.setStep(300);
        this.rrd.addRra("RRA:AVERAGE:0.5:1:2016");
        this.rrd.addRra("RRA:AVERAGE:0.5:12:1488");
        this.rrd.addRra("RRA:AVERAGE:0.5:288:366");
        this.rrd.addRra("RRA:MAX:0.5:288:366");
        this.rrd.addRra("RRA:MIN:0.5:288:366");
    }

    @Deprecated
    public JmxDatacollectionConfig generateJmxConfigModel(MBeanServerConnection mBeanServerConnection, String serviceName, Boolean runStandardVmBeans, Boolean skipNonNumber, Map<String, String> dictionary) throws MBeanServerQueryException, IOException, JMException {
        ArrayList<String> ids = new ArrayList<String>();
        ids.add("*:*");
        return this.generateJmxConfigModel(ids, mBeanServerConnection, serviceName, runStandardVmBeans, skipNonNumber, dictionary);
    }

    public JmxDatacollectionConfig generateJmxConfigModel(List<String> ids, MBeanServerConnection mBeanServerConnection, String serviceName, Boolean runStandardVmBeans, Boolean skipNonNumber, Map<String, String> dictionary) throws MBeanServerQueryException, IOException, JMException {
        this.logger.debug("Startup values: \n serviceName: " + serviceName + "\n runStandardVmBeans: " + runStandardVmBeans + "\n dictionary" + String.valueOf(dictionary), new Object[0]);
        this.aliasList.clear();
        this.aliasMap.clear();
        this.nameCutter.setDictionary(dictionary);
        QueryResult queryResult = this.queryMbeanServer(ids, mBeanServerConnection, runStandardVmBeans);
        JmxDatacollectionConfig xmlJmxDatacollectionConfig = this.createJmxDataCollectionConfig(serviceName, this.rrd);
        JmxCollection xmlJmxCollection = (JmxCollection)xmlJmxDatacollectionConfig.getJmxCollectionList().get(0);
        for (QueryResult.MBeanResult eachMBeanResult : queryResult.getMBeanResults()) {
            ObjectName objectName = eachMBeanResult.objectName;
            Mbean xmlMbean = this.createMbean(objectName);
            QueryResult.AttributeResult attributeResult = eachMBeanResult.attributeResult;
            for (MBeanAttributeInfo jmxBeanAttributeInfo : attributeResult.attributes) {
                CompAttrib compAttrib;
                if ("javax.management.openmbean.CompositeData".equals(jmxBeanAttributeInfo.getType()) && (compAttrib = this.createCompAttrib(mBeanServerConnection, objectName, jmxBeanAttributeInfo, skipNonNumber)) != null) {
                    xmlMbean.addCompAttrib(compAttrib);
                }
                if (skipNonNumber.booleanValue() && !this.numbers.contains(jmxBeanAttributeInfo.getType())) {
                    this.logger.warn("The type of attribute '{}' is '{}' and '--skipNonNumber' is set. Ignoring.", jmxBeanAttributeInfo.getName(), jmxBeanAttributeInfo.getType());
                    continue;
                }
                Attrib xmlJmxAttribute = this.createAttr(jmxBeanAttributeInfo);
                xmlMbean.addAttrib(xmlJmxAttribute);
            }
            if (xmlMbean.getAttribList().isEmpty() && xmlMbean.getCompAttribList().isEmpty()) continue;
            xmlJmxCollection.addMbean(xmlMbean);
        }
        if (xmlJmxCollection.getMbeans().size() != queryResult.getMBeanResults().size()) {
            this.logger.warn("Queried {} MBeans, but only got {} in the result set.", queryResult.getMBeanResults().size(), xmlJmxCollection.getMbeans().size());
        }
        return xmlJmxDatacollectionConfig;
    }

    private JmxDatacollectionConfig createJmxDataCollectionConfig(String serviceName, Rrd rrd) {
        JmxDatacollectionConfig xmlJmxDatacollectionConfig = new JmxDatacollectionConfig();
        JmxCollection xmlJmxCollection = new JmxCollection();
        xmlJmxCollection.setName("JSR160-" + serviceName);
        xmlJmxCollection.setRrd(rrd);
        xmlJmxDatacollectionConfig.addJmxCollection(xmlJmxCollection);
        return xmlJmxDatacollectionConfig;
    }

    private QueryResult queryMbeanServer(List<String> ids, MBeanServerConnection mBeanServerConnection, boolean runStandardVmBeans) throws MBeanServerQueryException {
        MBeanServerQuery query = new MBeanServerQuery().withFilters(ids).fetchValues(false).showMBeansWithoutAttributes(false).sort(true);
        if (!runStandardVmBeans) {
            query.withIgnoresFilter(Collections2.transform(this.standardVmBeans, input -> input + ":*"));
        }
        QueryResult result = query.execute(mBeanServerConnection);
        return result;
    }

    protected boolean matches(Collection<FilterCriteria> criteriaList, ObjectName objectName, MBeanAttributeInfo mBeanAttributeInfo) {
        for (FilterCriteria eachCriteria : criteriaList) {
            if (!eachCriteria.matches(mBeanAttributeInfo)) continue;
            return true;
        }
        return false;
    }

    public void writeJmxConfigFile(JmxDatacollectionConfig jmxDatacollectionConfigModel, String outFile) throws IOException {
        JaxbUtils.marshal((Object)jmxDatacollectionConfigModel, (File)new File(outFile));
    }

    private Mbean createMbean(ObjectName objectName) {
        String typeAndOthers = objectName.getCanonicalName().substring(objectName.getCanonicalName().lastIndexOf("=") + 1);
        Mbean mbean = new Mbean();
        mbean.setObjectname(objectName.toString());
        mbean.setName(objectName.getDomain() + "." + typeAndOthers);
        return mbean;
    }

    private CompAttrib createCompAttrib(MBeanServerConnection jmxServerConnection, ObjectName objectName, MBeanAttributeInfo jmxMBeanAttributeInfo, Boolean skipNonNumber) throws JMException, IOException {
        Boolean contentAdded = false;
        CompAttrib xmlCompAttrib = new CompAttrib();
        xmlCompAttrib.setName(jmxMBeanAttributeInfo.getName());
        xmlCompAttrib.setType("Composite");
        xmlCompAttrib.setAlias(jmxMBeanAttributeInfo.getName());
        CompositeData compositeData = (CompositeData)jmxServerConnection.getAttribute(objectName, jmxMBeanAttributeInfo.getName());
        if (compositeData == null) {
            this.logger.warn("compositeData for jmxObjectInstance.getObjectName: '{}', jmxMBeanAttributeInfo.getName: '{}' not found. Ignoring.", objectName, jmxMBeanAttributeInfo.getName());
        }
        if (compositeData != null) {
            Set<String> keys = compositeData.getCompositeType().keySet();
            for (String key : keys) {
                Object compositeEntry = compositeData.get(key);
                if (skipNonNumber.booleanValue() && !this.numbers.contains(compositeEntry.getClass().getName())) {
                    this.logger.warn("The type of composite member '{}/{}' is '{}' and '--skipNonNumber' is set. Ignoring.", jmxMBeanAttributeInfo.getName(), key, compositeEntry.getClass().getName());
                    continue;
                }
                contentAdded = true;
                CompMember xmlCompMember = new CompMember();
                xmlCompMember.setName(key);
                String alias = this.nameCutter.trimByDictionary(jmxMBeanAttributeInfo.getName() + JmxDatacollectionConfiggenerator.capitalize(key));
                alias = this.createAndRegisterUniqueAlias(alias);
                xmlCompMember.setAlias(alias);
                xmlCompMember.setType(AttributeType.GAUGE);
                xmlCompAttrib.addCompMember(xmlCompMember);
            }
        }
        if (contentAdded.booleanValue()) {
            return xmlCompAttrib;
        }
        return null;
    }

    private Attrib createAttr(MBeanAttributeInfo jmxMBeanAttributeInfo) {
        Attrib xmlJmxAttribute = new Attrib();
        xmlJmxAttribute.setType(AttributeType.GAUGE);
        xmlJmxAttribute.setName(jmxMBeanAttributeInfo.getName());
        String alias = this.nameCutter.trimByDictionary(jmxMBeanAttributeInfo.getName());
        alias = this.createAndRegisterUniqueAlias(alias);
        xmlJmxAttribute.setAlias(alias);
        return xmlJmxAttribute;
    }

    protected String createAndRegisterUniqueAlias(String originalAlias) {
        Object uniqueAlias = originalAlias;
        if (!this.aliasMap.containsKey(originalAlias)) {
            this.aliasMap.put(originalAlias, 0);
            uniqueAlias = "0" + (String)uniqueAlias;
        } else {
            this.aliasMap.put(originalAlias, this.aliasMap.get(originalAlias) + 1);
            uniqueAlias = this.aliasMap.get(originalAlias).toString() + originalAlias;
        }
        String uniqueAliasTrimmedTo19Chars = this.nameCutter.trimByCamelCase((String)uniqueAlias, Integer.valueOf(19));
        if (this.aliasList.contains(uniqueAliasTrimmedTo19Chars)) {
            this.logger.error("ALIAS CRASH AT :" + (String)uniqueAlias + "\t as: " + uniqueAliasTrimmedTo19Chars, new Object[0]);
            uniqueAlias = (String)uniqueAlias + "_NAME_CRASH_AS_19_CHAR_VALUE";
        } else {
            uniqueAlias = uniqueAliasTrimmedTo19Chars;
            this.aliasList.add((String)uniqueAlias);
        }
        return uniqueAlias;
    }

    private static String capitalize(String input) {
        if (input != null) {
            return Character.toUpperCase(input.charAt(0)) + input.substring(1);
        }
        return input;
    }
}

