/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.api;

import java.time.Instant;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.opennms.integration.api.v1.flows.Flow;

public interface Flow {
    public Instant getReceivedAt();

    public Instant getTimestamp();

    public Long getBytes();

    public Flow.Direction getDirection();

    public String getDstAddr();

    public Optional<String> getDstAddrHostname();

    public Long getDstAs();

    public Integer getDstMaskLen();

    public Integer getDstPort();

    public Integer getEngineId();

    public Integer getEngineType();

    public Instant getDeltaSwitched();

    public Instant getFirstSwitched();

    public int getFlowRecords();

    public long getFlowSeqNum();

    public Integer getInputSnmp();

    public Integer getIpProtocolVersion();

    public Instant getLastSwitched();

    public String getNextHop();

    public Optional<String> getNextHopHostname();

    public Integer getOutputSnmp();

    public Long getPackets();

    public Integer getProtocol();

    public Flow.SamplingAlgorithm getSamplingAlgorithm();

    public Double getSamplingInterval();

    public String getSrcAddr();

    public Optional<String> getSrcAddrHostname();

    public Long getSrcAs();

    public Integer getSrcMaskLen();

    public Integer getSrcPort();

    public Integer getTcpFlags();

    public Integer getTos();

    default public Integer getDscp() {
        return this.getTos() != null ? Integer.valueOf(this.getTos() >>> 2) : null;
    }

    default public Integer getEcn() {
        return this.getTos() != null ? Integer.valueOf(this.getTos() & 3) : null;
    }

    public Flow.NetflowVersion getNetflowVersion();

    public Integer getVlan();

    public String getNodeIdentifier();

    default public Map<String, Object> getRawMessage() {
        return Collections.EMPTY_MAP;
    }
}

