/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.flows.processing;

import com.google.common.collect.Lists;
import java.util.List;
import org.opennms.netmgt.telemetry.config.api.PackageDefinition;

public class ProcessingOptions {
    public final boolean applicationThresholding;
    public final boolean applicationDataCollection;
    public final List<? extends PackageDefinition> packages;

    private ProcessingOptions(Builder builder) {
        this.applicationThresholding = builder.applicationThresholding;
        this.applicationDataCollection = builder.applicationDataCollection;
        this.packages = builder.packages;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private boolean applicationThresholding;
        private boolean applicationDataCollection;
        private List<? extends PackageDefinition> packages = Lists.newArrayList();

        private Builder() {
        }

        public Builder setApplicationThresholding(boolean applicationThresholding) {
            this.applicationThresholding = applicationThresholding;
            return this;
        }

        public Builder setApplicationDataCollection(boolean applicationDataCollection) {
            this.applicationDataCollection = applicationDataCollection;
            return this;
        }

        public Builder setPackages(List<? extends PackageDefinition> packages) {
            this.packages = packages;
            return this;
        }

        public ProcessingOptions build() {
            return new ProcessingOptions(this);
        }
    }
}

