/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.telemetry.config.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.annotate.JsonCreator;
import org.codehaus.jackson.annotate.JsonProperty;

public class ConnectorTwinConfig {
    public static String CONNECTOR_KEY = "telemetry.connector.config";
    private List<ConnectorConfig> configurations = new ArrayList<ConnectorConfig>();
    private String queueName;

    public ConnectorTwinConfig() {
    }

    @JsonCreator
    public ConnectorTwinConfig(@JsonProperty(value="configurations") List<ConnectorConfig> configurations) {
        this.configurations = configurations != null ? configurations : Collections.emptyList();
    }

    public <E> ConnectorTwinConfig(@JsonProperty(value="queueName") String queueName, @JsonProperty(value="configurations") List<ConnectorConfig> configurations) {
        this.queueName = queueName;
        this.configurations = configurations != null ? configurations : Collections.emptyList();
    }

    @JsonProperty(value="configurations")
    public List<ConnectorConfig> getConfigurations() {
        return this.configurations;
    }

    @JsonProperty(value="queueName")
    public String getQueueName() {
        return this.queueName;
    }

    public Map<String, String> getQueueInMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("queue", this.queueName);
        return map;
    }

    public static class ConnectorConfig {
        private int nodeId;
        private String ipAddress;
        private List<Map<String, String>> parameters;
        private String connectionKey;

        public ConnectorConfig() {
        }

        @JsonCreator
        public ConnectorConfig(@JsonProperty(value="nodeId") int nodeId, @JsonProperty(value="ipAddress") String ipAddress, @JsonProperty(value="connectionKey") String connectionKey, @JsonProperty(value="parameters") List<Map<String, String>> parameters) {
            this.nodeId = nodeId;
            this.ipAddress = ipAddress;
            this.connectionKey = connectionKey;
            this.parameters = parameters != null ? Collections.unmodifiableList(new ArrayList<Map<String, String>>(parameters)) : Collections.emptyList();
        }

        @JsonProperty(value="nodeId")
        public int getNodeId() {
            return this.nodeId;
        }

        @JsonProperty(value="connectionKey")
        public String getConnectionKey() {
            return this.connectionKey;
        }

        @JsonProperty(value="ipAddress")
        public String getIpAddress() {
            return this.ipAddress;
        }

        @JsonProperty(value="parameters")
        public List<Map<String, String>> getParameters() {
            return this.parameters;
        }
    }
}

