/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.reporting.core.svclayer.support;

import org.opennms.api.reporting.ReportService;
import org.opennms.features.reporting.repository.global.GlobalReportRepository;
import org.opennms.reporting.core.svclayer.ReportServiceLocator;
import org.opennms.reporting.core.svclayer.ReportServiceLocatorException;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultReportServiceLocator
implements ApplicationContextAware,
ReportServiceLocator {
    private ApplicationContext m_applicationContext;
    private GlobalReportRepository m_globalReportRepository;

    @Override
    public ReportService getReportService(String reportServiceName) throws ReportServiceLocatorException {
        try {
            return (ReportService)this.m_applicationContext.getBean(reportServiceName, ReportService.class);
        }
        catch (BeansException e) {
            throw new ReportServiceLocatorException("cannot locate report service bean: " + reportServiceName, e);
        }
    }

    @Override
    public ReportService getReportServiceForId(String reportId) throws ReportServiceLocatorException {
        return this.getReportService(this.m_globalReportRepository.getReportService(reportId));
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.m_applicationContext = applicationContext;
    }

    public void setGlobalReportRepository(GlobalReportRepository globalReportRepository) {
        this.m_globalReportRepository = globalReportRepository;
    }
}

