/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.netmgt.timeseries.samplewrite;

import com.codahale.metrics.Gauge;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import com.swrve.ratelimitedlogger.RateLimitedLog;
import java.nio.file.Paths;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import javax.inject.Named;
import org.nustaq.serialization.FSTConfiguration;
import org.opennms.core.ipc.sink.api.DispatchQueue;
import org.opennms.core.ipc.sink.api.QueueCreateFailedException;
import org.opennms.core.ipc.sink.api.WriteFailedException;
import org.opennms.core.ipc.sink.offheap.DataBlocksOffHeapQueue;
import org.opennms.integration.api.v1.timeseries.Sample;
import org.opennms.integration.api.v1.timeseries.StorageException;
import org.opennms.integration.api.v1.timeseries.immutables.ImmutableSample;
import org.opennms.netmgt.timeseries.TimeseriesStorageManager;
import org.opennms.netmgt.timeseries.samplewrite.TimeseriesWriter;
import org.opennms.netmgt.timeseries.samplewrite.TimeseriesWriterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OffheapTimeSeriesWriter
implements TimeseriesWriter {
    private static final Logger LOG = LoggerFactory.getLogger(OffheapTimeSeriesWriter.class);
    private static final RateLimitedLog RATE_LIMITED_LOGGER = RateLimitedLog.withRateLimit((Logger)LOG).maxRate(5).every(Duration.ofSeconds(30L)).build();
    public static final String OFFHEAP_NAME = "offheap";
    public static final int RETRY_TIME = 500;
    private static FSTConfiguration fstConf = FSTConfiguration.createDefaultConfiguration();
    private final DispatchQueue<List<Sample>> queue;
    private final TimeseriesStorageManager storage;
    private final List<Thread> workerPool = new ArrayList<Thread>();
    private final TimeseriesWriterConfig timeseriesWriterConfig;
    private boolean isActive = true;
    private final Meter droppedSamples;
    private final Timer sampleWriteTsTimer;

    public OffheapTimeSeriesWriter(TimeseriesStorageManager storage, TimeseriesWriterConfig timeseriesWriterConfig, @Named(value="timeseriesMetricRegistry") MetricRegistry registry) {
        this.storage = Objects.requireNonNull(storage);
        Objects.requireNonNull(registry);
        this.timeseriesWriterConfig = Objects.requireNonNull(timeseriesWriterConfig);
        registry.register(MetricRegistry.name((String)OFFHEAP_NAME, (String[])new String[]{"max-size"}), (Metric)((Gauge)this.timeseriesWriterConfig::getBufferSize));
        this.droppedSamples = registry.meter(MetricRegistry.name((String)OFFHEAP_NAME, (String[])new String[]{"dropped-samples"}));
        this.sampleWriteTsTimer = registry.timer(MetricRegistry.name((String)OFFHEAP_NAME, (String[])new String[]{"samples.write.ts"}));
        LOG.info("ringBufferSize: {}, numWriterThreads: {}, batchSize: {}, path: {}, maxFileSize: {}", new Object[]{timeseriesWriterConfig.getBufferSize(), timeseriesWriterConfig.getNumWriterThreads(), timeseriesWriterConfig.getBatchSize(), timeseriesWriterConfig.getPath(), timeseriesWriterConfig.getMaxFileSize()});
        this.queue = this.createQueue(timeseriesWriterConfig);
        this.setupConsumerThreads(timeseriesWriterConfig.getNumWriterThreads());
        registry.register(MetricRegistry.name((String)OFFHEAP_NAME, (String[])new String[]{"size"}), (Metric)((Gauge)() -> this.queue.getSize()));
    }

    private void setupConsumerThreads(int numWriterThreads) {
        for (int i = 0; i < numWriterThreads; ++i) {
            Thread consumerThread = new Thread(this::work);
            this.workerPool.add(consumerThread);
            consumerThread.start();
        }
    }

    private DataBlocksOffHeapQueue<List<Sample>> createQueue(TimeseriesWriterConfig timeseriesWriterConfig) throws QueueCreateFailedException {
        return new DataBlocksOffHeapQueue(this.createSerializer(), this.createDeSerializer(), "org.opennms.features.timeseries", Paths.get(timeseriesWriterConfig.getPath(), new String[0]), timeseriesWriterConfig.getBufferSize(), timeseriesWriterConfig.getBatchSize(), timeseriesWriterConfig.getMaxFileSize().longValue());
    }

    private <T> Function<byte[], T> createDeSerializer() {
        return t -> fstConf.asObject(t);
    }

    private <T> Function<T, byte[]> createSerializer() {
        return t -> fstConf.asByteArray(t);
    }

    @Override
    public void insert(List<Sample> samples) {
        try {
            this.queue.enqueue(samples, UUID.randomUUID().toString());
        }
        catch (WriteFailedException e) {
            RATE_LIMITED_LOGGER.warn("Could not insert list of samples.", (Throwable)e);
            this.droppedSamples.mark((long)samples.size());
        }
    }

    @Override
    public void destroy() {
        this.isActive = false;
        for (Thread thread : this.workerPool) {
            thread.interrupt();
        }
    }

    private void work() {
        while (this.isActive) {
            try {
                Timer.Context context = this.sampleWriteTsTimer.time();
                try {
                    List samples = (List)this.queue.dequeue().getValue();
                    this.sentToPlugin(samples);
                    RATE_LIMITED_LOGGER.debug("Storing {} samples", (Object)samples.size());
                }
                finally {
                    if (context == null) continue;
                    context.close();
                }
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    private void sentToPlugin(List<Sample> samples) {
        while (this.isActive) {
            try {
                this.storage.get().store(samples);
                return;
            }
            catch (StorageException e) {
                RATE_LIMITED_LOGGER.warn("Could not send samples to plugin, will try again in {} ms.", (Object)500, (Object)e);
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException ex) {
                    RATE_LIMITED_LOGGER.error("Could not send samples to plugin, got InterruptedException.", (Throwable)e);
                    return;
                }
            }
        }
    }

    static {
        fstConf.registerClass(new Class[]{ArrayList.class, ImmutableSample.class});
    }
}

